/*
 * Decompiled with CFR 0.152.
 */
package vazkii.minetunes.playlist.provider;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import vazkii.minetunes.gui.GuiDevTools;
import vazkii.minetunes.player.chooser.filter.MusicFilter;
import vazkii.minetunes.playlist.MP3Metadata;
import vazkii.minetunes.playlist.Playlist;
import vazkii.minetunes.playlist.provider.IProviderStateCallback;
import vazkii.minetunes.playlist.provider.PlaylistProvider;

public class ProviderDirectory
extends PlaylistProvider {
    public static final ProviderDirectory instance = new ProviderDirectory();

    @Override
    public Playlist provide(File file, IProviderStateCallback callback) {
        this.foundFiles = 0;
        this.processedFiles = 0;
        this.callback = callback;
        TreeSet<MP3Metadata> metadataSet = new TreeSet<MP3Metadata>();
        this.crawlDirectory(file, true, metadataSet);
        this.crawlDirectory(file, false, metadataSet);
        Playlist playlist = new Playlist(file, metadataSet);
        return playlist;
    }

    private void crawlDirectory(File dir, boolean scan, Set<MP3Metadata> metadataSet) {
        GuiDevTools.debugLog("Crawling " + dir.getName());
        for (File file : dir.listFiles(MusicFilter.instance)) {
            if (file.isHidden()) continue;
            if (file.isDirectory()) {
                this.crawlDirectory(file, scan, metadataSet);
                continue;
            }
            if (scan) {
                ++this.foundFiles;
            } else {
                try {
                    this.name = file.getName();
                    metadataSet.add(new MP3Metadata(file));
                    ++this.processedFiles;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.updateState();
        }
    }

    @Override
    public String getDescription() {
        return "Directory-based Playlist Provider";
    }
}

