/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals;

import cyano.basemetals.client.ProxyFunctions;
import cyano.basemetals.entities.EntityBetterVillager;
import cyano.basemetals.events.BucketHandler;
import cyano.basemetals.events.VanillaOreGenDisabler;
import cyano.basemetals.events.VillagerReplacer;
import cyano.basemetals.init.Achievements;
import cyano.basemetals.init.Blocks;
import cyano.basemetals.init.DungeonLoot;
import cyano.basemetals.init.Entities;
import cyano.basemetals.init.Fluids;
import cyano.basemetals.init.ItemGroups;
import cyano.basemetals.init.Items;
import cyano.basemetals.init.Materials;
import cyano.basemetals.init.Recipes;
import cyano.basemetals.init.VillagerTrades;
import cyano.basemetals.init.WorldGen;
import cyano.basemetals.registry.CrusherRecipeRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderVillager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

@Mod(modid="basemetals", name="Base Metals", version="1.7.3", acceptedMinecraftVersions="[1.8.9]")
public class BaseMetals {
    public static BaseMetals INSTANCE = null;
    public static final String MODID = "basemetals";
    public static final String NAME = "Base Metals";
    public static final String VERSION = "1.7.3";
    public static final List<Path> oreSpawnConfigFiles = new LinkedList<Path>();
    public static float chestLootFactor = 0.5f;
    public static boolean enforceHardness = true;
    public static boolean strongHammers = true;
    public static boolean disableVanillaOreGen = false;
    public static boolean forceOreGen = false;
    public static List<String> userCrusherRecipes = new ArrayList<String>();
    public static Path oreSpawnFolder = null;
    public static boolean autoDetectRecipes = true;
    public static boolean enableBetterVillagers = true;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        INSTANCE = this;
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        chestLootFactor = config.getFloat("treasure_chest_loot_factor", "options", 0.5f, 0.0f, 1000.0f, "Controls the rarity of metal ingots being found in treasure chests relative to \nthe frequency of other chest loot items. Set to 0 to disable metal ingots from \nappearing in treasure chests.");
        enforceHardness = config.getBoolean("enforce_hardness", "options", enforceHardness, "If true, then the crack hammer cannot crush ingots into powders if that \ncrackhammer is not hard enough to crush the ingot's ore.");
        strongHammers = config.getBoolean("strong_hammers", "options", strongHammers, "If true, then the crack hammer can crush ingots/ores that a pickaxe of the same \nmaterial can harvest. If false, then your crack hammer must be made of a harder \nmaterial than the ore you are crushing.");
        disableVanillaOreGen = config.getBoolean("disable_standard_ore_generation", "options", disableVanillaOreGen, "If true, then ore generation will be handled exclusively by oregen .json files \n(vanilla ore generation will be disabled)");
        forceOreGen = config.getBoolean("force_ore_generation", "options", forceOreGen, "If true, then ore generation cannot be disabled by other mods.");
        autoDetectRecipes = config.getBoolean("automatic_recipes", "options", autoDetectRecipes, "If true, then Base Metals will scan the Ore Dictionary to automatically add a \nCrack Hammer recipe for every material that has an ore, dust, and ingot.");
        enableBetterVillagers = config.getBoolean("enable_custom_villagers", "options", enableBetterVillagers, "If true, then villagers will be replaced with clones that have a better trading API.\nIf false, then no villager trades will be added");
        ConfigCategory userRecipeCat = config.getCategory("hammer recipes");
        userRecipeCat.setComment("This section allows you to add your own recipes for the Crack Hammer (and other rock \ncrushers). Recipes are specified in semicolon (;) delimited lists of formulas in the \nformat modid:name#y->x*modid:name#y, where x is the number of items in a stack and y \nis the metadata value. Note that both x and y are optional, so you can use the \nformula modid:name->modid:name for most items/blocks. \n\nAll properties in this section will be parsed for formulas, regardless their name. \nThis lets you organize your recipe lists for easier reading.");
        if (userRecipeCat.keySet().size() == 0) {
            Property prop = new Property("custom", "", Property.Type.STRING);
            prop.comment = "Example: minecraft:stained_glass#11->minecraft:dye#4; minecraft:wool->4*minecraft:string";
            userRecipeCat.put("custom", prop);
        }
        for (Property p : userRecipeCat.values()) {
            String[] recipes;
            for (String r : recipes = p.getString().split(";")) {
                String recipe = r.trim();
                if (recipe.isEmpty()) continue;
                if (!recipe.contains("->")) {
                    throw new IllegalArgumentException("Malformed hammer recipe expression '" + recipe + "'. Should be in format 'modid:itemname->modid:itemname'");
                }
                userCrusherRecipes.add(recipe);
            }
        }
        oreSpawnFolder = Paths.get(event.getSuggestedConfigurationFile().toPath().getParent().toString(), "orespawn");
        Path oreSpawnFile = Paths.get(oreSpawnFolder.toString(), "basemetals.json");
        if (!Files.exists(oreSpawnFile, new LinkOption[0])) {
            try {
                Files.createDirectories(oreSpawnFile.getParent(), new FileAttribute[0]);
                Files.write(oreSpawnFile, Arrays.asList("{\n\t\"dimensions\":[\n\t\t{\n\t\t\t\"dimension\":\"+\",\n\t\t\t\"__comment\":\"dimension 0 for overworld, -1 for the nether, 1 for the end, other numbers for dimensions added by other mods, and + for any dimension not already described by this file.\",\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"__comment\":\"These settings are roughly equivalent to the parameters of the CUSTOM world json: blockID = the unlocalized name of a block in the format 'ModID:blockName',blockMeta = the meta data value for the block (optional),size = number of blocks to spawn per ore deposit, variation = vary the size of deposits by +/- this amount, frequency = number of deposits per chunk (can be less than 1, e.g. 0.5 for 1 deposit every 2 chunks), minHeight = minimum spawn height, maxHeight = maximum spawn height, biomes = array of biomes to spawn this ore in (if empty or absent, the ore will spawn in all biomes). Note that the size values in the Minecraft CUSTOM world json do not represent the actual number of blocks spawned, where-as the size value here does represent actual number of blocks. \",\n\t\t\t\t\t\"blockID\":\"basemetals:copper_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":96\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:silver_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":4,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":32\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:tin_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:lead_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":5,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":64\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:zinc_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":5,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":96\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:mercury_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":3,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":32\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:nickel_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":5,\n\t\t\t\t\t\"minHeight\":50,\n\t\t\t\t\t\"maxHeight\":128\n\t\t\t\t}\n\t\t\t]\n\t\t},\n\t\t{\n\t\t\t\"dimension\":-1,\n\t\t\t\"__comment\":\"the nether\",\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:coldiron_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":5,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:adamantine_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":2,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128\n\t\t\t\t}\n\t\t\t]\n\t\t},\n\t\t{\n\t\t\t\"dimension\":1,\n\t\t\t\"__comment\":\"the end\",\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"basemetals:starsteel_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":5,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255\n\t\t\t\t}\n\t\t\t]\n\t\t}\n\t]\n}".split("\n")), Charset.forName("UTF-8"), new OpenOption[0]);
            }
            catch (IOException e) {
                FMLLog.severe((String)("basemetals: Error: Failed to write file " + oreSpawnFile), (Object[])new Object[0]);
            }
        }
        Path oreVanillaSpawnFile = Paths.get(oreSpawnFolder.toString(), "minecraft.json");
        if (disableVanillaOreGen && !Files.exists(oreVanillaSpawnFile, new LinkOption[0])) {
            try {
                Files.createDirectories(oreVanillaSpawnFile.getParent(), new FileAttribute[0]);
                Files.write(oreVanillaSpawnFile, Arrays.asList("{\n\t\"dimensions\":[\n\t\t{\n\t\t\t\"dimension\":\"+\",\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:coal_ore\",\n\t\t\t\t\t\"size\":25,\n\t\t\t\t\t\"variation\":12,\n\t\t\t\t\t\"frequency\":20,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:iron_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":20,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":64,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:gold_ore\",\n\t\t\t\t\t\"size\":8,\n\t\t\t\t\t\"variation\":2,\n\t\t\t\t\t\"frequency\":2,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":32,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:diamond_ore\",\n\t\t\t\t\t\"size\":6,\n\t\t\t\t\t\"variation\":3,\n\t\t\t\t\t\"frequency\":1,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":16,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:redstone_ore\",\n\t\t\t\t\t\"size\":6,\n\t\t\t\t\t\"variation\":3,\n\t\t\t\t\t\"frequency\":8,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":16,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:lapis_ore\",\n\t\t\t\t\t\"size\":5,\n\t\t\t\t\t\"variation\":2,\n\t\t\t\t\t\"frequency\":1,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":32,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:emerald_ore\",\n\t\t\t\t\t\"size\":1,\n\t\t\t\t\t\"variation\":0,\n\t\t\t\t\t\"frequency\":8,\n\t\t\t\t\t\"minHeight\":4,\n\t\t\t\t\t\"maxHeight\":32,\n\t\t\t\t\t\"biomes\":[\n\t\t\t\t\t\t\"Extreme Hills Edge\",\n\t\t\t\t\t\t\"Extreme Hills\"\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:dirt\",\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:gravel\",\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":8,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"__comment\":\"granite\",\n\t\t\t\t\t\"blockID\":\"minecraft:stone\",\n\t\t\t\t\t\"blockMeta\":1,\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"__comment\":\"diorite\",\n\t\t\t\t\t\"blockID\":\"minecraft:stone\",\n\t\t\t\t\t\"blockMeta\":3,\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t},\n\t\t\t\t{\n\t\t\t\t\t\"__comment\":\"andesite\",\n\t\t\t\t\t\"blockID\":\"minecraft:stone\",\n\t\t\t\t\t\"blockMeta\":5,\n\t\t\t\t\t\"size\":112,\n\t\t\t\t\t\"variation\":50,\n\t\t\t\t\t\"frequency\":10,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":255,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t}\n\t\t\t]\n\t\t},\n\t\t{\n\t\t\t\"dimension\":-1,\n\t\t\t\"ores\":[\n\t\t\t\t{\n\t\t\t\t\t\"blockID\":\"minecraft:quartz_ore\",\n\t\t\t\t\t\"size\":15,\n\t\t\t\t\t\"variation\":4,\n\t\t\t\t\t\"frequency\":7,\n\t\t\t\t\t\"minHeight\":0,\n\t\t\t\t\t\"maxHeight\":128,\n\t\t\t\t\t\"biomes\":[\n\n\t\t\t\t\t]\n\t\t\t\t}\n\t\t\t]\n\t\t}\n\t]\n}".split("\n")), Charset.forName("UTF-8"), new OpenOption[0]);
            }
            catch (IOException e) {
                FMLLog.severe((String)("basemetals: Error: Failed to write file " + oreVanillaSpawnFile), (Object[])new Object[0]);
            }
        }
        Fluids.init();
        Materials.init();
        ItemGroups.init();
        Blocks.init();
        Items.init();
        config.save();
        if (event.getSide() == Side.CLIENT) {
            this.clientPreInit(event);
        }
        if (event.getSide() == Side.SERVER) {
            this.serverPreInit(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientPreInit(FMLPreInitializationEvent event) {
        Fluids.bakeModels(MODID);
        RenderingRegistry.registerEntityRenderingHandler(EntityBetterVillager.class, (IRenderFactory)ProxyFunctions.entityVillagerRenderer());
    }

    @SideOnly(value=Side.SERVER)
    private void serverPreInit(FMLPreInitializationEvent event) {
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        File[] files;
        for (File f : files = oreSpawnFolder.toFile().listFiles()) {
            if (!f.getName().toLowerCase().endsWith(".json")) continue;
            oreSpawnConfigFiles.add(f.toPath());
        }
        Fluids.init();
        Recipes.init();
        DungeonLoot.init();
        Entities.init();
        if (enableBetterVillagers) {
            VillagerTrades.init();
        }
        Achievements.init();
        MinecraftForge.EVENT_BUS.register((Object)BucketHandler.getInstance());
        if (enableBetterVillagers) {
            MinecraftForge.EVENT_BUS.register((Object)VillagerReplacer.getInstance());
        }
        if (disableVanillaOreGen) {
            MinecraftForge.ORE_GEN_BUS.register((Object)VanillaOreGenDisabler.getInstance());
        }
        if (event.getSide() == Side.CLIENT) {
            this.clientInit(event);
        }
        if (event.getSide() == Side.SERVER) {
            this.serverInit(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void clientInit(FMLInitializationEvent event) {
        Items.registerItemRenders(event);
        Blocks.registerItemRenders(event);
        RenderingRegistry.registerEntityRenderingHandler(EntityBetterVillager.class, (Render)new RenderVillager(Minecraft.func_71410_x().func_175598_ae()));
    }

    @SideOnly(value=Side.SERVER)
    private void serverInit(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (Path oreSpawnFile : oreSpawnConfigFiles) {
            try {
                WorldGen.loadConfig(oreSpawnFile);
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)("basemetals: Error parsing ore-spawn config file " + oreSpawnFile), (Object[])new Object[0]);
            }
        }
        WorldGen.init();
        for (String recipe : userCrusherRecipes) {
            FMLLog.info((String)("basemetals: adding custom crusher recipe '" + recipe + "'"), (Object[])new Object[0]);
            int i = recipe.indexOf("->");
            String inputStr = recipe.substring(0, i);
            String outputStr = recipe.substring(i + 2, recipe.length());
            ItemStack input = BaseMetals.parseStringAsItemStack(inputStr, true);
            ItemStack output = BaseMetals.parseStringAsItemStack(outputStr, false);
            if (input == null || output == null) {
                FMLLog.severe((String)("Failed to add recipe formula '" + recipe + "' because the blocks/items could not be found"), (Object[])new Object[0]);
                continue;
            }
            CrusherRecipeRegistry.addNewCrusherRecipe(input, output);
        }
        if (autoDetectRecipes) {
            HashSet<String> dictionary = new HashSet<String>();
            dictionary.addAll(Arrays.asList(OreDictionary.getOreNames()));
            for (String entry : dictionary) {
                if (entry.contains("Mercury") || !entry.startsWith("dust")) continue;
                String X = entry.substring("dust".length());
                String dustX = entry;
                String ingotX = "ingot".concat(X);
                String oreX = "ore".concat(X);
                if (!dictionary.contains(oreX) || !dictionary.contains(ingotX) || OreDictionary.getOres((String)dustX).isEmpty()) continue;
                ItemStack dustX1 = ((ItemStack)OreDictionary.getOres((String)dustX).get(0)).func_77946_l();
                dustX1.field_77994_a = 1;
                ItemStack dustX2 = dustX1.func_77946_l();
                dustX2.field_77994_a = 2;
                List oreBlocks = OreDictionary.getOres((String)oreX);
                boolean alreadyHasOreRecipe = true;
                for (ItemStack i : oreBlocks) {
                    alreadyHasOreRecipe = alreadyHasOreRecipe && CrusherRecipeRegistry.getInstance().getRecipeForInputItem(i) != null;
                }
                List ingotStacks = OreDictionary.getOres((String)ingotX);
                boolean alreadyHasIngotRecipe = true;
                for (ItemStack i : ingotStacks) {
                    alreadyHasIngotRecipe = alreadyHasIngotRecipe && CrusherRecipeRegistry.getInstance().getRecipeForInputItem(i) != null;
                }
                if (!alreadyHasOreRecipe) {
                    FMLLog.info((String)"basemetals: automatically adding custom crusher recipe \"%s\" -> %s", (Object[])new Object[]{oreX, dustX2});
                    CrusherRecipeRegistry.addNewCrusherRecipe(oreX, dustX2);
                }
                if (alreadyHasIngotRecipe) continue;
                FMLLog.info((String)"basemetals: automatically adding custom crusher recipe \"%s\" -> %s", (Object[])new Object[]{ingotX, dustX1});
                CrusherRecipeRegistry.addNewCrusherRecipe(ingotX, dustX1);
            }
        }
        if (event.getSide() == Side.CLIENT) {
            this.clientPostInit(event);
        }
        if (event.getSide() == Side.SERVER) {
            this.serverPostInit(event);
        }
        CrusherRecipeRegistry.getInstance().clearCache();
    }

    @SideOnly(value=Side.CLIENT)
    private void clientPostInit(FMLPostInitializationEvent event) {
    }

    @SideOnly(value=Side.SERVER)
    private void serverPostInit(FMLPostInitializationEvent event) {
    }

    public static ItemStack parseStringAsItemStack(String str, boolean allowWildcard) {
        String name;
        String id;
        String mod;
        str = str.trim();
        int count = 1;
        int meta = allowWildcard ? Short.MAX_VALUE : 0;
        int nameStart = 0;
        int nameEnd = str.length();
        if (str.contains("*")) {
            count = Integer.parseInt(str.substring(0, str.indexOf("*")).trim());
            nameStart = str.indexOf("*") + 1;
        }
        if (str.contains("#")) {
            meta = Integer.parseInt(str.substring(str.indexOf("#") + 1, str.length()).trim());
            nameEnd = str.indexOf("#");
        }
        if (GameRegistry.findBlock((String)(mod = (id = str.substring(nameStart, nameEnd).trim()).substring(0, id.indexOf(":")).trim()), (String)(name = id.substring(id.indexOf(":") + 1, id.length()).trim())) != null) {
            return new ItemStack(GameRegistry.findBlock((String)mod, (String)name), count, meta);
        }
        if (GameRegistry.findItem((String)mod, (String)name) != null) {
            return new ItemStack(GameRegistry.findItem((String)mod, (String)name), count, meta);
        }
        FMLLog.severe((String)("Failed to find item or block for ID '" + id + "'"), (Object[])new Object[0]);
        return null;
    }
}

