/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.blocks;

import java.util.function.BiConsumer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class InteractiveFluidBlock
extends BlockFluidClassic {
    private final BiConsumer<World, EntityLivingBase> immersionEffect;
    private final boolean isFlammable;

    public InteractiveFluidBlock(Fluid fluid, boolean flammable, BiConsumer<World, EntityLivingBase> immersionEffect) {
        super(fluid, Material.field_151586_h);
        this.isFlammable = flammable;
        this.immersionEffect = immersionEffect;
    }

    public InteractiveFluidBlock(Fluid fluid, BiConsumer<World, EntityLivingBase> immersionEffect) {
        this(fluid, false, immersionEffect);
    }

    public InteractiveFluidBlock(Fluid fluid) {
        this(fluid, false, null);
    }

    public void func_176199_a(World world, BlockPos coord, Entity entity) {
        if (this.immersionEffect != null && entity instanceof EntityLivingBase) {
            this.immersionEffect.accept(world, (EntityLivingBase)entity);
        }
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isFlammable) {
            return 60;
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isFlammable) {
            return 30;
        }
        return 0;
    }
}

