/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.entities;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;

public class EntityBetterVillager
extends EntityVillager {
    public static final Map<Integer, Map<Integer, List<List<EntityVillager.ITradeList>>>> tradeDatabase = new ConcurrentHashMap<Integer, Map<Integer, List<List<EntityVillager.ITradeList>>>>();
    public static int numTradesAddedPerLevel = 5;
    private int careerID;
    private int careerLevel;
    private MerchantRecipeList buyingList;

    public EntityBetterVillager(World worldIn, int professionId, int career) {
        super(worldIn, professionId);
        this.careerID = career;
    }

    public EntityBetterVillager(World worldIn) {
        this(worldIn, 0, 0);
    }

    public void setMerchantRecipeList(MerchantRecipeList list) {
        Field[] variables;
        this.buyingList = list;
        for (Field v : variables = EntityVillager.class.getDeclaredFields()) {
            if (!v.getType().equals(MerchantRecipeList.class)) continue;
            v.setAccessible(true);
            try {
                v.set((Object)this, this.buyingList);
                break;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                FMLLog.severe((String)"%s: black magic failure! %s", (Object[])new Object[]{((Object)((Object)this)).getClass(), e});
            }
        }
    }

    public MerchantRecipeList getMerchantRecipeList() {
        return this.buyingList;
    }

    public MerchantRecipeList func_70934_b(EntityPlayer player) {
        if (this.getMerchantRecipeList() == null) {
            this.func_175554_cu();
        }
        return this.getMerchantRecipeList();
    }

    public int getCareer() {
        return this.careerID;
    }

    public int getCareerLevel() {
        return this.careerLevel;
    }

    public void setCareerLevel(int lvl) {
        this.careerLevel = lvl;
    }

    public EntityVillager.ITradeList getRandomTrade(Random prng) {
        int prof = this.func_70946_n();
        int career = this.getCareer();
        int level = this.getCareerLevel();
        return EntityBetterVillager.getRandomTrade(prof, career, level, prng);
    }

    public static EntityVillager.ITradeList getRandomTrade(int prof, int career, int level, Random prng) {
        List menu;
        int levelIndex = level - 1;
        List careerList = tradeDatabase.computeIfAbsent(prof, n -> new ConcurrentHashMap()).computeIfAbsent(career, n -> new ArrayList());
        if (levelIndex >= careerList.size() && levelIndex > 0) {
            levelIndex = Math.min(careerList.size() - 1, prng.nextInt(levelIndex));
        }
        if ((menu = (List)careerList.get(levelIndex)) == null || menu.isEmpty()) {
            if (levelIndex > 0) {
                return EntityBetterVillager.getRandomTrade(prof, career, level - 1, prng);
            }
            return null;
        }
        return (EntityVillager.ITradeList)menu.get(prng.nextInt(menu.size()));
    }

    public static void addVillagerTrades(int profession, int career, int level, EntityVillager.ITradeList ... tradeList) {
        int levelIndex = Math.max(0, level - 1);
        List levels = tradeDatabase.computeIfAbsent(profession, n -> new ConcurrentHashMap()).computeIfAbsent(career, n -> new ArrayList());
        while (levels.size() <= levelIndex) {
            levels.add(new ArrayList());
        }
        ((List)levels.get(levelIndex)).addAll(Arrays.asList(tradeList));
    }

    public void func_70037_a(NBTTagCompound tagRoot) {
        super.func_70037_a(tagRoot);
        if (tagRoot.func_74764_b("Career")) {
            this.careerID = tagRoot.func_74762_e("Career");
        }
        if (tagRoot.func_74764_b("CareerLevel")) {
            this.careerLevel = tagRoot.func_74762_e("CareerLevel");
        }
        if (tagRoot.func_150297_b("Offers", 10)) {
            NBTTagCompound nbttagcompound = tagRoot.func_74775_l("Offers");
            this.setMerchantRecipeList(new MerchantRecipeList(nbttagcompound));
        }
    }

    public void func_70014_b(NBTTagCompound tagRoot) {
        super.func_70014_b(tagRoot);
        tagRoot.func_74768_a("Career", this.careerID);
        tagRoot.func_74768_a("CareerLevel", this.careerLevel);
    }

    public boolean func_70039_c(NBTTagCompound tagCompund) {
        if (super.func_70039_c(tagCompund)) {
            tagCompund.func_74778_a("id", (String)EntityList.field_75626_c.get(EntityVillager.class));
            return true;
        }
        return false;
    }

    public IChatComponent func_145748_c_() {
        int careerId = this.getCareer();
        String s = this.func_95999_t();
        if (s != null && s.length() > 0) {
            ChatComponentText chatcomponenttext = new ChatComponentText(s);
            chatcomponenttext.func_150256_b().func_150209_a(this.func_174823_aP());
            chatcomponenttext.func_150256_b().func_179989_a(this.func_110124_au().toString());
            return chatcomponenttext;
        }
        if (this.buyingList == null) {
            this.func_175554_cu();
        }
        String s1 = null;
        switch (this.func_70946_n()) {
            case 0: {
                if (careerId == 1) {
                    s1 = "farmer";
                    break;
                }
                if (careerId == 2) {
                    s1 = "fisherman";
                    break;
                }
                if (careerId == 3) {
                    s1 = "shepherd";
                    break;
                }
                if (careerId != 4) break;
                s1 = "fletcher";
                break;
            }
            case 1: {
                s1 = "librarian";
                break;
            }
            case 2: {
                s1 = "cleric";
                break;
            }
            case 3: {
                if (careerId == 1) {
                    s1 = "armor";
                    break;
                }
                if (careerId == 2) {
                    s1 = "weapon";
                    break;
                }
                if (careerId != 3) break;
                s1 = "tool";
                break;
            }
            case 4: {
                if (careerId == 1) {
                    s1 = "butcher";
                    break;
                }
                if (careerId != 2) break;
                s1 = "leather";
            }
        }
        if (s1 != null) {
            ChatComponentTranslation chatcomponenttranslation = new ChatComponentTranslation("entity.Villager." + s1, new Object[0]);
            chatcomponenttranslation.func_150256_b().func_150209_a(this.func_174823_aP());
            chatcomponenttranslation.func_150256_b().func_179989_a(this.func_110124_au().toString());
            return chatcomponenttranslation;
        }
        return super.func_145748_c_();
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && this.buyingList == null) {
            this.func_175554_cu();
        }
        return super.func_70085_c(player);
    }

    protected void func_175554_cu() {
        if (this.getCareer() != 0 && this.getCareerLevel() != 0) {
            ++this.careerLevel;
        } else {
            int newCareer = 1;
            switch (this.func_70946_n()) {
                case 0: {
                    newCareer = this.field_70146_Z.nextInt(4) + 1;
                    break;
                }
                case 3: {
                    newCareer = this.field_70146_Z.nextInt(3) + 1;
                    break;
                }
                case 4: {
                    newCareer = this.field_70146_Z.nextInt(2) + 1;
                }
            }
            this.careerID = newCareer;
            this.careerLevel = 1;
        }
        if (this.buyingList == null) {
            this.setMerchantRecipeList(new MerchantRecipeList());
        }
        for (int numAdded = 0; numAdded < numTradesAddedPerLevel; ++numAdded) {
            EntityVillager.ITradeList trade = this.getRandomTrade(this.field_70146_Z);
            trade.func_179401_a(this.getMerchantRecipeList(), this.field_70146_Z);
        }
        HashSet<MerchantRecipe> deleteList = new HashSet<MerchantRecipe>();
        for (int Q = 0; Q < this.getMerchantRecipeList().size(); ++Q) {
            MerchantRecipe r = (MerchantRecipe)this.getMerchantRecipeList().get(Q);
            Item in1 = r.func_77394_a().func_77973_b();
            Item in2 = null;
            if (r.func_77396_b() != null) {
                in2 = r.func_77396_b().func_77973_b();
            }
            Item out = r.func_77397_d().func_77973_b();
            for (int P = Q + 1; P < this.getMerchantRecipeList().size(); ++P) {
                MerchantRecipe r2 = (MerchantRecipe)this.getMerchantRecipeList().get(P);
                Item in2B = null;
                if (r2.func_77396_b() != null) {
                    in2B = r2.func_77396_b().func_77973_b();
                }
                if (in1 != r2.func_77394_a().func_77973_b() || out != r2.func_77397_d().func_77973_b() || in2 != in2B) continue;
                deleteList.add(r);
            }
        }
        this.getMerchantRecipeList().removeAll(deleteList);
    }

    protected void func_70619_bc() {
        if (this.getMerchantRecipeList() == null) {
            super.func_70619_bc();
            return;
        }
        ArrayList old = new ArrayList(this.getMerchantRecipeList());
        super.func_70619_bc();
        if (this.getMerchantRecipeList().size() != old.size()) {
            MerchantRecipeList newList = new MerchantRecipeList();
            newList.addAll(old);
            this.setMerchantRecipeList(newList);
            this.func_175554_cu();
        }
    }

    public static void initializeVanillaTrades() {
        EntityVillager.ITradeList[][][][] vanillaRecipeTable = new EntityVillager.ITradeList[][][][]{{{{new EntityVillager.EmeraldForItems(Items.field_151015_O, new EntityVillager.PriceInfo(18, 22)), new EntityVillager.EmeraldForItems(Items.field_151174_bG, new EntityVillager.PriceInfo(15, 19)), new EntityVillager.EmeraldForItems(Items.field_151172_bF, new EntityVillager.PriceInfo(15, 19)), new EntityVillager.ListItemForEmeralds(Items.field_151025_P, new EntityVillager.PriceInfo(-4, -2))}, {new EntityVillager.EmeraldForItems(Item.func_150898_a((Block)Blocks.field_150423_aK), new EntityVillager.PriceInfo(8, 13)), new EntityVillager.ListItemForEmeralds(Items.field_151158_bO, new EntityVillager.PriceInfo(-3, -2))}, {new EntityVillager.EmeraldForItems(Item.func_150898_a((Block)Blocks.field_150440_ba), new EntityVillager.PriceInfo(7, 12)), new EntityVillager.ListItemForEmeralds(Items.field_151034_e, new EntityVillager.PriceInfo(-5, -7))}, {new EntityVillager.ListItemForEmeralds(Items.field_151106_aX, new EntityVillager.PriceInfo(-6, -10)), new EntityVillager.ListItemForEmeralds(Items.field_151105_aU, new EntityVillager.PriceInfo(1, 1))}}, {{new EntityVillager.EmeraldForItems(Items.field_151007_F, new EntityVillager.PriceInfo(15, 20)), new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24)), new EntityVillager.ItemAndEmeraldToItem(Items.field_151115_aP, new EntityVillager.PriceInfo(6, 6), Items.field_179566_aV, new EntityVillager.PriceInfo(6, 6))}, {new EntityVillager.ListEnchantedItemForEmeralds((Item)Items.field_151112_aM, new EntityVillager.PriceInfo(7, 8))}}, {{new EntityVillager.EmeraldForItems(Item.func_150898_a((Block)Blocks.field_150325_L), new EntityVillager.PriceInfo(16, 22)), new EntityVillager.ListItemForEmeralds((Item)Items.field_151097_aZ, new EntityVillager.PriceInfo(3, 4))}, {new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 0), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 1), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 2), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 3), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 4), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 5), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 6), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 7), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 8), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 9), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 10), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 11), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 12), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 13), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 14), new EntityVillager.PriceInfo(1, 2)), new EntityVillager.ListItemForEmeralds(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, 15), new EntityVillager.PriceInfo(1, 2))}}, {{new EntityVillager.EmeraldForItems(Items.field_151007_F, new EntityVillager.PriceInfo(15, 20)), new EntityVillager.ListItemForEmeralds(Items.field_151032_g, new EntityVillager.PriceInfo(-12, -8))}, {new EntityVillager.ListItemForEmeralds((Item)Items.field_151031_f, new EntityVillager.PriceInfo(2, 3)), new EntityVillager.ItemAndEmeraldToItem(Item.func_150898_a((Block)Blocks.field_150351_n), new EntityVillager.PriceInfo(10, 10), Items.field_151145_ak, new EntityVillager.PriceInfo(6, 10))}}}, {{{new EntityVillager.EmeraldForItems(Items.field_151121_aF, new EntityVillager.PriceInfo(24, 36)), new EntityVillager.ListEnchantedBookForEmeralds()}, {new EntityVillager.EmeraldForItems(Items.field_151122_aG, new EntityVillager.PriceInfo(8, 10)), new EntityVillager.ListItemForEmeralds(Items.field_151111_aL, new EntityVillager.PriceInfo(10, 12)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)Blocks.field_150342_X), new EntityVillager.PriceInfo(3, 4))}, {new EntityVillager.EmeraldForItems(Items.field_151164_bB, new EntityVillager.PriceInfo(2, 2)), new EntityVillager.ListItemForEmeralds(Items.field_151113_aN, new EntityVillager.PriceInfo(10, 12)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)Blocks.field_150359_w), new EntityVillager.PriceInfo(-5, -3))}, {new EntityVillager.ListEnchantedBookForEmeralds()}, {new EntityVillager.ListEnchantedBookForEmeralds()}, {new EntityVillager.ListItemForEmeralds(Items.field_151057_cb, new EntityVillager.PriceInfo(20, 22))}}}, {{{new EntityVillager.EmeraldForItems(Items.field_151078_bh, new EntityVillager.PriceInfo(36, 40)), new EntityVillager.EmeraldForItems(Items.field_151043_k, new EntityVillager.PriceInfo(8, 10))}, {new EntityVillager.ListItemForEmeralds(Items.field_151137_ax, new EntityVillager.PriceInfo(-4, -1)), new EntityVillager.ListItemForEmeralds(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), new EntityVillager.PriceInfo(-2, -1))}, {new EntityVillager.ListItemForEmeralds(Items.field_151061_bv, new EntityVillager.PriceInfo(7, 11)), new EntityVillager.ListItemForEmeralds(Item.func_150898_a((Block)Blocks.field_150426_aN), new EntityVillager.PriceInfo(-3, -1))}, {new EntityVillager.ListItemForEmeralds(Items.field_151062_by, new EntityVillager.PriceInfo(3, 11))}}}, {{{new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24)), new EntityVillager.ListItemForEmeralds((Item)Items.field_151028_Y, new EntityVillager.PriceInfo(4, 6))}, {new EntityVillager.EmeraldForItems(Items.field_151042_j, new EntityVillager.PriceInfo(7, 9)), new EntityVillager.ListItemForEmeralds((Item)Items.field_151030_Z, new EntityVillager.PriceInfo(10, 14))}, {new EntityVillager.EmeraldForItems(Items.field_151045_i, new EntityVillager.PriceInfo(3, 4)), new EntityVillager.ListEnchantedItemForEmeralds((Item)Items.field_151163_ad, new EntityVillager.PriceInfo(16, 19))}, {new EntityVillager.ListItemForEmeralds((Item)Items.field_151029_X, new EntityVillager.PriceInfo(5, 7)), new EntityVillager.ListItemForEmeralds((Item)Items.field_151022_W, new EntityVillager.PriceInfo(9, 11)), new EntityVillager.ListItemForEmeralds((Item)Items.field_151020_U, new EntityVillager.PriceInfo(5, 7)), new EntityVillager.ListItemForEmeralds((Item)Items.field_151023_V, new EntityVillager.PriceInfo(11, 15))}}, {{new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24)), new EntityVillager.ListItemForEmeralds(Items.field_151036_c, new EntityVillager.PriceInfo(6, 8))}, {new EntityVillager.EmeraldForItems(Items.field_151042_j, new EntityVillager.PriceInfo(7, 9)), new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151040_l, new EntityVillager.PriceInfo(9, 10))}, {new EntityVillager.EmeraldForItems(Items.field_151045_i, new EntityVillager.PriceInfo(3, 4)), new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151048_u, new EntityVillager.PriceInfo(12, 15)), new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151056_x, new EntityVillager.PriceInfo(9, 12))}}, {{new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24)), new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151037_a, new EntityVillager.PriceInfo(5, 7))}, {new EntityVillager.EmeraldForItems(Items.field_151042_j, new EntityVillager.PriceInfo(7, 9)), new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151035_b, new EntityVillager.PriceInfo(9, 11))}, {new EntityVillager.EmeraldForItems(Items.field_151045_i, new EntityVillager.PriceInfo(3, 4)), new EntityVillager.ListEnchantedItemForEmeralds(Items.field_151046_w, new EntityVillager.PriceInfo(12, 15))}}}, {{{new EntityVillager.EmeraldForItems(Items.field_151147_al, new EntityVillager.PriceInfo(14, 18)), new EntityVillager.EmeraldForItems(Items.field_151076_bf, new EntityVillager.PriceInfo(14, 18))}, {new EntityVillager.EmeraldForItems(Items.field_151044_h, new EntityVillager.PriceInfo(16, 24)), new EntityVillager.ListItemForEmeralds(Items.field_151157_am, new EntityVillager.PriceInfo(-7, -5)), new EntityVillager.ListItemForEmeralds(Items.field_151077_bg, new EntityVillager.PriceInfo(-8, -6))}}, {{new EntityVillager.EmeraldForItems(Items.field_151116_aA, new EntityVillager.PriceInfo(9, 12)), new EntityVillager.ListItemForEmeralds((Item)Items.field_151026_S, new EntityVillager.PriceInfo(2, 4))}, {new EntityVillager.ListEnchantedItemForEmeralds((Item)Items.field_151027_R, new EntityVillager.PriceInfo(7, 12))}, {new EntityVillager.ListItemForEmeralds(Items.field_151141_av, new EntityVillager.PriceInfo(8, 10))}}}};
        for (int prof = 0; prof < vanillaRecipeTable.length; ++prof) {
            for (int career = 0; career < vanillaRecipeTable[prof].length; ++career) {
                for (int lvl = 0; lvl < vanillaRecipeTable[prof][career].length; ++lvl) {
                    EntityBetterVillager.addVillagerTrades(prof, career + 1, lvl + 1, vanillaRecipeTable[prof][career][lvl]);
                }
            }
        }
    }
}

