/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.events;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BucketHandler {
    private static BucketHandler instance = null;
    private static Lock initLock = new ReentrantLock();
    public final Map<Block, Item> buckets = new HashMap<Block, Item>();

    private BucketHandler() {
    }

    public static BucketHandler getInstance() {
        if (instance == null) {
            initLock.lock();
            try {
                if (instance == null) {
                    instance = new BucketHandler();
                }
            }
            finally {
                initLock.unlock();
            }
        }
        return instance;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBucketFill(FillBucketEvent event) {
        ItemStack result = this.fillCustomBucket(event.world, event.target);
        if (result == null) {
            return;
        }
        event.result = result;
        event.setResult(Event.Result.ALLOW);
    }

    private ItemStack fillCustomBucket(World world, MovingObjectPosition location) {
        BlockPos pos = location.func_178782_a();
        Block block = world.func_180495_p(pos).func_177230_c();
        Item bucket = this.buckets.get(block);
        if (bucket != null && block.func_176201_c(world.func_180495_p(pos)) == 0) {
            world.func_175698_g(pos);
            return new ItemStack(bucket);
        }
        return null;
    }
}

