/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.init;

import cyano.basemetals.BaseMetals;
import cyano.basemetals.init.Items;
import cyano.basemetals.init.Materials;
import cyano.basemetals.material.MetalMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public abstract class DungeonLoot {
    private static boolean initDone = false;

    public static void init() {
        if (initDone) {
            return;
        }
        Materials.init();
        Items.init();
        for (MetalMaterial metal : Materials.getAllMetals()) {
            WeightedRandomChestContent loot = DungeonLoot.makeChestLootEntry(metal);
            if (loot == null) continue;
            if (metal.getLootSpawnWeight() > 20) {
                ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(loot);
            }
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(loot);
            ChestGenHooks.getInfo((String)"strongholdCorridor").addItem(loot);
            ChestGenHooks.getInfo((String)"strongholdCrossing").addItem(loot);
        }
        initDone = true;
    }

    private static WeightedRandomChestContent makeChestLootEntry(MetalMaterial metal) {
        Item item = Items.getItemByName(metal.getName() + "_ingot");
        if (item == null) {
            return null;
        }
        int spawnWeight = (int)(BaseMetals.chestLootFactor * (float)metal.getLootSpawnWeight());
        if (spawnWeight <= 0) {
            return null;
        }
        ItemStack itemStack = new ItemStack(item, 1);
        int minSpawnNumber = 1;
        int maxSpawnNumber = Math.max(Math.min(metal.getLootSpawnWeight() / 5, 6), 2);
        return new WeightedRandomChestContent(itemStack, minSpawnNumber, maxSpawnNumber, spawnWeight);
    }
}

