/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.init;

import cyano.basemetals.blocks.InteractiveFluidBlock;
import cyano.basemetals.fluids.CustomFluid;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Fluids {
    public static Fluid fluidMercury = null;
    public static BlockFluidBase fluidBlockMercury = null;
    private static final Map<Fluid, BlockFluidBase> fluidBlocks = new HashMap<Fluid, BlockFluidBase>();
    private static final Map<BlockFluidBase, String> fluidBlockNames = new HashMap<BlockFluidBase, String>();
    private static boolean initDone = false;

    public static void init() {
        if (initDone) {
            return;
        }
        fluidMercury = Fluids.newFluid("basemetals", "mercury", 13594, 2000, 300, 0, -1);
        fluidBlockMercury = Fluids.registerFluidBlock(fluidMercury, (BlockFluidBase)new InteractiveFluidBlock(fluidMercury, false, (w, e) -> {
            if (w.field_73012_v.nextInt(32) == 0) {
                e.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 1200, 2));
            }
        }), "liquid_mercury");
        initDone = true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void bakeModels(String modID) {
        for (Fluid fluid : fluidBlocks.keySet()) {
            BlockFluidBase block = fluidBlocks.get(fluid);
            Item item = Item.func_150898_a((Block)block);
            final ModelResourceLocation fluidModelLocation = new ModelResourceLocation(modID.toLowerCase() + ":" + fluidBlockNames.get(block), "fluid");
            ModelBakery.addVariantName((Item)item, (String[])new String[0]);
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return fluidModelLocation;
                }
            });
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return fluidModelLocation;
                }
            });
        }
    }

    private static Fluid newFluid(String modID, String name, int density, int viscosity, int temperature, int luminosity, int tintColor) {
        CustomFluid f = new CustomFluid(name, new ResourceLocation(modID + ":blocks/" + name + "_still"), new ResourceLocation(modID + ":blocks/" + name + "_flow"), tintColor);
        f.setDensity(density);
        f.setViscosity(viscosity);
        f.setTemperature(temperature);
        f.setLuminosity(luminosity);
        f.setUnlocalizedName(modID + "." + name);
        FluidRegistry.registerFluid((Fluid)f);
        return f;
    }

    private static BlockFluidBase registerFluidBlock(Fluid f, BlockFluidBase block, String name) {
        block.func_149663_c("basemetals." + name);
        GameRegistry.registerBlock((Block)block, (String)name);
        block.func_149647_a(CreativeTabs.field_78026_f);
        fluidBlocks.put(f, block);
        fluidBlockNames.put(block, name);
        return block;
    }
}

