/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.items;

import cyano.basemetals.BaseMetals;
import cyano.basemetals.init.Achievements;
import cyano.basemetals.init.Materials;
import cyano.basemetals.items.MetalToolEffects;
import cyano.basemetals.material.IMetalObject;
import cyano.basemetals.material.MetalMaterial;
import cyano.basemetals.registry.CrusherRecipeRegistry;
import cyano.basemetals.registry.recipe.ICrusherRecipe;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMetalCrackHammer
extends ItemTool
implements IMetalObject {
    protected final MetalMaterial metal;
    protected final Set<String> toolTypes;
    protected final String repairOreDictName;
    protected final boolean regenerates;
    protected final long regenInterval = 200L;

    public ItemMetalCrackHammer(MetalMaterial metal) {
        super(1.0f + Materials.getToolMaterialFor(metal).func_78000_c(), Materials.getToolMaterialFor(metal), new HashSet());
        this.metal = metal;
        this.func_77656_e((int)(0.75 * (double)metal.getToolDurability()));
        this.field_77864_a = metal.getToolEfficiency();
        this.toolTypes = new HashSet<String>();
        this.toolTypes.add("crackhammer");
        this.toolTypes.add("pickaxe");
        this.repairOreDictName = "ingot" + metal.getCapitalizedName();
        this.regenerates = metal.equals(Materials.starsteel);
    }

    public float func_150893_a(ItemStack tool, Block target) {
        if (this.isCrushableBlock(target) && this.func_150897_b(target)) {
            return Math.max(1.0f, 0.5f * this.metal.getToolEfficiency());
        }
        return 1.0f;
    }

    public boolean func_179218_a(ItemStack tool, World world, Block target, BlockPos coord, EntityLivingBase player) {
        IBlockState bs;
        ICrusherRecipe recipe;
        if (!world.field_72995_K && this.func_150897_b(target) && (recipe = this.getCrusherRecipe(bs = world.func_180495_p(coord))) != null) {
            ItemStack output = recipe.getOutput().func_77946_l();
            world.func_175698_g(coord);
            if (output != null) {
                int num = output.field_77994_a;
                output.field_77994_a = 1;
                for (int i = 0; i < num; ++i) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)coord.func_177958_n() + 0.5, (double)coord.func_177956_o() + 0.5, (double)coord.func_177952_p() + 0.5, output.func_77946_l()));
                }
            }
        }
        return super.func_179218_a(tool, world, target, coord, player);
    }

    public boolean func_180614_a(ItemStack item, EntityPlayer player, World w, BlockPos coord, EnumFacing facing, float partialX, float partialY, float partialZ) {
        if (facing != EnumFacing.UP) {
            return false;
        }
        if (w.field_72995_K) {
            return true;
        }
        List entities = w.func_72872_a(EntityItem.class, new AxisAlignedBB((double)coord.func_177958_n(), (double)(coord.func_177956_o() + 1), (double)coord.func_177952_p(), (double)(coord.func_177958_n() + 1), (double)(coord.func_177956_o() + 2), (double)(coord.func_177952_p() + 1)));
        boolean success = false;
        for (EntityItem target : entities) {
            Block b;
            ICrusherRecipe recipe;
            ItemStack targetItem = target.func_92059_d();
            if (targetItem == null || (recipe = CrusherRecipeRegistry.getInstance().getRecipeForInputItem(targetItem)) == null) continue;
            if (BaseMetals.enforceHardness && targetItem.func_77973_b() instanceof ItemBlock && !this.func_150897_b(b = ((ItemBlock)targetItem.func_77973_b()).func_179223_d())) {
                return false;
            }
            ItemStack output = recipe.getOutput().func_77946_l();
            int count = output.field_77994_a;
            output.field_77994_a = 1;
            double x = target.field_70165_t;
            double y = target.field_70163_u;
            double z = target.field_70161_v;
            --targetItem.field_77994_a;
            if (targetItem.field_77994_a <= 0) {
                w.func_72900_e((Entity)target);
            }
            for (int i = 0; i < count; ++i) {
                w.func_72838_d((Entity)new EntityItem(w, x, y, z, output.func_77946_l()));
            }
            item.func_77972_a(1, (EntityLivingBase)player);
            success = true;
            break;
        }
        if (success && !w.field_72995_K) {
            w.func_72956_a((Entity)player, "dig.gravel", 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        }
        return success;
    }

    protected boolean isCrushableBlock(IBlockState block) {
        return this.getCrusherRecipe(block) != null;
    }

    protected boolean isCrushableBlock(Block block) {
        return this.getCrusherRecipe(block) != null;
    }

    protected ICrusherRecipe getCrusherRecipe(Block block) {
        return this.getCrusherRecipe(block.func_176223_P());
    }

    protected ICrusherRecipe getCrusherRecipe(IBlockState block) {
        if (block == null || Item.func_150898_a((Block)block.func_177230_c()) == null) {
            return null;
        }
        return CrusherRecipeRegistry.getInstance().getRecipeForInputItem(new ItemStack(block.func_177230_c(), 1, block.func_177230_c().func_176201_c(block)));
    }

    public Item.ToolMaterial func_150913_i() {
        return this.field_77862_b;
    }

    public int func_77619_b() {
        return this.field_77862_b.func_77995_e();
    }

    public String func_77861_e() {
        return this.field_77862_b.toString();
    }

    public boolean func_82789_a(ItemStack intputItem, ItemStack repairMaterial) {
        List acceptableItems = OreDictionary.getOres((String)this.repairOreDictName);
        for (ItemStack i : acceptableItems) {
            if (!ItemStack.func_179545_c((ItemStack)i, (ItemStack)repairMaterial)) continue;
            return true;
        }
        return false;
    }

    public int getHarvestLevel(ItemStack item, String typeRequested) {
        if (typeRequested != null && this.toolTypes.contains(typeRequested)) {
            if (BaseMetals.strongHammers) {
                return this.metal.getToolHarvestLevel();
            }
            return this.metal.getToolHarvestLevel() - 1;
        }
        return -1;
    }

    public Set<String> getToolClasses(ItemStack item) {
        return this.toolTypes;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(item, target, attacker);
        MetalToolEffects.extraEffectsOnAttack(this.metal, item, target, attacker);
        return true;
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        MetalToolEffects.extraEffectsOnCrafting(this.metal, item, world, crafter);
        crafter.func_71064_a((StatBase)Achievements.geologist, 1);
    }

    public void func_77663_a(ItemStack item, World world, Entity player, int inventoryIndex, boolean isHeld) {
        if (this.regenerates && !world.field_72995_K && isHeld && item.func_77952_i() > 0 && world.func_82737_E() % 200L == 0L) {
            item.func_77964_b(item.func_77952_i() - 1);
        }
    }

    public boolean func_150897_b(Block target) {
        String toolType = target.getHarvestTool(target.func_176223_P());
        if (this.toolTypes.contains(toolType) || target.func_149688_o() == Material.field_151576_e) {
            return this.getHarvestLevel(null, "pickaxe") >= target.getHarvestLevel(target.func_176223_P());
        }
        if ("shovel".equals(toolType) && target.getHarvestLevel(target.func_176223_P()) <= 0) {
            return true;
        }
        return target.getHarvestLevel(target.func_176223_P()) == -1;
    }

    public String getMaterialName() {
        return this.metal.getName();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b) {
        super.func_77624_a(stack, player, list, b);
        MetalToolEffects.addToolSpecialPropertiesToolTip(this.metal, list);
    }

    @Override
    public MetalMaterial getMetalMaterial() {
        return this.metal;
    }
}

