/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.items;

import cyano.basemetals.init.Materials;
import cyano.basemetals.items.MetalToolEffects;
import cyano.basemetals.material.IMetalObject;
import cyano.basemetals.material.MetalMaterial;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMetalHoe
extends ItemHoe
implements IMetalObject {
    protected final MetalMaterial metal;
    protected final Set<String> toolTypes;
    protected final String repairOreDictName;
    protected final boolean regenerates;
    protected final long regenInterval = 200L;

    public ItemMetalHoe(MetalMaterial metal) {
        super(Materials.getToolMaterialFor(metal));
        this.metal = metal;
        this.func_77656_e(metal.getToolDurability());
        this.toolTypes = new HashSet<String>();
        this.toolTypes.add("hoe");
        this.repairOreDictName = "ingot" + metal.getCapitalizedName();
        this.regenerates = metal.equals(Materials.starsteel);
    }

    @Override
    public MetalMaterial getMetalMaterial() {
        return this.metal;
    }

    public boolean func_82789_a(ItemStack intputItem, ItemStack repairMaterial) {
        List acceptableItems = OreDictionary.getOres((String)this.repairOreDictName);
        for (ItemStack i : acceptableItems) {
            if (!ItemStack.func_179545_c((ItemStack)i, (ItemStack)repairMaterial)) continue;
            return true;
        }
        return false;
    }

    public int getHarvestLevel(ItemStack item, String typeRequested) {
        if (typeRequested != null && this.toolTypes.contains(typeRequested)) {
            return this.metal.getToolHarvestLevel();
        }
        return -1;
    }

    public Set<String> getToolClasses(ItemStack item) {
        return this.toolTypes;
    }

    public float func_150893_a(ItemStack tool, Block target) {
        if (this.canHarvestBlock(target, tool)) {
            return Math.max(1.0f, this.metal.getToolEfficiency());
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(item, target, attacker);
        MetalToolEffects.extraEffectsOnAttack(this.metal, item, target, attacker);
        return true;
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        MetalToolEffects.extraEffectsOnCrafting(this.metal, item, world, crafter);
    }

    public void func_77663_a(ItemStack item, World world, Entity player, int inventoryIndex, boolean isHeld) {
        if (this.regenerates && !world.field_72995_K && isHeld && item.func_77952_i() > 0 && world.func_82737_E() % 200L == 0L) {
            item.func_77964_b(item.func_77952_i() - 1);
        }
    }

    public boolean func_150897_b(Block target) {
        if (this.toolTypes.contains(target.getHarvestTool(target.func_176223_P()))) {
            return this.metal.getToolHarvestLevel() >= target.getHarvestLevel(target.func_176223_P());
        }
        return false;
    }

    public String func_77842_f() {
        return this.metal.getName();
    }
}

