/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.items;

import cyano.basemetals.init.Materials;
import cyano.basemetals.material.IMetalObject;
import cyano.basemetals.material.MetalMaterial;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ItemMetalTool
extends ItemTool
implements IMetalObject {
    protected final MetalMaterial metal;
    protected final Set<String> toolTypes;
    protected final String repairOreDictName;
    protected final boolean regenerates;
    protected final long regenInterval = 200L;
    protected final float attackDamage;

    protected ItemMetalTool(String toolType, MetalMaterial metal, float attackDamageBonus) {
        super(attackDamageBonus + metal.getBaseAttackDamage() - Item.ToolMaterial.IRON.func_78000_c(), Item.ToolMaterial.IRON, new HashSet());
        this.metal = metal;
        this.func_77656_e(metal.getToolDurability());
        this.field_77864_a = metal.getToolEfficiency();
        this.attackDamage = attackDamageBonus + metal.getBaseAttackDamage();
        this.toolTypes = new HashSet<String>();
        this.toolTypes.add(toolType);
        this.repairOreDictName = "ingot" + metal.getCapitalizedName();
        this.regenerates = metal.equals(Materials.starsteel);
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public Item.ToolMaterial func_150913_i() {
        return this.field_77862_b;
    }

    public int func_77619_b() {
        return this.field_77862_b.func_77995_e();
    }

    public String func_77861_e() {
        return this.field_77862_b.toString();
    }

    public boolean func_82789_a(ItemStack intputItem, ItemStack repairMaterial) {
        List acceptableItems = OreDictionary.getOres((String)this.repairOreDictName);
        for (ItemStack i : acceptableItems) {
            if (!ItemStack.func_179545_c((ItemStack)i, (ItemStack)repairMaterial)) continue;
            return true;
        }
        return false;
    }

    public int getHarvestLevel(ItemStack item, String typeRequested) {
        if (typeRequested != null && this.toolTypes.contains(typeRequested)) {
            return this.metal.getToolHarvestLevel();
        }
        return -1;
    }

    public Set<String> getToolClasses(ItemStack item) {
        return this.toolTypes;
    }

    public float func_150893_a(ItemStack tool, Block target) {
        if (this.canHarvestBlock(target, tool)) {
            return Math.max(1.0f, this.metal.getToolEfficiency());
        }
        return 1.0f;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase attacker) {
        super.func_77644_a(item, target, attacker);
        this.extraEffectsOnAttack(item, target, attacker);
        return true;
    }

    public void extraEffectsOnAttack(ItemStack item, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.metal.equals(Materials.coldiron)) {
            if (target.func_70045_F()) {
                DamageSource extraDamage = DamageSource.field_76377_j;
                target.func_70097_a(extraDamage, 3.0f);
            }
        } else if (this.metal.equals(Materials.adamantine)) {
            if (target.func_110138_aP() > 20.0f) {
                DamageSource extraDamage = DamageSource.field_76377_j;
                target.func_70097_a(extraDamage, 2.0f);
            }
        } else if (this.metal.equals(Materials.mithril) && target.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
            PotionEffect poison = new PotionEffect(20, 60, 3);
            PotionEffect blind = new PotionEffect(15, 60, 1);
            target.func_70690_d(poison);
            target.func_70690_d(blind);
        }
    }

    public void func_77622_d(ItemStack item, World world, EntityPlayer crafter) {
        super.func_77622_d(item, world, crafter);
        this.extraEffectsOnCrafting(item, world, crafter);
    }

    public void extraEffectsOnCrafting(ItemStack item, World world, EntityPlayer crafter) {
        if (this.metal.equals(Materials.mithril)) {
            item.func_77966_a(Enchantment.field_180315_m, 2);
        }
    }

    public void func_77663_a(ItemStack item, World world, Entity player, int inventoryIndex, boolean isHeld) {
        if (this.regenerates && !world.field_72995_K && isHeld && item.func_77952_i() > 0 && world.func_82737_E() % 200L == 0L) {
            item.func_77964_b(item.func_77952_i() - 1);
        }
    }

    public boolean func_150897_b(Block target) {
        if (this.toolTypes.contains(target.getHarvestTool(target.func_176223_P()))) {
            return this.metal.getToolHarvestLevel() >= target.getHarvestLevel(target.func_176223_P());
        }
        return false;
    }

    public float getAttackDamage() {
        return this.attackDamage;
    }

    public String getMaterialName() {
        return this.metal.getName();
    }

    @Override
    public MetalMaterial getMetalMaterial() {
        return this.metal;
    }
}

