/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.material;

import java.util.Locale;

public class MetalMaterial {
    public final float hardness;
    public final float strength;
    public final float magicAffinity;
    final String identifier;
    final String titleName;
    private final String enumName;
    final int lootFrequency;
    private int[] cache = null;

    public MetalMaterial(String name, float hardness, float strength, float magic, int lootFrequency) {
        this.hardness = hardness;
        this.strength = strength;
        this.magicAffinity = magic;
        this.identifier = name;
        this.lootFrequency = lootFrequency;
        String firstLetter = name.substring(0, 1);
        String rest = name.substring(1);
        this.titleName = firstLetter.toUpperCase(Locale.ENGLISH) + rest;
        this.enumName = ("basemetals_" + name).toUpperCase(Locale.ENGLISH);
    }

    public String getName() {
        return this.identifier;
    }

    public String getCapitalizedName() {
        return this.titleName;
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.hashCode() == this.hashCode() && o instanceof MetalMaterial) {
            MetalMaterial other = (MetalMaterial)o;
            return this.identifier.equals(other.identifier);
        }
        return false;
    }

    public float getOreSmeltXP() {
        return 0.1f * this.magicAffinity;
    }

    public int getToolHarvestLevel() {
        return (int)(this.hardness / 3.0f);
    }

    public int getRequiredHarvestLevel() {
        return (int)MetalMaterial.clamp(0.9f * this.hardness / 3.0f, -1.0f, 3.0f);
    }

    static int clamp(int x, int min, int max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    static float clamp(float x, float min, float max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    static double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public float getBlastResistance() {
        return 2.5f * this.strength;
    }

    public float getToolEfficiency() {
        return this.hardness;
    }

    public float getOreBlockHardness() {
        return 0.5f * this.hardness;
    }

    public float getMetalBlockHardness() {
        return 2.0f * this.hardness;
    }

    public int getToolDurability() {
        return (int)(32.0f * this.strength);
    }

    public int getArmorMaxDamageFactor() {
        return (int)(2.5f * this.strength);
    }

    public int[] getDamageReductionArray() {
        if (this.cache == null) {
            float base = 0.75f * this.hardness;
            this.cache = new int[4];
            this.cache[0] = (int)(base / 2.5f);
            this.cache[1] = (int)base;
            this.cache[2] = (int)(0.75f * base);
            this.cache[3] = (int)(base / 2.6f);
        }
        return this.cache;
    }

    public float getBaseAttackDamage() {
        return this.round(Math.max(0.0f, this.hardness / 3.0f - 0.5f), 1);
    }

    private float round(float number, int numDecimalPlaces) {
        int x = 1;
        for (int i = 0; i < numDecimalPlaces; ++i) {
            x *= 10;
        }
        return (float)Math.round(number * (float)x) / (float)x;
    }

    public int getEnchantability() {
        return (int)(2.5f * this.magicAffinity);
    }

    public String getEnumName() {
        return this.enumName;
    }

    public int getLootSpawnWeight() {
        return this.lootFrequency;
    }
}

