/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cyano.basemetals.registry.CrusherRecipeRegistry;
import cyano.basemetals.registry.recipe.ICrusherRecipe;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.FMLLog;
import org.lwjgl.opengl.GL11;

public class CrusherRecipeHandler
extends TemplateRecipeHandler {
    public String getOverlayIdentifier() {
        return "crusher";
    }

    public String getGuiTexture() {
        return "basemetals:textures/gui/nei/nei_crusher.png";
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ICrusherRecipe recipe = CrusherRecipeRegistry.getInstance().getRecipeForInputItem(ingredient);
        if (recipe == null) {
            return;
        }
        this.arecipes.add(new CrusherPair(ingredient.func_77946_l(), recipe.getOutput()));
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<ICrusherRecipe> recipes = CrusherRecipeRegistry.getInstance().getRecipesForOutputItem(result);
        if (recipes == null) {
            return;
        }
        for (ICrusherRecipe r : recipes) {
            for (ItemStack input : r.getValidInputs()) {
                this.arecipes.add(new CrusherPair(input.func_77946_l(), r.getOutput().func_77946_l()));
            }
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("crusher") && ((Object)((Object)this)).getClass() == CrusherRecipeHandler.class) {
            this.loadCraftingRecipes("smelting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crusher") && ((Object)((Object)this)).getClass() == CrusherRecipeHandler.class) {
            Collection<ICrusherRecipe> recipes = CrusherRecipeRegistry.getInstance().getAllRecipes();
            if (recipes == null) {
                return;
            }
            for (ICrusherRecipe r : recipes) {
                if (r == null) continue;
                for (ItemStack input : r.getValidInputs()) {
                    this.arecipes.add(new CrusherPair(input.func_77946_l(), r.getOutput().func_77946_l()));
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public TemplateRecipeHandler newInstance() {
        return super.newInstance();
    }

    public String getRecipeName() {
        String key = "nei.basemetals.recipehandler.crusher.name";
        if (StatCollector.func_94522_b((String)key)) {
            return StatCollector.func_74838_a((String)key);
        }
        return "Crusher";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(95, 23, 18, 18), "crusher", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrusher.class;
    }

    public class CrusherPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;

        public CrusherPair(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)CrusherRecipeHandler.this);
            if (ingred == null || result == null) {
                FMLLog.warning((String)("Added null item to NEI GUI: " + ingred + " -> " + result), (Object[])new Object[0]);
                if (ingred == null) {
                    ingred = new ItemStack(Blocks.field_150350_a);
                }
                if (result == null) {
                    result = new ItemStack(Blocks.field_150350_a);
                }
            }
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack((Object)ingred, 65, 23);
            this.result = new PositionedStack((Object)result, 123, 23);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CrusherRecipeHandler.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }
    }

    public static class ContainerCrusher
    extends Container {
        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }
    }

    public static class GuiCrusher
    extends GuiContainer {
        ResourceLocation guiDisplayImage = new ResourceLocation("basemetals:textures/gui/nei/nei_crusher.png");

        public GuiCrusher(Container container) {
            super(container);
        }

        protected void func_146976_a(float f, int i, int j) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int x = (this.field_146294_l - this.field_146999_f) / 2;
            int y = (this.field_146295_m - this.field_147000_g) / 2;
            this.field_146297_k.field_71446_o.func_110577_a(this.guiDisplayImage);
            this.func_73729_b(x, y, 0, 0, 176, 76);
        }
    }
}

