/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.worldgen;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameData;

public class OreSpawnData {
    public final float frequency;
    public final int spawnQuantity;
    public final int minY;
    public final int maxY;
    public final int variation;
    public final boolean restrictBiomes;
    public final Set<String> biomesByName;
    public final Block ore;
    public final int metaData;
    private static boolean doOnce = true;

    public OreSpawnData(Block oreBlock, int metaDataValue, int minHeight, int maxHeight, float spawnFrequency, int spawnQuantity, int spawnQuantityVariation, Collection<String> biomes) {
        this.spawnQuantity = spawnQuantity;
        this.frequency = spawnFrequency;
        this.minY = minHeight;
        this.maxY = maxHeight;
        this.ore = oreBlock;
        this.metaData = metaDataValue;
        this.variation = spawnQuantityVariation;
        this.restrictBiomes = biomes != null && !biomes.isEmpty();
        HashSet<String> list = new HashSet<String>();
        if (this.restrictBiomes) {
            list.addAll(biomes);
        }
        this.biomesByName = Collections.unmodifiableSet(list);
    }

    public OreSpawnData(JsonObject jsonEntry) {
        String name;
        String modId;
        String blockName = jsonEntry.get("blockID").getAsString();
        if (blockName.contains(":")) {
            modId = blockName.substring(0, blockName.indexOf(":"));
            name = blockName.substring(blockName.indexOf(":") + 1);
        } else {
            modId = "minecraft";
            name = blockName;
        }
        this.ore = (Block)GameData.getBlockRegistry().getObject(new ResourceLocation(blockName));
        if (this.ore == null) {
            FMLLog.severe((String)("Failed to find ore block " + modId + ":" + name), (Object[])new Object[0]);
            if (doOnce) {
                StringBuilder sb = new StringBuilder("Valid block IDs:\n");
                for (Object key : GameData.getBlockRegistry().func_148742_b()) {
                    sb.append("\t(").append(key.getClass().getName()).append(")\t").append(String.valueOf(key)).append("\n");
                }
                FMLLog.severe((String)sb.toString(), (Object[])new Object[0]);
                doOnce = false;
            }
        }
        this.metaData = OreSpawnData.get("blockMeta", 0, jsonEntry);
        this.spawnQuantity = (int)OreSpawnData.get("size", 8.0f, jsonEntry);
        this.frequency = OreSpawnData.get("frequency", 20.0f, jsonEntry);
        this.minY = OreSpawnData.get("minHeight", 0, jsonEntry);
        this.maxY = OreSpawnData.get("maxHeight", 255, jsonEntry);
        this.variation = (int)OreSpawnData.get("variation", 0.5f * (float)this.spawnQuantity, jsonEntry);
        if (jsonEntry.has("biomes") && jsonEntry.get("biomes").getAsJsonArray().size() > 0) {
            this.restrictBiomes = true;
            JsonArray biomeEntries = jsonEntry.get("biomes").getAsJsonArray();
            HashSet<String> list = new HashSet<String>();
            for (int n = 0; n < biomeEntries.size(); ++n) {
                list.add(biomeEntries.get(n).getAsString());
            }
            this.biomesByName = Collections.unmodifiableSet(list);
        } else {
            this.restrictBiomes = false;
            this.biomesByName = Collections.EMPTY_SET;
        }
    }

    private static int get(String key, int defaultValue, JsonObject root) {
        if (root.has(key)) {
            return root.get(key).getAsInt();
        }
        return defaultValue;
    }

    private static float get(String key, float defaultValue, JsonObject root) {
        if (root.has(key)) {
            return root.get(key).getAsFloat();
        }
        return defaultValue;
    }

    private static String get(String key, String defaultValue, JsonObject root) {
        if (root.has(key)) {
            return root.get(key).getAsString();
        }
        return defaultValue;
    }

    public String toString() {
        return "oreSpawn: [ore=" + this.ore + "#" + this.metaData + ",frequency=" + this.frequency + ",spawnQuantity=" + this.spawnQuantity + ",variation=+/-" + this.variation + ",Y-range=" + this.minY + "-" + this.maxY + ",restrictBiomes=" + this.restrictBiomes + ",biomes=" + Arrays.toString(this.biomesByName.toArray()) + "]";
    }
}

