/*
 * Decompiled with CFR 0.152.
 */
package cyano.basemetals.worldgen;

import com.google.common.base.Predicate;
import cyano.basemetals.BaseMetals;
import cyano.basemetals.events.BaseMetalsOreGenEvent;
import cyano.basemetals.worldgen.OreSpawnData;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.oredict.OreDictionary;

public class OreSpawner
implements IWorldGenerator {
    private static final Map<Integer3D, Map<BlockPos, IBlockState>> overflowCache = new HashMap<Integer3D, Map<BlockPos, IBlockState>>();
    private static final Deque<Integer3D> cacheOrder = new LinkedList<Integer3D>();
    private static final int maxCacheSize = 64;
    private static final Set<Integer> registeredDimensions = new HashSet<Integer>();
    private final long hash;
    private final Integer dimension;
    private final boolean miscDimension;
    private final OreSpawnData spawnData;
    private static final Vec3i[] offsets = new Vec3i[]{new Vec3i(-1, -1, -1), new Vec3i(0, -1, -1), new Vec3i(1, -1, -1), new Vec3i(-1, 0, -1), new Vec3i(0, 0, -1), new Vec3i(1, 0, -1), new Vec3i(-1, 1, -1), new Vec3i(0, 1, -1), new Vec3i(1, 1, -1), new Vec3i(-1, -1, 0), new Vec3i(0, -1, 0), new Vec3i(1, -1, 0), new Vec3i(-1, 0, 0), new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(-1, 1, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(-1, -1, 1), new Vec3i(0, -1, 1), new Vec3i(1, -1, 1), new Vec3i(-1, 0, 1), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(-1, 1, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    private static final Vec3i[] offsets_small = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 1, 0), new Vec3i(1, 1, 0), new Vec3i(0, 0, 1), new Vec3i(1, 0, 1), new Vec3i(0, 1, 1), new Vec3i(1, 1, 1)};
    private static final int[] offsetIndexRef = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26};
    private static final int[] offsetIndexRef_small = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final Predicate stonep = new Predicate<IBlockState>(){
        Set<Block> cache = null;
        boolean cacheEmpty = true;
        private final Lock initLock = new ReentrantLock();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(IBlockState input) {
            Block b = input.func_177230_c();
            if (b == Blocks.field_150350_a) {
                return false;
            }
            if (this.cacheEmpty) {
                this.initLock.lock();
                try {
                    if (this.cacheEmpty) {
                        this.cacheEmpty = false;
                        this.cache = new HashSet<Block>();
                        List dict = OreDictionary.getOres((String)"stone");
                        for (ItemStack i : dict) {
                            if (!(i.func_77973_b() instanceof ItemBlock)) continue;
                            this.cache.add(((ItemBlock)i.func_77973_b()).func_179223_d());
                        }
                    }
                }
                finally {
                    this.initLock.unlock();
                }
            }
            return this.cache.contains(b);
        }
    };

    public OreSpawner(Block oreBlock, int minHeight, int maxHeight, float spawnFrequency, int spawnQuantity, int spawnQuantityVariation, int dimension, long hash) {
        this(oreBlock, 0, minHeight, maxHeight, spawnFrequency, spawnQuantity, spawnQuantityVariation, null, dimension, hash);
    }

    public OreSpawner(Block oreBlock, int metaDataValue, int minHeight, int maxHeight, float spawnFrequency, int spawnQuantity, int spawnQuantityVariation, int dimension, long hash) {
        this(oreBlock, metaDataValue, minHeight, maxHeight, spawnFrequency, spawnQuantity, spawnQuantityVariation, null, dimension, hash);
    }

    public OreSpawner(Block oreBlock, int metaDataValue, int minHeight, int maxHeight, float spawnFrequency, int spawnQuantity, int spawnQuantityVariation, Collection<String> biomes, int dimension, long hash) {
        this(new OreSpawnData(oreBlock, metaDataValue, minHeight, maxHeight, spawnFrequency, spawnQuantity, spawnQuantityVariation, biomes), dimension, hash);
    }

    public OreSpawner(OreSpawnData spawnData, Integer dimension, long hash) {
        this.spawnData = spawnData;
        this.hash = hash;
        this.dimension = dimension;
        if (dimension != null) {
            registeredDimensions.add(dimension);
        }
        this.miscDimension = false;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (this.dimension == null ? registeredDimensions.contains(world.field_73011_w.func_177502_q()) : world.field_73011_w.func_177502_q() != this.dimension.intValue()) {
            return;
        }
        BlockPos coord = new BlockPos(chunkX << 4 & 8, 64, chunkZ << 4 & 8);
        if (this.spawnData.restrictBiomes) {
            BiomeGenBase biome = world.func_180494_b(coord);
            if (!this.spawnData.biomesByName.contains(biome.field_76791_y) && !this.spawnData.biomesByName.contains(String.valueOf(biome.field_76756_M))) {
                return;
            }
        }
        Integer3D chunkCoord = new Integer3D(chunkX, chunkZ, world.field_73011_w.func_177502_q());
        Map<BlockPos, IBlockState> cache = OreSpawner.retrieveCache(chunkCoord);
        for (BlockPos p : cache.keySet()) {
            OreSpawner.spawn(cache.get(p), world, p, world.field_73011_w.func_177502_q(), false);
        }
        random.setSeed(random.nextLong() ^ this.hash);
        random.nextInt();
        if (this.spawnData.frequency >= 1.0f) {
            int i = 0;
            while ((float)i < this.spawnData.frequency) {
                int x = (chunkX << 4) + random.nextInt(16);
                int y = random.nextInt(this.spawnData.maxY - this.spawnData.minY) + this.spawnData.minY;
                int z = (chunkZ << 4) + random.nextInt(16);
                int r = this.spawnData.variation > 0 ? random.nextInt(2 * this.spawnData.variation) - this.spawnData.variation : 0;
                OreSpawner.spawnOre(new BlockPos(x, y, z), this.spawnData.ore, this.spawnData.metaData, this.spawnData.spawnQuantity + r, world, random);
                ++i;
            }
        } else if (random.nextFloat() < this.spawnData.frequency) {
            int x = (chunkX << 4) + random.nextInt(16);
            int y = random.nextInt(this.spawnData.maxY - this.spawnData.minY) + this.spawnData.minY;
            int z = (chunkZ << 4) + random.nextInt(16);
            int r = this.spawnData.variation > 0 ? random.nextInt(2 * this.spawnData.variation) - this.spawnData.variation : 0;
            OreSpawner.spawnOre(new BlockPos(x, y, z), this.spawnData.ore, this.spawnData.metaData, this.spawnData.spawnQuantity + r, world, random);
        }
    }

    public static void spawnOre(BlockPos blockPos, Block oreBlock, int metaData, int quantity, World world, Random prng) {
        block18: {
            if (!BaseMetals.forceOreGen) {
                BaseMetalsOreGenEvent oreEvent = new BaseMetalsOreGenEvent(world, prng, blockPos, "basemetals");
                MinecraftForge.ORE_GEN_BUS.post((Event)oreEvent);
                if (oreEvent.getResult() == Event.Result.DENY) {
                    return;
                }
            }
            int count = quantity;
            if (quantity <= 8) {
                int[] scrambledLUT = new int[offsetIndexRef_small.length];
                System.arraycopy(offsetIndexRef_small, 0, scrambledLUT, 0, scrambledLUT.length);
                OreSpawner.scramble(scrambledLUT, prng);
                while (count > 0) {
                    OreSpawner.spawn(oreBlock, metaData, world, blockPos.func_177971_a(offsets_small[scrambledLUT[--count]]), world.field_73011_w.func_177502_q(), true);
                }
                MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(world, prng, blockPos));
                return;
            }
            if (quantity < 27) {
                int[] scrambledLUT = new int[offsetIndexRef.length];
                System.arraycopy(offsetIndexRef, 0, scrambledLUT, 0, scrambledLUT.length);
                OreSpawner.scramble(scrambledLUT, prng);
                while (count > 0) {
                    OreSpawner.spawn(oreBlock, metaData, world, blockPos.func_177971_a(offsets[scrambledLUT[--count]]), world.field_73011_w.func_177502_q(), true);
                }
                return;
            }
            double radius = Math.pow(quantity, 0.3333333333333333) * 0.238732414637843 + 2.0;
            int rSqr = (int)(radius * radius);
            if (prng.nextBoolean()) {
                int dy = (int)(-1.0 * radius);
                while ((double)dy < radius) {
                    int dz = (int)(-1.0 * radius);
                    while ((double)dz < radius) {
                        int dx = (int)(-1.0 * radius);
                        while ((double)dx < radius) {
                            if (dx * dx + dy * dy + dz * dz <= rSqr) {
                                OreSpawner.spawn(oreBlock, metaData, world, blockPos.func_177982_a(dx, dy, dz), world.field_73011_w.func_177502_q(), true);
                                --count;
                            }
                            if (count > 0) {
                                ++dx;
                                continue;
                            }
                            break block18;
                        }
                        ++dz;
                    }
                    ++dy;
                }
            } else {
                int dy = (int)(-1.0 * radius);
                while ((double)dy < radius) {
                    for (int dx = (int)radius; dx >= (int)(-1.0 * radius); --dx) {
                        for (int dz = (int)radius; dz >= (int)(-1.0 * radius); --dz) {
                            if (dx * dx + dy * dy + dz * dz <= rSqr) {
                                OreSpawner.spawn(oreBlock, metaData, world, blockPos.func_177982_a(dx, dy, dz), world.field_73011_w.func_177502_q(), true);
                                --count;
                            }
                            if (count > 0) {
                                continue;
                            }
                            break block18;
                        }
                    }
                    ++dy;
                }
            }
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(world, prng, blockPos));
    }

    private static void scramble(int[] target, Random prng) {
        for (int i = target.length - 1; i > 0; --i) {
            int n = prng.nextInt(i);
            int temp = target[i];
            target[i] = target[n];
            target[n] = temp;
        }
    }

    private static void spawn(Block b, int m, World w, BlockPos coord, int dimension, boolean cacheOverflow) {
        if (m == 0) {
            OreSpawner.spawn(b.func_176223_P(), w, coord, dimension, cacheOverflow);
        } else {
            OreSpawner.spawn(b.func_176203_a(m), w, coord, dimension, cacheOverflow);
        }
    }

    private static void spawn(IBlockState b, World w, BlockPos coord, int dimension, boolean cacheOverflow) {
        block11: {
            block10: {
                if (coord.func_177956_o() < 0 || coord.func_177956_o() >= w.func_72800_K()) {
                    return;
                }
                if (!w.func_175697_a(coord, 0)) break block10;
                if (w.func_175623_d(coord)) {
                    return;
                }
                IBlockState bs = w.func_180495_p(coord);
                switch (dimension) {
                    case -1: {
                        if (bs.func_177230_c() == Blocks.field_150424_aL || bs.func_177230_c().isReplaceableOreGen(w, coord, stonep)) {
                            w.func_180501_a(coord, b, 2);
                            break;
                        }
                        break block11;
                    }
                    case 1: {
                        if (bs.func_177230_c() == Blocks.field_150377_bs || bs.func_177230_c().isReplaceableOreGen(w, coord, stonep)) {
                            w.func_180501_a(coord, b, 2);
                            break;
                        }
                        break block11;
                    }
                    default: {
                        if (bs.func_177230_c() == Blocks.field_150348_b || bs.func_177230_c().isReplaceableOreGen(w, coord, stonep)) {
                            w.func_180501_a(coord, b, 2);
                            break;
                        }
                        break block11;
                    }
                }
                break block11;
            }
            if (cacheOverflow) {
                OreSpawner.cacheOverflowBlock(b, coord, dimension);
            }
        }
    }

    protected static void cacheOverflowBlock(IBlockState bs, BlockPos coord, int dimension) {
        Integer3D chunkCoord = new Integer3D(coord.func_177958_n() >> 4, coord.func_177956_o() >> 4, dimension);
        if (!overflowCache.containsKey(chunkCoord)) {
            cacheOrder.addLast(chunkCoord);
            if (cacheOrder.size() > 64) {
                Integer3D drop = cacheOrder.removeFirst();
                overflowCache.get(drop).clear();
                overflowCache.remove(drop);
            }
            overflowCache.put(chunkCoord, new HashMap());
        }
        Map<BlockPos, IBlockState> cache = overflowCache.get(chunkCoord);
        cache.put(coord, bs);
    }

    protected static Map<BlockPos, IBlockState> retrieveCache(Integer3D chunkCoord) {
        if (overflowCache.containsKey(chunkCoord)) {
            Map<BlockPos, IBlockState> cache = overflowCache.get(chunkCoord);
            cacheOrder.remove(chunkCoord);
            overflowCache.remove(chunkCoord);
            return cache;
        }
        return Collections.EMPTY_MAP;
    }

    protected static class Integer3D {
        public final int X;
        public final int Y;
        public final int Z;

        public Integer3D(int x, int y, int z) {
            this.X = x;
            this.Y = y;
            this.Z = z;
        }

        public int hashCode() {
            return this.X << 8 ^ this.Y ^ (this.Z << 16) * 17;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof Integer3D) {
                Integer3D other = (Integer3D)o;
                return other.X == this.X && other.Y == this.Y && other.Z == this.Z;
            }
            return false;
        }
    }
}

