/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.DataInput;
import java.io.DataOutput;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseDataChannel {
    List handlers = new ArrayList();
    String name;
    EnumMap<Side, FMLEmbeddedChannel> pipes;

    public BaseDataChannel(String string, Object ... objectArray) {
        this.name = string;
        DataHandler dataHandler = new DataHandler(this);
        this.pipes = NetworkRegistry.INSTANCE.newChannel(string, new ChannelHandler[]{dataHandler});
        this.handlers.add(this);
        for (Object object : objectArray) {
            this.handlers.add(object);
        }
    }

    protected ChannelOutput openTarget(String string, Side side, FMLOutboundHandler.OutboundTarget outboundTarget) {
        return this.openTarget(string, side, outboundTarget, null);
    }

    protected ChannelOutput openTarget(String string, Side side, FMLOutboundHandler.OutboundTarget outboundTarget, Object object) {
        DataPacket dataPacket = new DataPacket(this, side, outboundTarget, object);
        dataPacket.writeUTF(string);
        return dataPacket;
    }

    public ChannelOutput openServer(String string) {
        return this.openTarget(string, Side.CLIENT, FMLOutboundHandler.OutboundTarget.TOSERVER);
    }

    public ChannelOutput openPlayer(EntityPlayer entityPlayer, String string) {
        return this.openTarget(string, Side.SERVER, FMLOutboundHandler.OutboundTarget.PLAYER, entityPlayer);
    }

    public ChannelOutput openAllPlayers(String string) {
        return this.openTarget(string, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALL);
    }

    public ChannelOutput openAllAround(NetworkRegistry.TargetPoint targetPoint, String string) {
        return this.openTarget(string, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT, targetPoint);
    }

    public ChannelOutput openDimension(int n, String string) {
        return this.openTarget(string, Side.SERVER, FMLOutboundHandler.OutboundTarget.DIMENSION, n);
    }

    public ChannelOutput openServerContainer(String string) {
        ChannelOutput channelOutput = this.openServer(".container.");
        channelOutput.writeUTF(string);
        return channelOutput;
    }

    public ChannelOutput openClientContainer(EntityPlayer entityPlayer, String string) {
        ChannelOutput channelOutput = this.openPlayer(entityPlayer, ".container.");
        channelOutput.writeUTF(string);
        return channelOutput;
    }

    @ServerMessageHandler(value=".container.")
    public void onServerContainerMessage(EntityPlayer entityPlayer, ChannelInput channelInput) {
        String string = channelInput.readUTF();
        BaseDataChannel.doServerDispatch(entityPlayer.field_71070_bA, string, entityPlayer, channelInput);
    }

    @SideOnly(value=Side.CLIENT)
    @ClientMessageHandler(value=".container.")
    public void onClientContainerMessage(ChannelInput channelInput) {
        EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
        String string = channelInput.readUTF();
        BaseDataChannel.doClientDispatch(entityPlayerSP.field_71070_bA, string, channelInput);
    }

    protected void onReceiveFromClient(EntityPlayer entityPlayer, ChannelInput channelInput) {
        String string = channelInput.readUTF();
        for (Object e : this.handlers) {
            if (!BaseDataChannel.serverDispatch(e, string, entityPlayer, channelInput)) continue;
            return;
        }
        System.out.printf("No ServerMessageHandler for '%s' found in registered handlers\n", string);
    }

    public static boolean serverDispatch(Object object, String string, EntityPlayer entityPlayer, ChannelInput channelInput) {
        if (object != null) {
            for (Method method : object.getClass().getMethods()) {
                ServerMessageHandler serverMessageHandler = method.getAnnotation(ServerMessageHandler.class);
                if (serverMessageHandler == null || !serverMessageHandler.value().equals(string)) continue;
                try {
                    method.invoke(object, entityPlayer, channelInput);
                }
                catch (Exception exception) {
                    throw new RuntimeException(String.format("Exception while calling server-side handler %s.%s for message %s", object.getClass().getName(), method.getName(), string), exception);
                }
                return true;
            }
        }
        return false;
    }

    public static void doServerDispatch(Object object, String string, EntityPlayer entityPlayer, ChannelInput channelInput) {
        if (!BaseDataChannel.serverDispatch(object, string, entityPlayer, channelInput)) {
            System.out.printf("No ServerMessageHandler for '%s' found in %s\n", string, object.getClass().getName());
        }
    }

    protected void onReceiveFromServer(ChannelInput channelInput) {
        String string = channelInput.readUTF();
        for (Object e : this.handlers) {
            if (!BaseDataChannel.clientDispatch(e, string, channelInput)) continue;
            return;
        }
        System.out.printf("No ClientMessageHandler for '%s' found in registered handlers\n", string);
    }

    public static boolean clientDispatch(Object object, String string, ChannelInput channelInput) {
        if (object != null) {
            for (Method method : object.getClass().getMethods()) {
                ClientMessageHandler clientMessageHandler = method.getAnnotation(ClientMessageHandler.class);
                if (clientMessageHandler == null || clientMessageHandler.value() != string) continue;
                try {
                    method.invoke(object, channelInput);
                }
                catch (Exception exception) {
                    throw new RuntimeException(String.format("Exception while calling client-side handler %s.%s for message %s", object.getClass().getName(), method.getName(), string), exception);
                }
                return true;
            }
        }
        return false;
    }

    public static void doClientDispatch(Object object, String string, ChannelInput channelInput) {
        if (!BaseDataChannel.clientDispatch(object, string, channelInput)) {
            System.out.printf("No ClientMessageHandler for '%s' found in %s\n", string, object.getClass().getName());
        }
    }

    @ChannelHandler.Sharable
    static class DataHandler
    extends ChannelInboundHandlerAdapter {
        BaseDataChannel channel;

        DataHandler(BaseDataChannel baseDataChannel) {
            this.channel = baseDataChannel;
        }

        public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
            if (object instanceof FMLProxyPacket) {
                this.handleProxyPacket(channelHandlerContext, (FMLProxyPacket)object);
            } else {
                System.out.printf("BaseDataChannel.DataHandler: Received unexpected message type %s\n", object.getClass().getName());
            }
        }

        protected void handleProxyPacket(ChannelHandlerContext channelHandlerContext, FMLProxyPacket fMLProxyPacket) {
            ChannelInputStream channelInputStream = new ChannelInputStream(fMLProxyPacket.payload());
            if (channelHandlerContext.channel() == this.channel.pipes.get(Side.SERVER)) {
                INetHandler iNetHandler = (INetHandler)channelHandlerContext.channel().attr(NetworkRegistry.NET_HANDLER).get();
                EntityPlayerMP entityPlayerMP = ((NetHandlerPlayServer)iNetHandler).field_147369_b;
                this.channel.onReceiveFromClient((EntityPlayer)entityPlayerMP, channelInputStream);
            } else {
                this.channel.onReceiveFromServer(channelInputStream);
            }
        }
    }

    static class DataPacket
    implements ChannelOutput {
        ByteBufOutputStream out = new ByteBufOutputStream(Unpooled.buffer());
        BaseDataChannel channel;
        Side side;
        FMLOutboundHandler.OutboundTarget target;
        Object arg;

        DataPacket(BaseDataChannel baseDataChannel, Side side, FMLOutboundHandler.OutboundTarget outboundTarget, Object object) {
            this.channel = baseDataChannel;
            this.side = side;
            this.target = outboundTarget;
            this.arg = object;
        }

        @Override
        public void write(byte[] byArray) {
            try {
                this.out.write(byArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            try {
                this.out.write(byArray, n, n2);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void write(int n) {
            try {
                this.out.write(n);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeBoolean(boolean bl) {
            try {
                this.out.writeBoolean(bl);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeByte(int n) {
            try {
                this.out.writeByte(n);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeBytes(String string) {
            try {
                this.out.writeBytes(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeChar(int n) {
            try {
                this.out.writeChar(n);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeChars(String string) {
            try {
                this.out.writeChars(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeDouble(double d) {
            try {
                this.out.writeDouble(d);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeFloat(float f) {
            try {
                this.out.writeFloat(f);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeInt(int n) {
            try {
                this.out.writeInt(n);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeLong(long l) {
            try {
                this.out.writeLong(l);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeShort(int n) {
            try {
                this.out.writeShort(n);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void writeUTF(String string) {
            try {
                this.out.writeUTF(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void close() {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            ByteBuf byteBuf = this.out.buffer();
            FMLProxyPacket fMLProxyPacket = new FMLProxyPacket(new PacketBuffer(byteBuf), this.channel.name);
            FMLEmbeddedChannel fMLEmbeddedChannel = this.channel.pipes.get(this.side);
            fMLEmbeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)this.target);
            fMLEmbeddedChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(this.arg);
            fMLEmbeddedChannel.writeAndFlush((Object)fMLProxyPacket).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    static class ChannelInputStream
    extends ByteBufInputStream
    implements ChannelInput {
        public ChannelInputStream(ByteBuf byteBuf) {
            super(byteBuf);
        }

        @Override
        public boolean readBoolean() {
            try {
                return super.readBoolean();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public byte readByte() {
            try {
                return super.readByte();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public char readChar() {
            try {
                return super.readChar();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public double readDouble() {
            try {
                return super.readDouble();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public float readFloat() {
            try {
                return super.readFloat();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void readFully(byte[] byArray) {
            try {
                super.readFully(byArray);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public void readFully(byte[] byArray, int n, int n2) {
            try {
                super.readFully(byArray, n, n2);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public int readInt() {
            try {
                return super.readInt();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public String readLine() {
            try {
                return super.readLine();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public long readLong() {
            try {
                return super.readLong();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public short readShort() {
            try {
                return super.readShort();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public int readUnsignedByte() {
            try {
                return super.readUnsignedByte();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public int readUnsignedShort() {
            try {
                return super.readUnsignedShort();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public String readUTF() {
            try {
                return super.readUTF();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public int skipBytes(int n) {
            try {
                return super.skipBytes(n);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static interface ChannelOutput
    extends DataOutput {
        @Override
        public void write(byte[] var1);

        @Override
        public void write(byte[] var1, int var2, int var3);

        @Override
        public void write(int var1);

        @Override
        public void writeBoolean(boolean var1);

        @Override
        public void writeByte(int var1);

        @Override
        public void writeBytes(String var1);

        @Override
        public void writeChar(int var1);

        @Override
        public void writeChars(String var1);

        @Override
        public void writeDouble(double var1);

        @Override
        public void writeFloat(float var1);

        @Override
        public void writeInt(int var1);

        @Override
        public void writeLong(long var1);

        @Override
        public void writeShort(int var1);

        @Override
        public void writeUTF(String var1);

        public void close();
    }

    public static interface ChannelInput
    extends DataInput {
        @Override
        public boolean readBoolean();

        @Override
        public byte readByte();

        @Override
        public char readChar();

        @Override
        public double readDouble();

        @Override
        public float readFloat();

        @Override
        public void readFully(byte[] var1);

        @Override
        public void readFully(byte[] var1, int var2, int var3);

        @Override
        public int readInt();

        @Override
        public String readLine();

        @Override
        public long readLong();

        @Override
        public short readShort();

        @Override
        public int readUnsignedByte();

        @Override
        public int readUnsignedShort();

        @Override
        public String readUTF();

        @Override
        public int skipBytes(int var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ClientMessageHandler {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ServerMessageHandler {
        public String value();
    }
}

