/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseConfiguration;
import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseModel;
import gcewing.architecture.BaseSubsystem;
import gcewing.architecture.Trans3;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BaseMod<CLIENT extends BaseModClient<? extends BaseMod>>
extends BaseSubsystem
implements IGuiHandler {
    protected Map<ResourceLocation, BaseModClient.IModel> modelCache = new HashMap<ResourceLocation, BaseModClient.IModel>();
    public String modID;
    public BaseConfiguration config;
    public String modPackage;
    public String assetKey;
    public String resourceDir;
    public URL resourceURL;
    public CLIENT client;
    public IGuiHandler proxy;
    public boolean serverSide;
    public boolean clientSide;
    public CreativeTabs creativeTab;
    public File cfgFile;
    public List<Block> registeredBlocks = new ArrayList<Block>();
    public List<Item> registeredItems = new ArrayList<Item>();
    public List<BaseSubsystem> subsystems = new ArrayList<BaseSubsystem>();
    public boolean debugGui = false;
    public boolean debugBlockRegistration = false;
    public boolean debugCreativeTabs = false;
    public List<VSBinding> registeredVillagers = new ArrayList<VSBinding>();
    Map<Integer, Class<? extends Container>> containerClasses = new HashMap<Integer, Class<? extends Container>>();

    public void setModOf(Object object) {
        if (object instanceof ISetMod) {
            ((ISetMod)object).setMod(this);
        }
    }

    public String resourcePath(String string) {
        return this.resourceDir + string;
    }

    public BaseMod() {
        Class<?> clazz = this.getClass();
        this.modPackage = clazz.getPackage().getName();
        this.modID = BaseMod.getModID(clazz);
        this.assetKey = this.modID.toLowerCase();
        String string = "assets/" + this.assetKey + "/";
        this.resourceDir = "/" + string;
        this.resourceURL = this.getClass().getClassLoader().getResource(string);
        this.subsystems.add(this);
        this.creativeTab = CreativeTabs.field_78026_f;
    }

    static String getModID(Class clazz) {
        Mod mod = clazz.getAnnotation(Mod.class);
        if (mod instanceof Mod) {
            return mod.modid();
        }
        System.out.printf("BaseMod: Mod annotation not found\n", new Object[0]);
        return "<unknown>";
    }

    public static boolean isModLoaded(String string) {
        return Loader.isModLoaded((String)string);
    }

    @Override
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        this.serverSide = fMLPreInitializationEvent.getSide().isServer();
        this.clientSide = fMLPreInitializationEvent.getSide().isClient();
        if (this.clientSide) {
            this.client = this.initClient();
            this.proxy = this.client;
        }
        this.cfgFile = fMLPreInitializationEvent.getSuggestedConfigurationFile();
        this.loadConfig();
        this.configure();
        for (BaseSubsystem baseSubsystem : this.subsystems) {
            if (baseSubsystem != this) {
                baseSubsystem.preInit(fMLPreInitializationEvent);
            }
            baseSubsystem.configure(this.config);
            baseSubsystem.registerBlocks();
            baseSubsystem.registerTileEntities();
            baseSubsystem.registerItems();
            baseSubsystem.registerOres();
        }
        if (this.client != null) {
            ((BaseModClient)this.client).preInit(fMLPreInitializationEvent);
        }
    }

    @Override
    public void init(FMLInitializationEvent fMLInitializationEvent) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        if (this.client != null) {
            ((BaseModClient)this.client).init(fMLInitializationEvent);
        }
        for (BaseSubsystem baseSubsystem : this.subsystems) {
            if (baseSubsystem == this) continue;
            baseSubsystem.init(fMLInitializationEvent);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        for (BaseSubsystem baseSubsystem : this.subsystems) {
            if (baseSubsystem != this) {
                baseSubsystem.postInit(fMLPostInitializationEvent);
            }
            baseSubsystem.registerRecipes();
            baseSubsystem.registerRandomItems();
            baseSubsystem.registerWorldGenerators();
            baseSubsystem.registerContainers();
            baseSubsystem.registerEntities();
            baseSubsystem.registerVillagers();
            baseSubsystem.registerOther();
        }
        if (this.client != null) {
            ((BaseModClient)this.client).postInit(fMLPostInitializationEvent);
        }
        if (this.proxy == null) {
            this.proxy = this;
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, this.proxy);
        this.saveConfig();
    }

    void loadConfig() {
        this.config = new BaseConfiguration(this.cfgFile);
    }

    void saveConfig() {
        if (this.config.extended) {
            this.config.save();
        }
    }

    String qualifiedName(String string) {
        return this.modPackage + "." + string;
    }

    @Override
    protected void registerModelLocations() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerModelLocations();
        }
    }

    @Override
    protected void registerScreens() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerScreens();
        }
    }

    @Override
    protected void registerRenderers() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerRenderers();
        }
    }

    @Override
    protected void registerOtherClient() {
        if (this.client != null) {
            ((BaseModClient)this.client).registerOther();
        }
    }

    void configure() {
    }

    CLIENT initClient() {
        return (CLIENT)new BaseModClient<BaseMod>(this);
    }

    public BaseSubsystem integrateWith(String string, String string2) {
        BaseSubsystem baseSubsystem = null;
        if (BaseMod.isModLoaded(string)) {
            baseSubsystem = this.newSubsystem(string2);
            this.subsystems.add(baseSubsystem);
        }
        return baseSubsystem;
    }

    BaseSubsystem newSubsystem(String string) {
        try {
            return (BaseSubsystem)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Item newItem(String string) {
        return this.newItem(string, Item.class);
    }

    public <ITEM extends Item> ITEM newItem(String string, Class<ITEM> clazz) {
        Item item;
        try {
            Constructor<ITEM> constructor = clazz.getConstructor(new Class[0]);
            item = (Item)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return (ITEM)this.addItem(item, string);
    }

    public <ITEM extends Item> ITEM addItem(ITEM ITEM, String string) {
        String string2 = this.assetKey + ":" + string;
        ITEM.func_77655_b(string2);
        GameRegistry.registerItem(ITEM, (String)string);
        if (this.debugBlockRegistration) {
            System.out.printf("BaseMod.addItem: Registered %s as %s\n", ITEM, string);
        }
        if (this.creativeTab != null) {
            if (this.debugCreativeTabs) {
                System.out.printf("BaseMod.addItem: Setting creativeTab of %s to %s\n", string, this.creativeTab);
            }
            ITEM.func_77637_a(this.creativeTab);
        }
        this.registeredItems.add(ITEM);
        return ITEM;
    }

    public Block newBlock(String string) {
        return this.newBlock(string, Block.class);
    }

    public <BLOCK extends Block> BLOCK newBlock(String string, Class<BLOCK> clazz) {
        return this.newBlock(string, clazz, ItemBlock.class);
    }

    public <BLOCK extends Block> BLOCK newBlock(String string, Class<BLOCK> clazz, Class clazz2) {
        Block block;
        try {
            Constructor<BLOCK> constructor = clazz.getConstructor(new Class[0]);
            block = (Block)constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return (BLOCK)this.addBlock(block, string, clazz2);
    }

    public <BLOCK extends Block> BLOCK addBlock(BLOCK BLOCK, String string) {
        return this.addBlock(BLOCK, string, ItemBlock.class);
    }

    public <BLOCK extends Block> BLOCK addBlock(BLOCK BLOCK, String string, Class clazz) {
        String string2 = this.assetKey + ":" + string;
        BLOCK.func_149663_c(string2);
        GameRegistry.registerBlock(BLOCK, (Class)clazz, (String)string);
        if (this.creativeTab != null) {
            BLOCK.func_149647_a(this.creativeTab);
        }
        this.registeredBlocks.add(BLOCK);
        return BLOCK;
    }

    public void addOre(String string, Block block) {
        OreDictionary.registerOre((String)string, (ItemStack)new ItemStack(block));
    }

    public void addOre(String string, Item item) {
        OreDictionary.registerOre((String)string, (Item)item);
    }

    public static boolean blockMatchesOre(Block block, String string) {
        return BaseMod.stackMatchesOre(new ItemStack(block), string);
    }

    public static boolean itemMatchesOre(Item item, String string) {
        return BaseMod.stackMatchesOre(new ItemStack(item), string);
    }

    public static boolean stackMatchesOre(ItemStack itemStack, String string) {
        int n = OreDictionary.getOreID((String)string);
        for (int n2 : OreDictionary.getOreIDs((ItemStack)itemStack)) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public void newRecipe(Item item, int n, Object ... objectArray) {
        this.newRecipe(new ItemStack(item, n), objectArray);
    }

    public void newRecipe(Block block, int n, Object ... objectArray) {
        this.newRecipe(new ItemStack(block, n), objectArray);
    }

    public void newRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemStack, objectArray));
    }

    public void newShapelessRecipe(Block block, int n, Object ... objectArray) {
        this.newShapelessRecipe(new ItemStack(block, n), objectArray);
    }

    public void newShapelessRecipe(Item item, int n, Object ... objectArray) {
        this.newShapelessRecipe(new ItemStack(item, n), objectArray);
    }

    public void newShapelessRecipe(ItemStack itemStack, Object ... objectArray) {
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(itemStack, objectArray));
    }

    public void newSmeltingRecipe(Item item, int n, Item item2) {
        this.newSmeltingRecipe(item, n, item2, 0);
    }

    public void newSmeltingRecipe(Item item, int n, Item item2, int n2) {
        GameRegistry.addSmelting((Item)item2, (ItemStack)new ItemStack(item, n), (float)n2);
    }

    public void newSmeltingRecipe(Item item, int n, Block block) {
        this.newSmeltingRecipe(item, n, block, 0);
    }

    public void newSmeltingRecipe(Item item, int n, Block block, int n2) {
        GameRegistry.addSmelting((Block)block, (ItemStack)new ItemStack(item, n), (float)n2);
    }

    public void addRandomChestItem(ItemStack itemStack, int n, int n2, int n3, String ... stringArray) {
        WeightedRandomChestContent weightedRandomChestContent = new WeightedRandomChestContent(itemStack, n, n2, n3);
        for (int i = 0; i < stringArray.length; ++i) {
            ChestGenHooks.addItem((String)stringArray[i], (WeightedRandomChestContent)weightedRandomChestContent);
        }
    }

    public void addEntity(Class<? extends Entity> clazz, String string, Enum enum_) {
        this.addEntity(clazz, string, enum_.ordinal());
    }

    public void addEntity(Class<? extends Entity> clazz, String string, int n) {
        this.addEntity(clazz, string, n, 1, true);
    }

    public void addEntity(Class<? extends Entity> clazz, String string, Enum enum_, int n, boolean bl) {
        this.addEntity(clazz, string, enum_.ordinal(), n, bl);
    }

    public void addEntity(Class<? extends Entity> clazz, String string, int n, int n2, boolean bl) {
        System.out.printf("%s: BaseMod.addEntity: %s, \"%s\", %s\n", this.getClass().getSimpleName(), clazz.getSimpleName(), string, n);
        EntityRegistry.registerModEntity(clazz, (String)string, (int)n, (Object)this, (int)256, (int)n2, (boolean)bl);
    }

    int addVillager(String string, ResourceLocation resourceLocation) {
        int n = this.config.getVillager(string);
        VSBinding vSBinding = new VSBinding();
        vSBinding.id = n;
        vSBinding.object = resourceLocation;
        this.registeredVillagers.add(vSBinding);
        return n;
    }

    public ResourceLocation resourceLocation(String string) {
        return new ResourceLocation(this.assetKey, string);
    }

    public String soundName(String string) {
        return this.assetKey + ":" + string;
    }

    public ResourceLocation textureLocation(String string) {
        return this.resourceLocation(string);
    }

    public ResourceLocation modelLocation(String string) {
        return this.resourceLocation("models/" + string);
    }

    public BaseModClient.IModel getModel(String string) {
        ResourceLocation resourceLocation = this.modelLocation(string);
        BaseModClient.IModel iModel = this.modelCache.get(resourceLocation);
        if (iModel == null) {
            iModel = BaseModel.fromResource(resourceLocation);
            this.modelCache.put(resourceLocation, iModel);
        }
        return iModel;
    }

    public static void sendTileEntityUpdate(TileEntity tileEntity) {
        Packet packet = tileEntity.func_145844_m();
        if (packet != null) {
            BlockPos blockPos = tileEntity.func_174877_v();
            int n = blockPos.func_177958_n() >> 4;
            int n2 = blockPos.func_177952_p() >> 4;
            WorldServer worldServer = (WorldServer)tileEntity.func_145831_w();
            ServerConfigurationManager serverConfigurationManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71203_ab();
            PlayerManager playerManager = worldServer.func_73040_p();
            for (EntityPlayerMP entityPlayerMP : serverConfigurationManager.field_72404_b) {
                if (!playerManager.func_72694_a(entityPlayerMP, n, n2)) continue;
                entityPlayerMP.field_71135_a.func_147359_a(packet);
            }
        }
    }

    @Override
    protected void registerContainers() {
    }

    public void addContainer(Enum enum_, Class<? extends Container> clazz) {
        this.addContainer(enum_.ordinal(), clazz);
    }

    public void addContainer(int n, Class<? extends Container> clazz) {
        this.containerClasses.put(n, clazz);
    }

    public void openGui(EntityPlayer entityPlayer, Enum enum_, TileEntity tileEntity) {
        this.openGui(entityPlayer, enum_, tileEntity, 0);
    }

    public void openGui(EntityPlayer entityPlayer, Enum enum_, TileEntity tileEntity, int n) {
        this.openGui(entityPlayer, enum_.ordinal(), tileEntity, n);
    }

    public void openGui(EntityPlayer entityPlayer, int n, TileEntity tileEntity) {
        this.openGui(entityPlayer, n, tileEntity, 0);
    }

    public void openGui(EntityPlayer entityPlayer, int n, TileEntity tileEntity, int n2) {
        this.openGui(entityPlayer, n, tileEntity.func_145831_w(), tileEntity.func_174877_v(), n2);
    }

    public void openGui(EntityPlayer entityPlayer, Enum enum_, World world, BlockPos blockPos) {
        this.openGui(entityPlayer, enum_, world, blockPos, 0);
    }

    public void openGui(EntityPlayer entityPlayer, Enum enum_, World world, BlockPos blockPos, int n) {
        this.openGui(entityPlayer, enum_.ordinal(), world, blockPos, n);
    }

    public void openGui(EntityPlayer entityPlayer, int n, World world, BlockPos blockPos, int n2) {
        this.openGui(entityPlayer, n | n2 << 16, world, blockPos);
    }

    public void openGui(EntityPlayer entityPlayer, int n, World world, BlockPos blockPos) {
        int n2 = blockPos.func_177958_n();
        int n3 = blockPos.func_177956_o();
        int n4 = blockPos.func_177952_p();
        if (this.debugGui) {
            System.out.printf("BaseMod.openGui: for %s with id 0x%x in %s at (%s, %s, %s)\n", this, n, world, n2, n3, n4);
        }
        entityPlayer.openGui((Object)this, n, world, n2, n3, n4);
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return this.getServerGuiElement(n, entityPlayer, world, new BlockPos(n2, n3, n4));
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: for id 0x%x\n", n);
        }
        int n2 = n >> 16;
        Class<? extends Container> clazz = this.containerClasses.get(n &= 0xFFFF);
        Object object = clazz != null ? this.createGuiElement(clazz, entityPlayer, world, blockPos, n2) : this.getGuiContainer(n, entityPlayer, world, blockPos, n2);
        if (this.debugGui) {
            System.out.printf("BaseMod.getServerGuiElement: Returning %s\n", object);
        }
        this.setModOf(object);
        return object;
    }

    Container getGuiContainer(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos, int n2) {
        if (this.debugGui) {
            System.out.printf("%s: BaseMod.getGuiContainer: No Container class found for gui id %d\n", this, n);
        }
        return null;
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return null;
    }

    Object createGuiElement(Class clazz, EntityPlayer entityPlayer, World world, BlockPos blockPos, int n) {
        try {
            Constructor constructor;
            Method method;
            if (this.debugGui) {
                System.out.printf("BaseMod.createGuiElement: Looking for create method on %s for %s in %s\n", clazz, entityPlayer, world);
            }
            if ((method = this.getMethod(clazz, "create", EntityPlayer.class, World.class, BlockPos.class, Integer.TYPE)) != null) {
                return method.invoke(null, entityPlayer, world, blockPos, n);
            }
            method = this.getMethod(clazz, "create", EntityPlayer.class, World.class, BlockPos.class);
            if (method != null) {
                return method.invoke(null, entityPlayer, world, blockPos);
            }
            if (this.debugGui) {
                System.out.printf("BaseMod.createGuiElement: Looking for constructor on %s\n", clazz);
            }
            if ((constructor = this.getConstructor(clazz, EntityPlayer.class, World.class, BlockPos.class, Integer.TYPE)) != null) {
                return constructor.newInstance(entityPlayer, world, blockPos, n);
            }
            constructor = this.getConstructor(clazz, EntityPlayer.class, World.class, BlockPos.class);
            if (constructor != null) {
                return constructor.newInstance(entityPlayer, world, blockPos);
            }
            throw new RuntimeException(String.format("%s: No suitable gui element constructor found for %s\n", this.modID, clazz));
        }
        catch (Exception exception) {
            BaseMod.reportExceptionCause(exception);
            return null;
        }
    }

    Method getMethod(Class clazz, String string, Class ... classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    Constructor getConstructor(Class clazz, Class ... classArray) {
        try {
            return clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void reportExceptionCause(Exception exception) {
        Throwable throwable = exception.getCause();
        System.out.printf("BaseMod.createGuiElement: %s: %s\n", exception, throwable);
        if (throwable != null) {
            throwable.printStackTrace();
        } else {
            exception.printStackTrace();
        }
    }

    static class VSBinding
    extends IDBinding<ResourceLocation> {
        VSBinding() {
        }
    }

    public static class ModelSpec {
        String modelName;
        String[] textureNames;

        public ModelSpec(String string, String ... stringArray) {
            this.modelName = string;
            this.textureNames = stringArray;
        }
    }

    static class IDBinding<T> {
        public int id;
        public T object;

        IDBinding() {
        }
    }

    static interface ISetMod {
        public void setMod(BaseMod var1);
    }

    static interface ITileEntity {
        public void onAddedToWorld();
    }

    static interface IItem
    extends ITextureConsumer {
        public ModelSpec getModelSpec(ItemStack var1);
    }

    static interface IBlock
    extends ITextureConsumer {
        public ModelSpec getModelSpec(IBlockState var1);

        public Trans3 localToGlobalTransformation(IBlockAccess var1, BlockPos var2, IBlockState var3);

        public IBlockState getParticleState(IBlockAccess var1, BlockPos var2);
    }

    static interface ITextureConsumer {
        public String[] getTextureNames();
    }
}

