/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBakedRenderTarget;
import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseModelRenderer;
import gcewing.architecture.BaseSubsystem;
import gcewing.architecture.BaseTexture;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BaseWorldRenderTarget;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class BaseModClient<MOD extends BaseMod<? extends BaseModClient>>
implements IGuiHandler {
    public boolean debugModelRegistration = false;
    MOD base;
    boolean customRenderingRequired;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();
    protected Map<Block, ICustomRenderer> blockRenderers = new HashMap<Block, ICustomRenderer>();
    protected Map<Item, ICustomRenderer> itemRenderers = new HashMap<Item, ICustomRenderer>();
    protected Map<IBlockState, ICustomRenderer> stateRendererCache = new HashMap<IBlockState, ICustomRenderer>();
    protected Map<ResourceLocation, ITexture> textureCache = new HashMap<ResourceLocation, ITexture>();
    protected CustomBlockRendererDispatcher customBlockRendererDispatcher;
    protected CustomItemRenderDispatch customItemRenderDispatch;

    public BaseModClient(MOD MOD) {
        this.base = MOD;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
    }

    public void init(FMLInitializationEvent fMLInitializationEvent) {
    }

    public void postInit(FMLPostInitializationEvent fMLPostInitializationEvent) {
        for (BaseSubsystem baseSubsystem : ((BaseMod)this.base).subsystems) {
            baseSubsystem.registerScreens();
            baseSubsystem.registerRenderers();
            baseSubsystem.registerOtherClient();
        }
        this.registerDefaultModelLocations();
        for (BaseSubsystem baseSubsystem : ((BaseMod)this.base).subsystems) {
            baseSubsystem.registerModelLocations();
        }
        this.registerSavedVillagerSkins();
        if (this.customRenderingRequired) {
            this.enableCustomRendering();
        }
    }

    void registerSavedVillagerSkins() {
        VillagerRegistry villagerRegistry = VillagerRegistry.instance();
        for (BaseMod.VSBinding vSBinding : ((BaseMod)this.base).registeredVillagers) {
            villagerRegistry.registerVillagerSkin(vSBinding.id, (ResourceLocation)vSBinding.object);
        }
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum enum_, Class<? extends GuiScreen> clazz) {
        this.addScreen(enum_.ordinal(), clazz);
    }

    public void addScreen(int n, Class<? extends GuiScreen> clazz) {
        this.screenClasses.put(n, clazz);
    }

    void registerRenderers() {
    }

    void addTileEntityRenderer(Class<? extends TileEntity> clazz, TileEntitySpecialRenderer tileEntitySpecialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)tileEntitySpecialRenderer);
    }

    void addEntityRenderer(Class<? extends Entity> clazz, Render render) {
        RenderingRegistry.registerEntityRenderingHandler(clazz, (Render)render);
    }

    public static void openClientGui(GuiScreen guiScreen) {
        FMLClientHandler.instance().getClient().func_147108_a(guiScreen);
    }

    public ResourceLocation textureLocation(String string) {
        return ((BaseMod)this.base).resourceLocation("textures/" + string);
    }

    public void bindTexture(String string) {
        BaseModClient.bindTexture(this.textureLocation(string));
    }

    public static void bindTexture(ResourceLocation resourceLocation) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(resourceLocation);
    }

    public ModelResourceLocation modelResourceLocation(String string, String string2) {
        return new ModelResourceLocation(((BaseMod)this.base).resourceLocation(string), string2);
    }

    public void registerModelLocations() {
    }

    protected void registerDefaultModelLocations() {
        BlockModelShapes blockModelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        ItemModelMesher itemModelMesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        CustomItemRenderDispatch customItemRenderDispatch = this.getCustomItemRenderDispatch();
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            Item item = Item.func_150898_a((Block)block);
            if (this.blockNeedsCustomRendering(block)) {
                if (item == null) continue;
                this.registerRenderDispatcherForItem(itemModelMesher, item, customItemRenderDispatch);
                continue;
            }
            this.registerModelLocation(itemModelMesher, item, 0, block.func_149739_a());
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            if (this.itemNeedsCustomRendering(item)) {
                this.registerRenderDispatcherForItem(itemModelMesher, item, customItemRenderDispatch);
                continue;
            }
            this.registerModelLocation(itemModelMesher, item, 0, item.func_77658_a());
        }
    }

    private void registerRenderDispatcherForItem(ItemModelMesher itemModelMesher, Item item, CustomItemRenderDispatch customItemRenderDispatch) {
        if (this.debugModelRegistration) {
            System.out.printf("BaseMod: Registering model location %s for %s\n", customItemRenderDispatch.modelLocation, item);
        }
        itemModelMesher.func_178086_a(item, 0, customItemRenderDispatch.modelLocation);
    }

    protected boolean blockNeedsCustomRendering(Block block) {
        return this.blockRenderers.containsKey(block) || this.specifiesTextures(block);
    }

    protected boolean itemNeedsCustomRendering(Item item) {
        return this.itemRenderers.containsKey(item) || this.specifiesTextures(item);
    }

    protected boolean specifiesTextures(Object object) {
        return object instanceof BaseMod.ITextureConsumer && ((BaseMod.ITextureConsumer)object).getTextureNames() != null;
    }

    protected void registerModelLocation(ItemModelMesher itemModelMesher, Item item, int n, String string) {
        String string2 = string.substring(5);
        if (this.debugModelRegistration) {
            System.out.printf("BaseMod: Registering model location %s#inventory\n", string2);
        }
        itemModelMesher.func_178086_a(item, 0, new ModelResourceLocation(string2, "inventory"));
    }

    public Object getServerGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return ((BaseMod)this.base).getServerGuiElement(n, entityPlayer, world, n2, n3, n4);
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, int n2, int n3, int n4) {
        return this.getClientGuiElement(n, entityPlayer, world, new BlockPos(n2, n3, n4));
    }

    public Object getClientGuiElement(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos) {
        Class<? extends GuiScreen> clazz;
        int n2 = n >> 16;
        n &= 0xFFFF;
        Object object = null;
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: for id %s\n", n);
        }
        if ((clazz = this.screenClasses.get(n)) != null) {
            block14: {
                Class<? extends Container> clazz2;
                if (((BaseMod)this.base).debugGui) {
                    System.out.printf("BaseModClient.getClientGuiElement: Instantiating %s\n", clazz);
                }
                if ((clazz2 = ((BaseMod)this.base).containerClasses.get(n)) != null) {
                    try {
                        Object object2;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Looking for constructor taking %s\n", clazz2);
                        }
                        Constructor<? extends GuiScreen> constructor = clazz.getConstructor(clazz2);
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating container\n", new Object[0]);
                        }
                        if ((object2 = ((BaseMod)this.base).createGuiElement(clazz2, entityPlayer, world, blockPos, n2)) == null) break block14;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating screen with container\n", new Object[0]);
                        }
                        try {
                            object = constructor.newInstance(object2);
                        }
                        catch (Exception exception) {
                            BaseMod.reportExceptionCause(exception);
                            return null;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (object == null) {
                object = ((BaseMod)this.base).createGuiElement(clazz, entityPlayer, world, blockPos, n2);
            }
        } else {
            object = this.getGuiScreen(n, entityPlayer, world, blockPos, n2);
        }
        ((BaseMod)this.base).setModOf(object);
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: returning %s\n", object);
        }
        return object;
    }

    GuiScreen getGuiScreen(int n, EntityPlayer entityPlayer, World world, BlockPos blockPos, int n2) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, n);
        return null;
    }

    public void addBlockRenderer(Block block, ICustomRenderer iCustomRenderer) {
        this.blockRenderers.put(block, iCustomRenderer);
        this.customRenderingRequired = true;
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            this.addItemRenderer(item, iCustomRenderer);
        }
    }

    public void addItemRenderer(Item item, ICustomRenderer iCustomRenderer) {
        this.itemRenderers.put(item, iCustomRenderer);
    }

    protected ICustomRenderer getCustomRenderer(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
        Block block = iBlockState.func_177230_c();
        ICustomRenderer iCustomRenderer = this.blockRenderers.get(block);
        if (iCustomRenderer == null && block instanceof BaseMod.IBlock) {
            IBlockState iBlockState2 = block.func_176221_a(iBlockState, iBlockAccess, blockPos);
            iCustomRenderer = this.getCustomRendererForState(iBlockState2);
        }
        return iCustomRenderer;
    }

    protected ICustomRenderer getCustomRendererForSpec(BaseMod.ModelSpec modelSpec) {
        IModel iModel = this.getModel(modelSpec.modelName);
        ITexture[] iTextureArray = new ITexture[modelSpec.textureNames.length];
        for (int i = 0; i < iTextureArray.length; ++i) {
            iTextureArray[i] = this.getTexture(modelSpec.textureNames[i]);
        }
        return new BaseModelRenderer(iModel, iTextureArray);
    }

    protected ICustomRenderer getCustomRendererForState(IBlockState iBlockState) {
        BaseMod.ModelSpec modelSpec;
        Block block;
        ICustomRenderer iCustomRenderer = this.stateRendererCache.get(iBlockState);
        if (iCustomRenderer == null && (block = iBlockState.func_177230_c()) instanceof BaseMod.IBlock && (modelSpec = ((BaseMod.IBlock)block).getModelSpec(iBlockState)) != null) {
            iCustomRenderer = this.getCustomRendererForSpec(modelSpec);
            this.stateRendererCache.put(iBlockState, iCustomRenderer);
        }
        return iCustomRenderer;
    }

    public IModel getModel(String string) {
        return ((BaseMod)this.base).getModel(string);
    }

    public ITexture getTexture(String string) {
        ResourceLocation resourceLocation = ((BaseMod)this.base).textureLocation(string);
        return this.textureCache.get(resourceLocation);
    }

    @SubscribeEvent
    public void onTextureStitchEventPre(TextureStitchEvent.Pre pre) {
        this.textureCache.clear();
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            this.registerSprites(pre.map, block);
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            this.registerSprites(pre.map, item);
        }
    }

    protected void registerSprites(TextureMap textureMap, Object object) {
        System.out.printf("BaseModClient.registerSprites: for %s\n", object);
        if (object instanceof BaseMod.ITextureConsumer) {
            String[] stringArray = ((BaseMod.ITextureConsumer)object).getTextureNames();
            System.out.printf("BaseModClient.registerSprites: texture names = %s\n", new Object[]{stringArray});
            if (stringArray != null) {
                this.customRenderingRequired = true;
                for (String string : stringArray) {
                    ResourceLocation resourceLocation = ((BaseMod)this.base).textureLocation(string);
                    if (this.textureCache.get(resourceLocation) != null) continue;
                    TextureAtlasSprite textureAtlasSprite = textureMap.func_174942_a(resourceLocation);
                    ITexture iTexture = BaseTexture.fromSprite(textureAtlasSprite);
                    this.textureCache.put(resourceLocation, iTexture);
                }
            }
        }
    }

    protected boolean customRenderBlockToWorld(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, WorldRenderer worldRenderer, TextureAtlasSprite textureAtlasSprite, ICustomRenderer iCustomRenderer) {
        BaseWorldRenderTarget baseWorldRenderTarget = new BaseWorldRenderTarget(iBlockAccess, blockPos, worldRenderer, textureAtlasSprite);
        EnumWorldBlockLayer enumWorldBlockLayer = MinecraftForgeClient.getRenderLayer();
        iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseWorldRenderTarget, enumWorldBlockLayer, Trans3.ident);
        return baseWorldRenderTarget.end();
    }

    protected IBakedModel customRenderBlockToBakedModel(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState, ICustomRenderer iCustomRenderer) {
        BaseBakedRenderTarget baseBakedRenderTarget = new BaseBakedRenderTarget(blockPos);
        Trans3 trans3 = new Trans3(-blockPos.func_177958_n(), -blockPos.func_177956_o(), (double)(-blockPos.func_177952_p()));
        EnumWorldBlockLayer enumWorldBlockLayer = MinecraftForgeClient.getRenderLayer();
        BlockModelShapes blockModelShapes = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
        TextureAtlasSprite textureAtlasSprite = blockModelShapes.func_178122_a(this.getBlockParticleState(iBlockState, iBlockAccess, blockPos));
        iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseBakedRenderTarget, enumWorldBlockLayer, trans3);
        return baseBakedRenderTarget.getBakedModel(textureAtlasSprite);
    }

    public IBlockState getBlockParticleState(IBlockState iBlockState, IBlockAccess iBlockAccess, BlockPos blockPos) {
        Block block = iBlockState.func_177230_c();
        if (block instanceof BaseMod.IBlock) {
            return ((BaseMod.IBlock)block).getParticleState(iBlockAccess, blockPos);
        }
        return block.func_176221_a(iBlockState, iBlockAccess, blockPos);
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent modelBakeEvent) {
        this.getCustomItemRenderDispatch().install(modelBakeEvent);
    }

    protected CustomBlockRendererDispatcher getCustomBlockRendererDispatcher() {
        if (this.customBlockRendererDispatcher == null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            this.customBlockRendererDispatcher = new CustomBlockRendererDispatcher(minecraft.func_175602_ab());
            BaseUtils.setField(minecraft, "blockRenderDispatcher", "field_175618_aM", (Object)this.customBlockRendererDispatcher);
        }
        return this.customBlockRendererDispatcher;
    }

    protected CustomItemRenderDispatch getCustomItemRenderDispatch() {
        if (this.customItemRenderDispatch == null) {
            this.customItemRenderDispatch = new CustomItemRenderDispatch();
        }
        return this.customItemRenderDispatch;
    }

    public void enableCustomRendering() {
        this.getCustomBlockRendererDispatcher();
    }

    protected class CustomItemRenderDispatch
    extends CustomRenderDispatch
    implements ISmartItemModel {
        public CustomItemRenderDispatch() {
            this.modelLocation = BaseModClient.this.modelResourceLocation("__custitem__", "");
        }

        public IBakedModel handleItemState(ItemStack itemStack) {
            Object object;
            Item item = itemStack.func_77973_b();
            ICustomRenderer iCustomRenderer = BaseModClient.this.itemRenderers.get(item);
            if (iCustomRenderer == null && item instanceof BaseMod.IItem && (object = ((BaseMod.IItem)item).getModelSpec(itemStack)) != null) {
                iCustomRenderer = BaseModClient.this.getCustomRendererForSpec((BaseMod.ModelSpec)object);
            }
            if (iCustomRenderer == null && (object = Block.func_149634_a((Item)item)) != null) {
                iCustomRenderer = BaseModClient.this.getCustomRendererForState(object.func_176223_P());
            }
            if (iCustomRenderer != null) {
                GlStateManager.func_179103_j((int)7425);
                object = new BaseBakedRenderTarget();
                iCustomRenderer.renderItemStack(itemStack, (IRenderTarget)object);
                return ((BaseBakedRenderTarget)object).getBakedModel();
            }
            return null;
        }
    }

    protected static class CustomRenderDispatch
    implements IBakedModel {
        public ModelResourceLocation modelLocation;

        protected CustomRenderDispatch() {
        }

        public void install(ModelBakeEvent modelBakeEvent) {
            System.out.printf("BaseModClient: Installing %s at %s\n", this, this.modelLocation);
            modelBakeEvent.modelRegistry.func_82595_a((Object)this.modelLocation, (Object)this);
        }

        public List<BakedQuad> func_177551_a(EnumFacing enumFacing) {
            return null;
        }

        public List<BakedQuad> func_177550_a() {
            return null;
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_177553_d() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return null;
        }

        public ItemCameraTransforms func_177552_f() {
            return null;
        }
    }

    protected class CustomBlockRendererDispatcher
    extends BlockRendererDispatcher {
        protected BlockRendererDispatcher base;

        public CustomBlockRendererDispatcher(BlockRendererDispatcher blockRendererDispatcher) {
            super(null, null);
            this.base = blockRendererDispatcher;
        }

        public BlockModelShapes func_175023_a() {
            return this.base.func_175023_a();
        }

        public BlockModelRenderer func_175019_b() {
            return this.base.func_175019_b();
        }

        public IBakedModel func_175022_a(IBlockState iBlockState, IBlockAccess iBlockAccess, BlockPos blockPos) {
            return this.base.func_175022_a(iBlockState, iBlockAccess, blockPos);
        }

        public void func_175016_a(IBlockState iBlockState, float f) {
            this.base.func_175016_a(iBlockState, f);
        }

        public boolean func_175021_a(Block block, int n) {
            return this.base.func_175021_a(block, n);
        }

        public void func_175020_a(IBlockState iBlockState, BlockPos blockPos, TextureAtlasSprite textureAtlasSprite, IBlockAccess iBlockAccess) {
            ICustomRenderer iCustomRenderer = BaseModClient.this.getCustomRenderer(iBlockAccess, blockPos, iBlockState);
            if (iCustomRenderer != null) {
                BaseBakedRenderTarget baseBakedRenderTarget = new BaseBakedRenderTarget(blockPos, textureAtlasSprite);
                Trans3 trans3 = new Trans3(-blockPos.func_177958_n(), -blockPos.func_177956_o(), (double)(-blockPos.func_177952_p()));
                Block block = iBlockState.func_177230_c();
                for (EnumWorldBlockLayer enumWorldBlockLayer : EnumWorldBlockLayer.values()) {
                    if (!block.canRenderInLayer(enumWorldBlockLayer)) continue;
                    iCustomRenderer.renderBlock(iBlockAccess, blockPos, iBlockState, baseBakedRenderTarget, enumWorldBlockLayer, trans3);
                }
                IBakedModel iBakedModel = baseBakedRenderTarget.getBakedModel();
                WorldRenderer worldRenderer = Tessellator.func_178181_a().func_178180_c();
                this.func_175019_b().func_178259_a(iBlockAccess, iBakedModel, iBlockState, blockPos, worldRenderer);
            } else {
                this.base.func_175020_a(iBlockState, blockPos, textureAtlasSprite, iBlockAccess);
            }
        }

        public boolean func_175018_a(IBlockState iBlockState, BlockPos blockPos, IBlockAccess iBlockAccess, WorldRenderer worldRenderer) {
            ICustomRenderer iCustomRenderer = BaseModClient.this.getCustomRenderer(iBlockAccess, blockPos, iBlockState);
            if (iCustomRenderer != null) {
                return BaseModClient.this.customRenderBlockToWorld(iBlockAccess, blockPos, iBlockState, worldRenderer, null, iCustomRenderer);
            }
            return this.base.func_175018_a(iBlockState, blockPos, iBlockAccess, worldRenderer);
        }
    }

    public static interface IModel {
        public AxisAlignedBB getBounds();

        public void addBoxesToList(Trans3 var1, List var2);

        public void render(Trans3 var1, IRenderTarget var2, ITexture ... var3);
    }

    public static interface IRenderTarget {
        public void setTexture(ITexture var1);

        public void setColor(double var1, double var3, double var5, double var7);

        public void setNormal(Vector3 var1);

        public void beginTriangle();

        public void beginQuad();

        public void addVertex(Vector3 var1, double var2, double var4);

        public void addProjectedVertex(Vector3 var1, EnumFacing var2);

        public void endFace();
    }

    public static interface ITexture {
        public ResourceLocation location();

        public int tintIndex();

        public double red();

        public double green();

        public double blue();

        public double interpolateU(double var1);

        public double interpolateV(double var1);

        public boolean isEmissive();

        public boolean isProjected();

        public boolean isSolid();

        public ITexture tinted(int var1);

        public ITexture colored(double var1, double var3, double var5);

        public ITexture projected();
    }

    public static interface ICustomRenderer {
        public void renderBlock(IBlockAccess var1, BlockPos var2, IBlockState var3, IRenderTarget var4, EnumWorldBlockLayer var5, Trans3 var6);

        public void renderItemStack(ItemStack var1, IRenderTarget var2);
    }
}

