/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import com.google.common.base.Predicate;
import gcewing.architecture.BaseBlock;
import gcewing.architecture.BaseTileEntity;
import gcewing.architecture.Trans3;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BaseOrientation {
    public static BaseBlock.IOrientationHandler orient4WaysByState = new Orient4WaysByState();
    public static BaseBlock.IOrientationHandler orient24WaysByTE = new Orient24WaysByTE();

    public static class Orient24WaysByTE
    extends BaseBlock.Orient1Way {
        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
            TileEntity tileEntity = iBlockAccess.func_175625_s(blockPos);
            if (tileEntity instanceof BaseTileEntity) {
                BaseTileEntity baseTileEntity = (BaseTileEntity)tileEntity;
                return baseTileEntity.localToGlobalTransformation(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
            }
            return super.localToGlobalTransformation(iBlockAccess, blockPos, iBlockState);
        }
    }

    public static class Orient4WaysByState
    implements BaseBlock.IOrientationHandler {
        public IProperty FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

        @Override
        public void defineProperties(BaseBlock baseBlock) {
            baseBlock.addProperty(this.FACING);
        }

        @Override
        public IBlockState onBlockPlaced(Block block, World world, BlockPos blockPos, EnumFacing enumFacing, float f, float f2, float f3, int n, EntityLivingBase entityLivingBase) {
            EnumFacing enumFacing2 = entityLivingBase.func_174811_aO().func_176746_e();
            return block.func_176223_P().func_177226_a(this.FACING, (Comparable)enumFacing2);
        }

        @Override
        public Trans3 localToGlobalTransformation(IBlockAccess iBlockAccess, BlockPos blockPos, IBlockState iBlockState) {
            int n;
            EnumFacing enumFacing = (EnumFacing)iBlockState.func_177229_b(this.FACING);
            switch (enumFacing) {
                case EAST: {
                    n = 0;
                    break;
                }
                case NORTH: {
                    n = 1;
                    break;
                }
                case WEST: {
                    n = 2;
                    break;
                }
                case SOUTH: {
                    n = 3;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return new Trans3(blockPos).turn(n);
        }
    }
}

