/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseModClient;
import gcewing.architecture.BaseTexture;
import gcewing.architecture.Vector3;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public abstract class BaseRenderTarget
implements BaseModClient.IRenderTarget {
    protected double blockX;
    protected double blockY;
    protected double blockZ;
    protected int verticesPerFace;
    protected int vertexCount;
    protected BaseModClient.ITexture texture;
    protected Vector3 normal;
    protected EnumFacing face;
    protected float red = 1.0f;
    protected float green = 1.0f;
    protected float blue = 1.0f;
    protected float alpha = 1.0f;
    protected float shade;
    protected boolean expandTrianglesToQuads;
    protected boolean textureOverride;

    public BaseRenderTarget(double d, double d2, double d3, TextureAtlasSprite textureAtlasSprite) {
        this.blockX = d;
        this.blockY = d2;
        this.blockZ = d3;
        if (textureAtlasSprite != null) {
            this.texture = BaseTexture.fromSprite(textureAtlasSprite);
            this.textureOverride = true;
        }
    }

    @Override
    public void beginTriangle() {
        this.setMode(3);
    }

    @Override
    public void beginQuad() {
        this.setMode(4);
    }

    protected void setMode(int n) {
        if (this.vertexCount != 0) {
            throw new IllegalStateException("Changing mode in mid-face");
        }
        this.verticesPerFace = n;
    }

    @Override
    public void setTexture(BaseModClient.ITexture iTexture) {
        if (!this.textureOverride) {
            if (iTexture == null) {
                throw new IllegalArgumentException("Setting null texture");
            }
            this.texture = iTexture;
        }
    }

    @Override
    public void setColor(double d, double d2, double d3, double d4) {
        this.red = (float)d;
        this.green = (float)d2;
        this.blue = (float)d3;
        this.alpha = (float)d4;
    }

    @Override
    public void setNormal(Vector3 vector3) {
        this.normal = vector3;
        this.face = vector3.facing();
        this.shade = (float)(0.6 * vector3.x * vector3.x + 0.8 * vector3.z * vector3.z + (vector3.y > 0.0 ? 1.0 : 0.5) * vector3.y * vector3.y);
    }

    @Override
    public void addVertex(Vector3 vector3, double d, double d2) {
        if (this.texture.isProjected()) {
            this.addProjectedVertex(vector3, this.face);
        } else {
            this.addUVVertex(vector3, d, d2);
        }
    }

    public void addUVVertex(Vector3 vector3, double d, double d2) {
        if (this.verticesPerFace == 0) {
            throw new IllegalStateException("No face active");
        }
        if (this.vertexCount >= this.verticesPerFace) {
            throw new IllegalStateException("Too many vertices in face");
        }
        if (this.normal == null) {
            throw new IllegalStateException("No normal");
        }
        if (this.texture == null) {
            throw new IllegalStateException("No texture");
        }
        double d3 = this.texture.interpolateU(d);
        double d4 = this.texture.interpolateV(d2);
        this.rawAddVertex(vector3, d3, d4);
        if (++this.vertexCount == 3 && this.expandTrianglesToQuads && this.verticesPerFace == 3) {
            this.rawAddVertex(vector3, d3, d4);
        }
    }

    @Override
    public void endFace() {
        if (this.vertexCount < this.verticesPerFace) {
            throw new IllegalStateException("Too few vertices in face");
        }
        this.vertexCount = 0;
        this.verticesPerFace = 0;
    }

    public void finish() {
        if (this.vertexCount > 0) {
            throw new IllegalStateException("Rendering ended with incomplete face");
        }
    }

    protected abstract void rawAddVertex(Vector3 var1, double var2, double var4);

    public float r() {
        return (float)((double)this.red * this.texture.red());
    }

    public float g() {
        return (float)((double)this.green * this.texture.green());
    }

    public float b() {
        return (float)((double)this.blue * this.texture.blue());
    }

    public float a() {
        return this.alpha;
    }

    @Override
    public void addProjectedVertex(Vector3 vector3, EnumFacing enumFacing) {
        double d;
        double d2;
        double d3 = vector3.x - this.blockX;
        double d4 = vector3.y - this.blockY;
        double d5 = vector3.z - this.blockZ;
        switch (enumFacing) {
            case DOWN: {
                d2 = d3;
                d = 1.0 - d5;
                break;
            }
            case UP: {
                d2 = d3;
                d = d5;
                break;
            }
            case NORTH: {
                d2 = 1.0 - d3;
                d = 1.0 - d4;
                break;
            }
            case SOUTH: {
                d2 = d3;
                d = 1.0 - d4;
                break;
            }
            case EAST: {
                d2 = 1.0 - d5;
                d = 1.0 - d4;
                break;
            }
            case WEST: {
                d2 = d5;
                d = 1.0 - d4;
                break;
            }
            default: {
                d2 = 0.0;
                d = 0.0;
            }
        }
        this.addUVVertex(vector3, d2, d);
    }
}

