/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseMod;
import gcewing.architecture.BaseTileEntity;
import gcewing.architecture.Shape;
import gcewing.architecture.ShapePage;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SawbenchTE
extends BaseTileEntity
implements IInventory,
ISidedInventory {
    public static final int materialSlot = 0;
    public static final int resultSlot = 1;
    public static final int[] materialSideSlots = new int[]{0};
    public static final int[] resultSideSlots = new int[]{1};
    public static ShapePage[] pages = new ShapePage[]{new ShapePage("Roofing", Shape.RoofTile, Shape.RoofOuterCorner, Shape.RoofInnerCorner, Shape.RoofRidge, Shape.RoofSmartRidge, Shape.RoofValley, Shape.RoofSmartValley, Shape.RoofOverhang, Shape.RoofOverhangOuterCorner, Shape.RoofOverhangInnerCorner, Shape.RoofOverhangGableLH, Shape.RoofOverhangGableRH, Shape.RoofOverhangGableEndLH, Shape.RoofOverhangGableEndRH, Shape.RoofOverhangRidge, Shape.RoofOverhangValley, Shape.BevelledOuterCorner, Shape.BevelledInnerCorner), new ShapePage("Rounded", Shape.Cylinder, Shape.CylinderHalf, Shape.CylinderQuarter, Shape.CylinderLargeQuarter, Shape.AnticylinderLargeQuarter, Shape.Pillar, Shape.Post, Shape.Pole, Shape.SphereFull, Shape.SphereHalf, Shape.SphereQuarter, Shape.SphereEighth, Shape.SphereEighthLarge, Shape.SphereEighthLargeRev), new ShapePage("Classical", Shape.PillarBase, Shape.Pillar, Shape.DoricCapital, Shape.DoricTriglyph, Shape.DoricTriglyphCorner, Shape.DoricMetope, Shape.IonicCapital, Shape.CorinthianCapital, Shape.Architrave, Shape.ArchitraveCorner, Shape.CorniceLH, Shape.CorniceRH, Shape.CorniceEndLH, Shape.CorniceEndRH, Shape.CorniceRidge, Shape.CorniceValley, Shape.CorniceBottom), new ShapePage("Window", Shape.WindowFrame, Shape.WindowCorner, Shape.WindowMullion), new ShapePage("Arches", Shape.ArchD1, Shape.ArchD2, Shape.ArchD3A, Shape.ArchD3B, Shape.ArchD3C, Shape.ArchD4A, Shape.ArchD4B, Shape.ArchD4C), new ShapePage("Railings", Shape.BalustradePlain, Shape.BalustradePlainOuterCorner, Shape.BalustradePlainInnerCorner, Shape.BalustradePlainWithNewel, Shape.BalustradePlainEnd, Shape.BanisterPlainTop, Shape.BanisterPlain, Shape.BanisterPlainBottom, Shape.BanisterPlainEnd, Shape.BanisterPlainInnerCorner, Shape.BalustradeFancy, Shape.BalustradeFancyCorner, Shape.BalustradeFancyWithNewel, Shape.BalustradeFancyNewel, Shape.BanisterFancyTop, Shape.BanisterFancy, Shape.BanisterFancyBottom, Shape.BanisterFancyEnd, Shape.BanisterFancyNewelTall), new ShapePage("Other", Shape.CladdingSheet)};
    public IInventory inventory = new InventoryBasic("Items", false, 2);
    public int selectedPage = 0;
    public int[] selectedSlots = new int[pages.length];
    public boolean pendingMaterialUsage = false;

    public Shape getSelectedShape() {
        int n;
        if (this.selectedPage >= 0 && this.selectedPage < pages.length && (n = this.selectedSlots[this.selectedPage]) >= 0 && n < pages[this.selectedPage].size()) {
            return pages[this.selectedPage].get(n);
        }
        return null;
    }

    @Override
    protected IInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        this.beforeChangeSlot(n);
        super.func_70299_a(n, itemStack);
        this.updateResultSlot();
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        this.beforeChangeSlot(n);
        ItemStack itemStack = super.func_70298_a(n, n2);
        this.updateResultSlot();
        return itemStack;
    }

    void beforeChangeSlot(int n) {
        if (n == 1 && this.pendingMaterialUsage) {
            this.pendingMaterialUsage = false;
            ItemStack itemStack = this.func_70301_a(1);
            if (itemStack != null) {
                this.inventory.func_70298_a(0, this.materialMultiple());
            }
        }
    }

    public int[] getAccessibleSlotsFromSide(int n) {
        if (n == 1) {
            return materialSideSlots;
        }
        return resultSideSlots;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.selectedPage = nBTTagCompound.func_74762_e("Page");
        int[] nArray = nBTTagCompound.func_74759_k("Slots");
        if (nArray != null) {
            for (int i = 0; i < pages.length; ++i) {
                int n = i < nArray.length ? nArray[i] : 0;
                this.selectedSlots[i] = n >= 0 && n < pages[i].size() ? n : 0;
            }
        }
        this.pendingMaterialUsage = nBTTagCompound.func_74767_n("PMU");
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("Page", this.selectedPage);
        nBTTagCompound.func_74783_a("Slots", this.selectedSlots);
        nBTTagCompound.func_74757_a("PMU", this.pendingMaterialUsage);
    }

    public void setSelectedShape(int n, int n2) {
        if (n >= 0 && n < pages.length) {
            this.selectedPage = n;
            if (n2 >= 0 && n2 < pages[this.selectedPage].size()) {
                this.selectedSlots[this.selectedPage] = n2;
                this.func_70296_d();
                this.updateResultSlot();
                BaseMod.sendTileEntityUpdate(this);
            }
        }
    }

    void updateResultSlot() {
        ItemStack itemStack = this.func_70301_a(1);
        if (itemStack == null || this.pendingMaterialUsage) {
            Block block;
            Item item;
            ItemStack itemStack2 = this.func_70301_a(0);
            ItemStack itemStack3 = null;
            Shape shape = this.getSelectedShape();
            if (shape != null && itemStack2 != null && itemStack2.field_77994_a >= shape.materialUsed && (item = itemStack2.func_77973_b()) instanceof ItemBlock && (block = Block.func_149634_a((Item)item)).func_149662_c()) {
                itemStack3 = shape.kind.newStack(shape, block, itemStack2.func_77952_i(), shape.itemsProduced);
            }
            if (!ItemStack.func_77989_b(itemStack3, (ItemStack)itemStack)) {
                this.inventory.func_70299_a(1, itemStack3);
            }
            this.pendingMaterialUsage = itemStack3 != null;
        }
    }

    int materialMultiple() {
        Shape shape = this.getSelectedShape();
        if (shape != null) {
            return shape.materialUsed;
        }
        return 0;
    }

    int resultMultiple() {
        Shape shape = this.getSelectedShape();
        if (shape != null) {
            return shape.itemsProduced;
        }
        return 0;
    }
}

