/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import universalcoins.UniversalCoins;
import universalcoins.blocks.BlockRotatable;
import universalcoins.tile.TileSignal;

public class BlockSignal
extends BlockRotatable {
    public BlockSignal() {
        this.func_149711_c(3.0f);
        this.func_149647_a(UniversalCoins.tabUniversalCoins);
        this.func_149752_b(30.0f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        block10: {
            block9: {
                if (!player.func_70093_af()) break block9;
                TileEntity te = world.func_175625_s(pos);
                if (te == null || !(te instanceof TileSignal)) break block10;
                TileSignal tentity = (TileSignal)te;
                if (!player.func_174793_f().func_70005_c_().matches(tentity.blockOwner)) break block10;
                player.openGui((Object)UniversalCoins.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                break block10;
            }
            ItemStack[] inventory = player.field_71071_by.field_70462_a;
            TileSignal tentity = (TileSignal)world.func_175625_s(pos);
            int coinsFound = 0;
            block0: for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                int j = 0;
                while (true) {
                    if (j >= TileSignal.coins.length) continue block0;
                    if (stack != null) {
                        if (stack.func_77973_b() == TileSignal.coins[j]) {
                            coinsFound += stack.field_77994_a * TileSignal.multiplier[j];
                            player.field_71071_by.func_70299_a(i, null);
                        }
                    }
                    ++j;
                }
            }
            if (world.field_72995_K) {
                return false;
            }
            if (coinsFound < tentity.fee) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"signal.message.notenough")));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"signal.message.activated")));
                coinsFound -= tentity.fee;
                tentity.activateSignal();
            }
            if (coinsFound > 0) {
                Random rand = new Random();
                while (coinsFound > 0) {
                    float rx = rand.nextFloat() * 0.8f + 0.1f;
                    float ry = rand.nextFloat() * 0.8f + 0.1f;
                    float rz = rand.nextFloat() * 0.8f + 0.1f;
                    int logVal = Math.min((int)(Math.log(coinsFound) / Math.log(9.0)), 4);
                    int stackSize = Math.min((int)((double)coinsFound / Math.pow(9.0, logVal)), 64);
                    EntityItem entityItem = new EntityItem(world, (double)((float)player.func_180425_c().func_177958_n() + rx), (double)((float)player.func_180425_c().func_177956_o() + ry), (double)((float)player.func_180425_c().func_177952_p() + rz), new ItemStack(TileSignal.coins[logVal], stackSize));
                    world.func_72838_d((Entity)entityItem);
                    coinsFound = (int)((double)coinsFound - Math.pow(9.0, logVal) * (double)stackSize);
                }
            }
        }
        return true;
    }

    @Override
    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        world.func_175698_g(pos);
        this.func_180652_a(world, pos, explosion);
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((Block)this, 1));
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)entityItem);
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)player.func_174811_aO().func_176734_d()), 2);
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null) {
            ((TileSignal)world.func_175625_s((BlockPos)pos)).blockOwner = player.func_174793_f().func_70005_c_();
        }
    }

    public void updatePower(World worldIn, BlockPos pos) {
        if (!worldIn.field_72995_K) {
            worldIn.func_175685_c(pos, (Block)this);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this);
            }
        }
    }

    public int func_180656_a(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null && te instanceof TileSignal) {
            TileSignal tentity = (TileSignal)te;
            return tentity.canProvidePower ? 15 : 0;
        }
        return 0;
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TileSignal();
    }

    public boolean func_149744_f() {
        return true;
    }
}

