/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.blocks;

import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import universalcoins.UniversalCoins;
import universalcoins.proxy.CommonProxy;
import universalcoins.tile.TileTradeStation;

public class BlockTradeStation
extends BlockContainer {
    public BlockTradeStation() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149647_a(UniversalCoins.tabUniversalCoins);
        this.func_149752_b(6000.0f);
    }

    public int func_149645_b() {
        return 3;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileTradeStation) {
            if (((TileTradeStation)tileEntity).inUse) {
                if (!world.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.warning.inuse")));
                }
                return true;
            }
            player.openGui((Object)UniversalCoins.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            ((TileTradeStation)tileEntity).playerName = player.func_70005_c_();
            ((TileTradeStation)tileEntity).inUse = true;
            return true;
        }
        return false;
    }

    public ItemStack getItemStackWithData(World world, int x, int y, int z) {
        ItemStack stack = new ItemStack(CommonProxy.blockTradeStation, 1);
        TileEntity tentity = world.func_175625_s(new BlockPos(x, y, z));
        if (tentity instanceof TileTradeStation) {
            TileTradeStation te = (TileTradeStation)tentity;
            NBTTagList itemList = new NBTTagList();
            NBTTagCompound tagCompound = new NBTTagCompound();
            for (int i = 0; i < te.func_70302_i_(); ++i) {
                ItemStack invStack = te.func_70301_a(i);
                if (invStack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                invStack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
            tagCompound.func_74768_a("CoinsLeft", te.coinSum);
            tagCompound.func_74768_a("AutoMode", te.autoMode);
            tagCompound.func_74768_a("CoinMode", te.coinMode);
            tagCompound.func_74768_a("ItemPrice", te.itemPrice);
            tagCompound.func_74778_a("CustomName", te.func_70005_c_());
            stack.func_77982_d(tagCompound);
            return stack;
        }
        return stack;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (stack.func_77942_o()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileTradeStation) {
                TileTradeStation tentity = (TileTradeStation)te;
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound == null) {
                    return;
                }
                NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tag = tagList.func_150305_b(i);
                    byte slot = tag.func_74771_c("Slot");
                    if (slot < 0 || slot >= tentity.func_70302_i_()) continue;
                    tentity.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)tag));
                }
                tentity.coinSum = tagCompound.func_74762_e("CoinsLeft");
                tentity.autoMode = tagCompound.func_74762_e("AutoMode");
                tentity.coinMode = tagCompound.func_74762_e("CoinMode");
                tentity.itemPrice = tagCompound.func_74762_e("ItemPrice");
                tentity.customName = tagCompound.func_74779_i("CustomName");
            }
            world.func_175689_h(pos);
        } else if (stack.func_82837_s()) {
            ((TileTradeStation)world.func_175625_s(pos)).setName(stack.func_82833_r());
        }
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack stack = this.getItemStackWithData(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                world.func_72838_d((Entity)entityItem);
            }
            super.removedByPlayer(world, pos, player, willHarvest);
        }
        return false;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileTradeStation();
    }
}

