/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.blocks;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import universalcoins.UniversalCoins;
import universalcoins.blocks.BlockRotatable;
import universalcoins.proxy.CommonProxy;
import universalcoins.tile.TileVendor;
import universalcoins.tile.TileVendorFrame;

public class BlockVendorFrame
extends BlockRotatable {
    public BlockVendorFrame() {
        this.func_149711_c(1.0f);
        this.func_149752_b(6000.0f);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.func_149647_a(UniversalCoins.tabUniversalCoins);
    }

    public ItemStack getItemStackWithData(World world, int x, int y, int z) {
        ItemStack stack = new ItemStack(CommonProxy.blockVendorFrame, 1, 0);
        TileEntity tentity = world.func_175625_s(new BlockPos(x, y, z));
        if (tentity instanceof TileVendorFrame) {
            TileVendorFrame te = (TileVendorFrame)tentity;
            NBTTagList itemList = new NBTTagList();
            NBTTagCompound tagCompound = new NBTTagCompound();
            for (int i = 0; i < te.func_70302_i_(); ++i) {
                ItemStack invStack = te.func_70301_a(i);
                if (invStack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                invStack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
            tagCompound.func_74768_a("CoinSum", te.coinSum);
            tagCompound.func_74768_a("UserCoinSum", te.userCoinSum);
            tagCompound.func_74768_a("ItemPrice", te.itemPrice);
            tagCompound.func_74778_a("BlockOwner", te.blockOwner);
            tagCompound.func_74757_a("Infinite", te.infiniteMode);
            stack.func_77982_d(tagCompound);
            return stack;
        }
        return stack;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @Override
    public int func_149645_b() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        this.func_180654_a((IBlockAccess)worldIn, pos);
        return super.func_180646_a(worldIn, pos);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        return null;
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing == EnumFacing.NORTH) {
            this.func_149676_a(0.12f, 0.12f, 0.0f, 0.88f, 0.88f, 0.07f);
        }
        if (facing == EnumFacing.EAST) {
            this.func_149676_a(0.93f, 0.12f, 0.12f, 1.0f, 0.88f, 0.88f);
        }
        if (facing == EnumFacing.SOUTH) {
            this.func_149676_a(0.12f, 0.12f, 0.93f, 0.88f, 0.88f, 1.0f);
        }
        if (facing == EnumFacing.WEST) {
            this.func_149676_a(0.07f, 0.12f, 0.12f, 0.0f, 0.88f, 0.88f);
        }
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        String ownerName = ((TileVendorFrame)world.func_175625_s((BlockPos)pos)).blockOwner;
        if (player.func_145748_c_().equals(ownerName)) {
            this.func_149711_c(1.0f);
        } else {
            this.func_149711_c(-1.0f);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileVendor) {
            TileVendor tentity = (TileVendor)tileEntity;
            if (tentity.inUse) {
                if (!world.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.warning.inuse")));
                }
                return true;
            }
            tentity.updateEntity();
            player.openGui((Object)UniversalCoins.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            tentity.playerName = player.func_70005_c_();
            tentity.inUse = true;
            return true;
        }
        return false;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)player.func_174811_aO()), 2);
        if (stack.func_77942_o()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileVendorFrame) {
                NBTTagList tagList;
                TileVendorFrame tentity = (TileVendorFrame)te;
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound.func_74779_i("BlockIcon") == "") {
                    NBTTagList textureList = tagCompound.func_150295_c("Inventory", 10);
                    byte slot = tagCompound.func_74771_c("Texture");
                    ItemStack textureStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
                }
                if ((tagList = tagCompound.func_150295_c("Inventory", 10)).func_74745_c() > 0) {
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound tag = tagList.func_150305_b(i);
                        byte slot = tag.func_74771_c("Slot");
                        if (slot >= tentity.func_70302_i_()) continue;
                        tentity.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)tag));
                    }
                }
                tentity.coinSum = tagCompound.func_74762_e("CoinSum");
                tentity.userCoinSum = tagCompound.func_74762_e("UserCoinSum");
                tentity.itemPrice = tagCompound.func_74762_e("ItemPrice");
                tentity.infiniteMode = tagCompound.func_74767_n("Infinite");
                tentity.blockOwner = player.func_70005_c_();
            }
            world.func_175689_h(pos);
        } else {
            ((TileVendorFrame)world.func_175625_s((BlockPos)pos)).blockOwner = player.func_70005_c_();
        }
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        String ownerName = ((TileVendorFrame)world.func_175625_s((BlockPos)pos)).blockOwner;
        if (player.field_71075_bZ.field_75098_d) {
            super.removedByPlayer(world, pos, player, willHarvest);
            return false;
        }
        if (player.func_145748_c_().equals(ownerName) && !world.field_72995_K) {
            ItemStack stack = this.getItemStackWithData(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            world.func_72838_d((Entity)entityItem);
            super.removedByPlayer(world, pos, player, willHarvest);
        }
        return false;
    }

    @Override
    public TileEntity func_149915_a(World var1, int var2) {
        return new TileVendorFrame();
    }
}

