/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.commands;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import universalcoins.proxy.CommonProxy;
import universalcoins.util.UCItemPricer;

public class UCCommand
extends CommandBase {
    private boolean firstChange = true;
    private static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};
    private static final Item[] coins;

    public String func_71517_b() {
        return StatCollector.func_74838_a((String)"command.uccommand.name");
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return StatCollector.func_74838_a((String)"command.uccommand.help");
    }

    public List func_71514_a() {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add("uc");
        return aliases;
    }

    public void func_71515_b(ICommandSender sender, String[] astring) throws WrongUsageException {
        if (astring.length <= 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (astring[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.help.name"))) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.usage")));
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.commandheader")));
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.get.help")));
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.set.help")));
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.reload.help")));
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.reset.help")));
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.save.help")));
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.update.help")));
            sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.usage.hint")));
        } else if (astring[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.reload.name"))) {
            UCItemPricer.getInstance().loadConfigs();
        } else if (astring[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.get.name"))) {
            if (astring.length > 1) {
                int price = -1;
                String stackName = "";
                if (astring[1].matches(StatCollector.func_74838_a((String)"command.uccommand.option.set.itemheld"))) {
                    ItemStack stack = this.getPlayerItem(sender);
                    if (stack != null) {
                        price = UCItemPricer.getInstance().getItemPrice(stack);
                        stackName = this.getPlayerItem(sender).func_77977_a();
                    }
                } else {
                    price = UCItemPricer.getInstance().getItemPrice(astring[1]);
                    stackName = astring[1];
                }
                if (price == -1) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.uccommand.warning.pricenotset") + " " + stackName));
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7a" + StatCollector.func_74838_a((String)"command.uccommand.warning.pricefound") + " " + stackName + ": " + price));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.uccommand.warning.noitem")));
            }
        } else if (astring[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.set.name"))) {
            if (astring.length > 2) {
                boolean result = false;
                int price = -1;
                try {
                    price = Integer.parseInt(astring[2]);
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.uccommand.option.set.price.invalid")));
                    return;
                }
                if (astring[1].matches(StatCollector.func_74838_a((String)"command.uccommand.option.set.itemheld"))) {
                    ItemStack stack = this.getPlayerItem(sender);
                    if (stack != null) {
                        result = UCItemPricer.getInstance().setItemPrice(stack, price);
                    }
                } else {
                    result = UCItemPricer.getInstance().setItemPrice(astring[1], price);
                }
                if (result) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.set.price") + " " + price));
                    if (this.firstChange) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.set.price.firstuse.one")));
                        sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.set.price.firstuse.two")));
                        sender.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"command.uccommand.option.set.price.firstuse.three")));
                        this.firstChange = false;
                    }
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.uccommand.option.set.price.fail.one")));
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.uccommand.option.set.price.error")));
            }
        } else if (astring[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.reload"))) {
            UCItemPricer.getInstance().loadConfigs();
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7a" + StatCollector.func_74838_a((String)"command.uccommand.option.reload.confirm")));
        } else if (astring[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.reset.name"))) {
            UCItemPricer.getInstance().resetDefaults();
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7a" + StatCollector.func_74838_a((String)"command.uccommand.option.reset.confirm")));
        } else if (astring[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.save.name"))) {
            UCItemPricer.getInstance().savePriceLists();
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7a" + StatCollector.func_74838_a((String)"command.uccommand.option.save.confirm")));
        } else if (astring[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.update.name"))) {
            UCItemPricer.getInstance().updatePriceLists();
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7a" + StatCollector.func_74838_a((String)"command.uccommand.option.update.confirm")));
        }
    }

    private ItemStack getPlayerItem(ICommandSender sender) {
        EntityPlayer player = (EntityPlayer)sender;
        if (player.func_70694_bm() != null) {
            ItemStack stack = player.func_70694_bm();
            return stack;
        }
        return null;
    }

    private int getCoinMultiplier(Item item) {
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return multiplier[i];
        }
        return -1;
    }

    private int givePlayerCoins(EntityPlayer recipient, int coinsLeft) {
        while (coinsLeft > 0) {
            int stackSize;
            int logVal = Math.min((int)(Math.log(coinsLeft) / Math.log(9.0)), 4);
            Boolean coinsAdded = recipient.field_71071_by.func_70441_a(new ItemStack(coins[logVal], stackSize = Math.min((int)((double)coinsLeft / Math.pow(9.0, logVal)), 64)));
            if (coinsAdded.booleanValue()) {
                coinsLeft = (int)((double)coinsLeft - (double)stackSize * Math.pow(9.0, logVal));
                continue;
            }
            return coinsLeft;
        }
        return 0;
    }

    private int getPlayerCoins(EntityPlayer player) {
        int coinsFound = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            for (int j = 0; j < coins.length; ++j) {
                if (stack == null || stack.func_77973_b() != coins[j]) continue;
                coinsFound += stack.field_77994_a * multiplier[j];
            }
        }
        return coinsFound;
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            options.add(StatCollector.func_74838_a((String)"command.uccommand.option.help.name"));
            options.add(StatCollector.func_74838_a((String)"command.uccommand.option.get.name"));
            options.add(StatCollector.func_74838_a((String)"command.uccommand.option.set.name"));
            options.add(StatCollector.func_74838_a((String)"command.uccommand.option.reload.name"));
            options.add(StatCollector.func_74838_a((String)"command.uccommand.option.reset.name"));
            options.add(StatCollector.func_74838_a((String)"command.uccommand.option.save.name"));
            options.add(StatCollector.func_74838_a((String)"command.uccommand.option.update.name"));
            return UCCommand.func_175762_a((String[])args, options);
        }
        if (args.length == 2 && (args[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.get.name")) || args[0].matches(StatCollector.func_74838_a((String)"command.uccommand.option.set.name")))) {
            ArrayList<String> options = new ArrayList<String>();
            options.add(StatCollector.func_74838_a((String)"command.uccommand.option.set.itemheld"));
            UCItemPricer.getInstance();
            for (String item : UCItemPricer.getUcPriceMap().keySet()) {
                options.add(item);
            }
            return UCCommand.func_175762_a((String[])args, options);
        }
        return null;
    }

    static {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        coins = itemArray;
    }
}

