/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.commands;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;
import universalcoins.proxy.CommonProxy;

public class UCGive
extends CommandBase {
    private static final Item[] coins;

    public String func_71517_b() {
        return StatCollector.func_74838_a((String)"command.givecoins.name");
    }

    public String func_71518_a(ICommandSender var1) {
        return StatCollector.func_74838_a((String)"command.givecoins.help");
    }

    public void func_71515_b(ICommandSender sender, String[] astring) {
        if (astring.length == 2) {
            WorldServer[] ws;
            EntityPlayer recipient = null;
            for (WorldServer w : ws = MinecraftServer.func_71276_C().field_71305_c) {
                if (!w.field_73010_i.contains(w.func_72924_a(astring[0]))) continue;
                recipient = w.func_72924_a(astring[0]);
            }
            int coinsToSend = 0;
            if (recipient == null) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.givecoins.error.notfound")));
            }
            try {
                coinsToSend = Integer.parseInt(astring[1]);
            }
            catch (NumberFormatException e) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.givecoins.error.badentry")));
            }
            if (coinsToSend <= 0) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c" + StatCollector.func_74838_a((String)"command.send.error.badentry")));
                return;
            }
            int change = this.givePlayerCoins(recipient, coinsToSend);
            sender.func_145747_a((IChatComponent)new ChatComponentText("Gave " + astring[0] + " " + (coinsToSend - change) + " " + StatCollector.func_74838_a((String)"item.itemCoin.name")));
            recipient.func_145747_a((IChatComponent)new ChatComponentText(sender.func_70005_c_() + " " + StatCollector.func_74838_a((String)"command.givecoins.result") + " " + (coinsToSend - change) + " " + StatCollector.func_74838_a((String)"item.itemCoin.name")));
        } else {
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.givecoins.error.noname")));
        }
    }

    private int givePlayerCoins(EntityPlayer recipient, int coinsLeft) {
        while (coinsLeft > 0) {
            int logVal = Math.min((int)(Math.log(coinsLeft) / Math.log(9.0)), 4);
            int stackSize = Math.min((int)((double)coinsLeft / Math.pow(9.0, logVal)), 64);
            if (recipient.field_71071_by.func_70447_i() != -1) {
                recipient.field_71071_by.func_70441_a(new ItemStack(coins[logVal], stackSize));
                coinsLeft = (int)((double)coinsLeft - (double)stackSize * Math.pow(9.0, logVal));
                continue;
            }
            for (int i = 0; i < recipient.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = recipient.field_71071_by.func_70301_a(i);
                for (int j = 0; j < coins.length; ++j) {
                    if (stack == null || stack.func_77973_b() != coins[j]) continue;
                    int amountToAdd = (int)Math.min((double)coinsLeft / Math.pow(9.0, j), (double)(stack.func_77976_d() - stack.field_77994_a));
                    stack.field_77994_a += amountToAdd;
                    recipient.field_71071_by.func_70299_a(i, stack);
                    coinsLeft = (int)((double)coinsLeft - (double)amountToAdd * Math.pow(9.0, j));
                }
            }
            return coinsLeft;
        }
        return 0;
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> players = new ArrayList<String>();
            for (EntityPlayer p : sender.func_130014_f_().field_73010_i) {
                players.add(p.func_70005_c_());
            }
            return UCGive.func_175762_a((String[])args, players);
        }
        return null;
    }

    static {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        coins = itemArray;
    }
}

