/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.commands;

import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import universalcoins.proxy.CommonProxy;

public class UCRebalance
extends CommandBase {
    private static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};
    private static final Item[] coins;

    public String func_71517_b() {
        return StatCollector.func_74838_a((String)"command.rebalance.name");
    }

    public String func_71518_a(ICommandSender var1) {
        return StatCollector.func_74838_a((String)"command.rebalance.help");
    }

    public boolean func_71519_b(ICommandSender par1ICommandSender) {
        return true;
    }

    public void func_71515_b(ICommandSender sender, String[] astring) {
        if (sender instanceof EntityPlayerMP && astring.length == 0) {
            int coinTotal = 0;
            EntityPlayerMP player = (EntityPlayerMP)sender;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                for (int j = 0; j < coins.length; ++j) {
                    if (stack == null || stack.func_77973_b() != coins[j]) continue;
                    coinTotal += stack.field_77994_a * multiplier[j];
                    player.field_71071_by.func_70299_a(i, null);
                }
            }
            int leftOvers = this.givePlayerCoins((EntityPlayer)player, coinTotal);
            if (leftOvers > 0) {
                World world = ((EntityPlayerMP)sender).field_70170_p;
                Random rand = new Random();
                while (leftOvers > 0) {
                    float rx = rand.nextFloat() * 0.8f + 0.1f;
                    float ry = rand.nextFloat() * 0.8f + 0.1f;
                    float rz = rand.nextFloat() * 0.8f + 0.1f;
                    int logVal = Math.min((int)(Math.log(leftOvers) / Math.log(9.0)), 4);
                    int stackSize = Math.min((int)((double)leftOvers / Math.pow(9.0, logVal)), 64);
                    EntityItem entityItem = new EntityItem(world, ((EntityPlayerMP)sender).field_70165_t + (double)rx, ((EntityPlayerMP)sender).field_70163_u + (double)ry, ((EntityPlayerMP)sender).field_70161_v + (double)rz, new ItemStack(coins[logVal], stackSize));
                    leftOvers = (int)((double)leftOvers - Math.pow(9.0, logVal) * (double)stackSize);
                }
            }
        }
    }

    private int getCoinMultiplier(Item item) {
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return multiplier[i];
        }
        return -1;
    }

    private int givePlayerCoins(EntityPlayer recipient, int coinsLeft) {
        while (coinsLeft > 0) {
            int logVal = Math.min((int)(Math.log(coinsLeft) / Math.log(9.0)), 4);
            int stackSize = Math.min((int)((double)coinsLeft / Math.pow(9.0, logVal)), 64);
            if (recipient.field_71071_by.func_70447_i() != -1) {
                recipient.field_71071_by.func_70441_a(new ItemStack(coins[logVal], stackSize));
                coinsLeft = (int)((double)coinsLeft - (double)stackSize * Math.pow(9.0, logVal));
                continue;
            }
            for (int i = 0; i < recipient.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = recipient.field_71071_by.func_70301_a(i);
                for (int j = 0; j < coins.length; ++j) {
                    if (stack == null || stack.func_77973_b() != coins[j]) continue;
                    int amountToAdd = (int)Math.min((double)coinsLeft / Math.pow(9.0, j), (double)(stack.func_77976_d() - stack.field_77994_a));
                    stack.field_77994_a += amountToAdd;
                    recipient.field_71071_by.func_70299_a(i, stack);
                    coinsLeft = (int)((double)coinsLeft - (double)amountToAdd * Math.pow(9.0, j));
                }
            }
            return coinsLeft;
        }
        return 0;
    }

    private int getPlayerCoins(EntityPlayerMP player) {
        int coinsFound = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            for (int j = 0; j < coins.length; ++j) {
                if (stack == null || stack.func_77973_b() != coins[j]) continue;
                coinsFound += stack.field_77994_a * multiplier[j];
            }
        }
        return coinsFound;
    }

    static {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        coins = itemArray;
    }
}

