/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import universalcoins.proxy.CommonProxy;

public class UCSend
extends CommandBase {
    private static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};
    private static final Item[] coins;

    public String func_71517_b() {
        return StatCollector.func_74838_a((String)"command.send.name");
    }

    public List func_71514_a() {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add("pay");
        return aliases;
    }

    public String func_71518_a(ICommandSender var1) {
        return StatCollector.func_74838_a((String)"command.send.help");
    }

    public boolean func_71519_b(ICommandSender par1ICommandSender) {
        return true;
    }

    public void func_71515_b(ICommandSender sender, String[] astring) {
        if (sender instanceof EntityPlayerMP) {
            if (astring.length == 2) {
                WorldServer[] ws;
                EntityPlayerMP recipient = null;
                for (WorldServer w : ws = MinecraftServer.func_71276_C().field_71305_c) {
                    if (!w.field_73010_i.contains(w.func_72924_a(astring[0]))) continue;
                    recipient = (EntityPlayerMP)w.func_72924_a(astring[0]);
                }
                if (recipient == null) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.send.error.notfound")));
                }
                int requestedSendAmount = 0;
                try {
                    requestedSendAmount = Integer.parseInt(astring[1]);
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.send.error.badentry")));
                }
                if (requestedSendAmount <= 0) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c" + StatCollector.func_74838_a((String)"command.send.error.badentry")));
                    return;
                }
                int coinsFromSender = 0;
                EntityPlayerMP player = (EntityPlayerMP)sender;
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    for (int j = 0; j < coins.length; ++j) {
                        if (stack == null || stack.func_77973_b() != coins[j] || coinsFromSender >= requestedSendAmount) continue;
                        coinsFromSender += stack.field_77994_a * multiplier[j];
                        player.field_71071_by.func_70299_a(i, null);
                    }
                }
                if (coinsFromSender < requestedSendAmount) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.send.error.insufficient")));
                    this.givePlayerCoins((EntityPlayer)((EntityPlayerMP)sender), coinsFromSender);
                    return;
                }
                coinsFromSender -= requestedSendAmount;
                int coinChange = this.givePlayerCoins((EntityPlayer)recipient, requestedSendAmount);
                sender.func_145747_a((IChatComponent)new ChatComponentText(requestedSendAmount - coinChange + " " + StatCollector.func_74838_a((String)"command.send.result.sender") + " " + astring[0]));
                recipient.func_145747_a((IChatComponent)new ChatComponentText(requestedSendAmount - coinChange + " " + StatCollector.func_74838_a((String)"command.send.result.receiver") + " " + sender.func_70005_c_()));
                int leftOvers = this.givePlayerCoins((EntityPlayer)player, coinsFromSender += coinChange);
                if (leftOvers > 0) {
                    World world = ((EntityPlayerMP)sender).field_70170_p;
                    Random rand = new Random();
                    while (leftOvers > 0) {
                        float rx = rand.nextFloat() * 0.8f + 0.1f;
                        float ry = rand.nextFloat() * 0.8f + 0.1f;
                        float rz = rand.nextFloat() * 0.8f + 0.1f;
                        int logVal = Math.min((int)(Math.log(leftOvers) / Math.log(9.0)), 4);
                        int stackSize = Math.min((int)((double)leftOvers / Math.pow(9.0, logVal)), 64);
                        EntityItem entityItem = new EntityItem(world, ((EntityPlayerMP)sender).field_70165_t + (double)rx, ((EntityPlayerMP)sender).field_70163_u + (double)ry, ((EntityPlayerMP)sender).field_70161_v + (double)rz, new ItemStack(coins[logVal], stackSize));
                        world.func_72838_d((Entity)entityItem);
                        leftOvers = (int)((double)leftOvers - Math.pow(9.0, logVal) * (double)stackSize);
                    }
                }
            } else {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00c2\u00a7c" + StatCollector.func_74838_a((String)"command.send.error.incomplete")));
            }
        }
    }

    private int getCoinMultiplier(Item item) {
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return multiplier[i];
        }
        return -1;
    }

    private int givePlayerCoins(EntityPlayer recipient, int coinsLeft) {
        while (coinsLeft > 0) {
            int logVal = Math.min((int)(Math.log(coinsLeft) / Math.log(9.0)), 4);
            int stackSize = Math.min((int)((double)coinsLeft / Math.pow(9.0, logVal)), 64);
            if (recipient.field_71071_by.func_70447_i() != -1) {
                recipient.field_71071_by.func_70441_a(new ItemStack(coins[logVal], stackSize));
                coinsLeft = (int)((double)coinsLeft - (double)stackSize * Math.pow(9.0, logVal));
                continue;
            }
            for (int i = 0; i < recipient.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = recipient.field_71071_by.func_70301_a(i);
                for (int j = 0; j < coins.length; ++j) {
                    if (stack == null || stack.func_77973_b() != coins[j]) continue;
                    int amountToAdd = (int)Math.min((double)coinsLeft / Math.pow(9.0, j), (double)(stack.func_77976_d() - stack.field_77994_a));
                    stack.field_77994_a += amountToAdd;
                    recipient.field_71071_by.func_70299_a(i, stack);
                    coinsLeft = (int)((double)coinsLeft - (double)amountToAdd * Math.pow(9.0, j));
                }
            }
            return coinsLeft;
        }
        return 0;
    }

    private int getPlayerCoins(EntityPlayerMP player) {
        int coinsFound = 0;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            for (int j = 0; j < coins.length; ++j) {
                if (stack == null || stack.func_77973_b() != coins[j]) continue;
                coinsFound += stack.field_77994_a * multiplier[j];
            }
        }
        return coinsFound;
    }

    public List func_180525_a(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            ArrayList<String> players = new ArrayList<String>();
            for (EntityPlayer p : sender.func_130014_f_().field_73010_i) {
                players.add(p.func_70005_c_());
            }
            return UCSend.func_175762_a((String[])args, players);
        }
        return null;
    }

    static {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        coins = itemArray;
    }
}

