/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.items;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import universalcoins.proxy.CommonProxy;
import universalcoins.util.UniversalAccounts;

public class ItemEnderCard
extends Item {
    private static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};

    public ItemEnderCard() {
        this.field_77777_bU = 1;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (stack.func_77942_o()) {
            list.add(stack.func_77978_p().func_74779_i("Name"));
            list.add(stack.func_77978_p().func_74779_i("Account"));
        } else {
            list.add(StatCollector.func_74838_a((String)"item.itemUCCard.warning"));
        }
    }

    public boolean func_180614_a(ItemStack itemstack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (itemstack.func_77978_p() == null) {
            this.createNBT(itemstack, world, player);
        }
        int accountBalance = UniversalAccounts.getInstance().getAccountBalance(itemstack.func_77978_p().func_74779_i("Account"));
        DecimalFormat formatter = new DecimalFormat("#,###,###,###");
        ItemStack[] inventory = player.field_71071_by.field_70462_a;
        String accountNumber = itemstack.func_77978_p().func_74779_i("Account");
        int coinsDeposited = 0;
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i] == null) continue;
            if (inventory[i].func_77973_b() != CommonProxy.itemCoin) {
                if (inventory[i].func_77973_b() != CommonProxy.itemSmallCoinStack) {
                    if (inventory[i].func_77973_b() != CommonProxy.itemLargeCoinStack) {
                        if (inventory[i].func_77973_b() != CommonProxy.itemSmallCoinBag) {
                            if (inventory[i].func_77973_b() != CommonProxy.itemLargeCoinBag) continue;
                        }
                    }
                }
            }
            if (accountBalance == -1) {
                return true;
            }
            int coinType = this.getCoinType(inventory[i].func_77973_b());
            if (coinType == -1) {
                return true;
            }
            int coinValue = multiplier[coinType];
            int depositAmount = Math.min(inventory[i].field_77994_a, (Integer.MAX_VALUE - accountBalance) / coinValue);
            UniversalAccounts.getInstance().creditAccount(accountNumber, depositAmount * coinValue);
            coinsDeposited += depositAmount * coinValue;
            inventory[i].field_77994_a -= depositAmount;
            if (inventory[i].field_77994_a != 0) continue;
            player.field_71071_by.func_70299_a(i, null);
            player.field_71069_bz.func_75142_b();
        }
        if (coinsDeposited > 0) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.itemEnderCard.message.deposit") + " " + formatter.format(coinsDeposited) + " " + StatCollector.func_74838_a((String)"item.itemCoin.name")));
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.itemEnderCard.balance") + " " + formatter.format(UniversalAccounts.getInstance().getAccountBalance(accountNumber))));
        return true;
    }

    private void createNBT(ItemStack stack, World world, EntityPlayer entityPlayer) {
        String accountNumber = UniversalAccounts.getInstance().getOrCreatePlayerAccount(entityPlayer.getPersistentID().toString());
        stack.func_77978_p().func_74778_a("Name", entityPlayer.func_70005_c_());
        stack.func_77978_p().func_74778_a("Owner", entityPlayer.getPersistentID().toString());
        stack.func_77978_p().func_74778_a("Account", accountNumber);
    }

    private int getCoinType(Item item) {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        Item[] coins = itemArray;
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return i;
        }
        return -1;
    }
}

