/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.net;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import universalcoins.tile.TileCardStation;
import universalcoins.tile.TilePackager;
import universalcoins.tile.TileSignal;
import universalcoins.tile.TileTradeStation;
import universalcoins.tile.TileVendor;

public class UCButtonMessage
implements IMessage,
IMessageHandler<UCButtonMessage, IMessage> {
    private int x;
    private int y;
    private int z;
    private int buttonId;
    private boolean shiftPressed;

    public UCButtonMessage() {
    }

    public UCButtonMessage(int x, int y, int z, int button, boolean shift) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.buttonId = button;
        this.shiftPressed = shift;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.buttonId);
        buf.writeBoolean(this.shiftPressed);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.buttonId = buf.readInt();
        this.shiftPressed = buf.readBoolean();
    }

    public IMessage onMessage(final UCButtonMessage message, final MessageContext ctx) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                UCButtonMessage.this.processMessage(message, ctx);
            }
        };
        if (ctx.side == Side.CLIENT) {
            Minecraft.func_71410_x().func_152344_a(task);
        } else if (ctx.side == Side.SERVER) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            if (playerEntity == null) {
                FMLLog.warning((String)"onMessage-server: Player is null", (Object[])new Object[0]);
                return null;
            }
            playerEntity.func_71121_q().func_152344_a(task);
        }
        return null;
    }

    private void processMessage(UCButtonMessage message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        TileEntity tileEntity = world.func_175625_s(new BlockPos(message.x, message.y, message.z));
        if (tileEntity instanceof TileTradeStation) {
            ((TileTradeStation)tileEntity).onButtonPressed(message.buttonId, message.shiftPressed);
        }
        if (tileEntity instanceof TileCardStation) {
            ((TileCardStation)tileEntity).onButtonPressed(message.buttonId);
        }
        if (tileEntity instanceof TileSignal) {
            ((TileSignal)tileEntity).onButtonPressed(message.buttonId, message.shiftPressed);
        }
        if (tileEntity instanceof TilePackager) {
            ((TilePackager)tileEntity).onButtonPressed(message.buttonId, message.shiftPressed);
        }
        if (tileEntity instanceof TileVendor) {
            ((TileVendor)tileEntity).onButtonPressed(message.buttonId, message.shiftPressed);
        }
    }
}

