/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.net;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import universalcoins.UniversalCoins;
import universalcoins.proxy.CommonProxy;

public class UCRecipeMessage
implements IMessage,
IMessageHandler<UCRecipeMessage, IMessage> {
    private boolean tradeStationRecipesEnabled = UniversalCoins.tradeStationRecipesEnabled;
    private boolean vendorRecipesEnabled = UniversalCoins.vendorRecipesEnabled;
    private boolean vendorFrameRecipesEnabled = UniversalCoins.vendorFrameRecipesEnabled;
    private boolean atmRecipeEnabled = UniversalCoins.atmRecipeEnabled;
    private boolean enderCardRecipeEnabled = UniversalCoins.enderCardRecipeEnabled;
    private boolean signalRecipeEnabled = UniversalCoins.signalRecipeEnabled;
    private boolean linkCardRecipeEnabled = UniversalCoins.linkCardRecipeEnabled;
    private boolean packagerRecipeEnabled = UniversalCoins.packagerRecipeEnabled;

    public void fromBytes(ByteBuf buf) {
        this.tradeStationRecipesEnabled = buf.readBoolean();
        this.vendorRecipesEnabled = buf.readBoolean();
        this.vendorFrameRecipesEnabled = buf.readBoolean();
        this.atmRecipeEnabled = buf.readBoolean();
        this.enderCardRecipeEnabled = buf.readBoolean();
        this.signalRecipeEnabled = buf.readBoolean();
        this.linkCardRecipeEnabled = buf.readBoolean();
        this.packagerRecipeEnabled = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.tradeStationRecipesEnabled);
        buf.writeBoolean(this.vendorRecipesEnabled);
        buf.writeBoolean(this.vendorFrameRecipesEnabled);
        buf.writeBoolean(this.atmRecipeEnabled);
        buf.writeBoolean(this.enderCardRecipeEnabled);
        buf.writeBoolean(this.signalRecipeEnabled);
        buf.writeBoolean(this.linkCardRecipeEnabled);
        buf.writeBoolean(this.packagerRecipeEnabled);
    }

    public IMessage onMessage(final UCRecipeMessage message, final MessageContext ctx) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                UCRecipeMessage.this.processMessage(message, ctx);
            }
        };
        if (ctx.side == Side.CLIENT) {
            Minecraft.func_71410_x().func_152344_a(task);
        } else if (ctx.side == Side.SERVER) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            if (playerEntity == null) {
                FMLLog.warning((String)"onMessage-server: Player is null", (Object[])new Object[0]);
                return null;
            }
            playerEntity.func_71121_q().func_152344_a(task);
        }
        return null;
    }

    private void processMessage(UCRecipeMessage message, MessageContext ctx) {
        if (!message.tradeStationRecipesEnabled) {
            this.removeRecipe(new ItemStack(CommonProxy.blockTradeStation));
            this.removeRecipe(new ItemStack(CommonProxy.itemSeller));
        }
        if (!message.vendorRecipesEnabled) {
            this.removeRecipe(new ItemStack(CommonProxy.blockVendor));
        }
        if (!message.vendorFrameRecipesEnabled) {
            this.removeRecipe(new ItemStack(CommonProxy.blockVendorFrame));
        }
        if (!message.atmRecipeEnabled) {
            this.removeRecipe(new ItemStack(CommonProxy.blockCardStation));
        }
        if (!message.enderCardRecipeEnabled) {
            this.removeRecipe(new ItemStack(CommonProxy.itemEnderCard));
        }
        if (!message.signalRecipeEnabled) {
            this.removeRecipe(new ItemStack(CommonProxy.blockSignal));
        }
        if (!message.linkCardRecipeEnabled) {
            this.removeRecipe(new ItemStack(CommonProxy.itemLinkCard));
        }
        if (!message.packagerRecipeEnabled) {
            this.removeRecipe(new ItemStack(CommonProxy.blockPackager));
        }
    }

    private void removeRecipe(ItemStack stack) {
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        Iterator recipeIterator = recipeList.iterator();
        while (recipeIterator.hasNext()) {
            ItemStack recipeStack = ((IRecipe)recipeIterator.next()).func_77571_b();
            if (recipeStack == null) continue;
            if (!ItemStack.func_77989_b((ItemStack)recipeStack, (ItemStack)stack)) continue;
            recipeIterator.remove();
        }
    }
}

