/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.net;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import universalcoins.tile.TileUCSign;

public class UCTileSignMessage
implements IMessage,
IMessageHandler<UCTileSignMessage, IMessage> {
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private IChatComponent signText0;
    private IChatComponent signText1;
    private IChatComponent signText2;
    private IChatComponent signText3;
    private String blockOwner;

    public UCTileSignMessage() {
    }

    public UCTileSignMessage(int x, int y, int z, IChatComponent[] signText, String blockOwner) {
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.signText0 = signText[0];
        this.signText1 = signText[1];
        this.signText2 = signText[2];
        this.signText3 = signText[3];
        this.blockOwner = blockOwner;
    }

    public void fromBytes(ByteBuf buf) {
        this.xCoord = buf.readInt();
        this.yCoord = buf.readShort();
        this.zCoord = buf.readInt();
        this.signText0 = new ChatComponentText(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.signText1 = new ChatComponentText(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.signText2 = new ChatComponentText(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.signText3 = new ChatComponentText(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.blockOwner = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.xCoord);
        buf.writeShort(this.yCoord);
        buf.writeInt(this.zCoord);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.signText0.func_150260_c());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.signText1.func_150260_c());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.signText2.func_150260_c());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.signText3.func_150260_c());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.blockOwner);
    }

    public IMessage onMessage(final UCTileSignMessage message, final MessageContext ctx) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                UCTileSignMessage.this.processMessage(message, ctx);
            }
        };
        if (ctx.side == Side.CLIENT) {
            Minecraft.func_71410_x().func_152344_a(task);
        } else if (ctx.side == Side.SERVER) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            if (playerEntity == null) {
                FMLLog.warning((String)"onMessage-server: Player is null", (Object[])new Object[0]);
                return null;
            }
            playerEntity.func_71121_q().func_152344_a(task);
        }
        return null;
    }

    private void processMessage(UCTileSignMessage message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_175625_s(new BlockPos(message.xCoord, message.yCoord, message.zCoord));
        if (tileEntity != null && tileEntity instanceof TileUCSign) {
            TileUCSign tentity = (TileUCSign)tileEntity;
            tentity.field_145915_a[0] = message.signText0;
            tentity.field_145915_a[1] = message.signText1;
            tentity.field_145915_a[2] = message.signText2;
            tentity.field_145915_a[3] = message.signText3;
            tentity.blockOwner = message.blockOwner;
        }
    }
}

