/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.net;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import universalcoins.tile.TileVendor;
import universalcoins.tile.TileVendorBlock;
import universalcoins.tile.TileVendorFrame;

public class UCVendorServerMessage
implements IMessage,
IMessageHandler<UCVendorServerMessage, IMessage> {
    private int x;
    private int y;
    private int z;
    private int itemPrice;
    private String blockOwner;
    private boolean infinite;

    public UCVendorServerMessage() {
    }

    public UCVendorServerMessage(int x, int y, int z, int price, String blockOwner, boolean infinite) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.itemPrice = price;
        this.blockOwner = blockOwner;
        this.infinite = infinite;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.itemPrice);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.blockOwner);
        buf.writeBoolean(this.infinite);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.itemPrice = buf.readInt();
        this.blockOwner = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.infinite = buf.readBoolean();
    }

    public IMessage onMessage(final UCVendorServerMessage message, final MessageContext ctx) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                UCVendorServerMessage.this.processMessage(message, ctx);
            }
        };
        if (ctx.side == Side.CLIENT) {
            Minecraft.func_71410_x().func_152344_a(task);
        } else if (ctx.side == Side.SERVER) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            if (playerEntity == null) {
                return null;
            }
            playerEntity.func_71121_q().func_152344_a(task);
        }
        return null;
    }

    private void processMessage(UCVendorServerMessage message, MessageContext ctx) {
        World world = ctx.getServerHandler().field_147369_b.field_70170_p;
        TileEntity tileEntity = world.func_175625_s(new BlockPos(message.x, message.y, message.z));
        if (tileEntity instanceof TileVendor) {
            TileVendor tEntity = (TileVendor)tileEntity;
            tEntity.itemPrice = message.itemPrice;
            tEntity.blockOwner = message.blockOwner;
            tEntity.infiniteMode = message.infinite;
        }
        if (tileEntity instanceof TileVendorFrame) {
            ((TileVendorFrame)tileEntity).updateSigns();
        }
        if (tileEntity instanceof TileVendorBlock) {
            ((TileVendorBlock)tileEntity).updateSigns();
        }
    }
}

