/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import universalcoins.UniversalCoins;
import universalcoins.net.UCButtonMessage;
import universalcoins.net.UCCardStationServerCustomNameMessage;
import universalcoins.net.UCCardStationServerWithdrawalMessage;
import universalcoins.proxy.CommonProxy;
import universalcoins.util.UniversalAccounts;

public class TileCardStation
extends TileEntity
implements IInventory,
ISidedInventory {
    private ItemStack[] inventory = new ItemStack[2];
    public static final int itemCoinSlot = 0;
    public static final int itemCardSlot = 1;
    private static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};
    private static final Item[] coins;
    public String blockOwner = "";
    public String playerName = "";
    public String playerUID = "";
    public boolean inUse = false;
    public boolean depositCoins = false;
    public boolean withdrawCoins = false;
    public boolean accountError = false;
    public int coinWithdrawalAmount = 0;
    public String cardOwner = "";
    public String accountNumber = "none";
    public int accountBalance = 0;
    public String customAccountName = "none";
    public String customAccountNumber = "none";

    public void inUseCleanup() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.inUse = false;
        this.withdrawCoins = false;
        this.depositCoins = false;
        this.accountNumber = "none";
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= size) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(size);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        this.fillCoinSlot();
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemstack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null) {
            int coinType;
            if (slot == 0 && this.depositCoins && !this.accountNumber.contentEquals("none") && (coinType = this.getCoinType(stack.func_77973_b())) != -1) {
                int itemValue = multiplier[coinType];
                int depositAmount = Math.min(stack.field_77994_a, (Integer.MAX_VALUE - this.accountBalance) / itemValue);
                if (!this.field_145850_b.field_72995_K) {
                    UniversalAccounts.getInstance().creditAccount(this.accountNumber, depositAmount * itemValue);
                    this.accountBalance = UniversalAccounts.getInstance().getAccountBalance(this.accountNumber);
                }
                this.inventory[slot].field_77994_a -= depositAmount;
                if (this.inventory[slot].field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
            if (slot == 1 && !this.field_145850_b.field_72995_K) {
                if (!this.inventory[1].func_77942_o()) {
                    return;
                }
                this.accountNumber = this.inventory[1].func_77978_p().func_74779_i("Account");
                this.cardOwner = this.inventory[1].func_77978_p().func_74779_i("Owner");
                if (UniversalAccounts.getInstance().getCustomAccount(this.playerUID) != "") {
                    this.customAccountName = UniversalAccounts.getInstance().getCustomAccount(this.playerUID);
                }
                this.accountBalance = UniversalAccounts.getInstance().getAccountBalance(this.accountNumber);
            }
        }
    }

    public String func_70005_c_() {
        return CommonProxy.blockCardStation.func_149732_F();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void sendButtonMessage(int functionID, boolean shiftPressed) {
        UniversalCoins.snw.sendToServer((IMessage)new UCButtonMessage(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), functionID, shiftPressed));
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void sendServerUpdatePacket(int withdrawalAmount) {
        UniversalCoins.snw.sendToServer((IMessage)new UCCardStationServerWithdrawalMessage(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), withdrawalAmount));
    }

    public void sendServerUpdatePacket(String customName) {
        UniversalCoins.snw.sendToServer((IMessage)new UCCardStationServerCustomNameMessage(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), customName));
    }

    public void updateTE() {
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        try {
            this.blockOwner = tagCompound.func_74779_i("BlockOwner");
        }
        catch (Throwable ex2) {
            this.blockOwner = null;
        }
        try {
            this.inUse = tagCompound.func_74767_n("InUse");
        }
        catch (Throwable ex2) {
            this.inUse = false;
        }
        try {
            this.depositCoins = tagCompound.func_74767_n("DepositCoins");
        }
        catch (Throwable ex2) {
            this.depositCoins = false;
        }
        try {
            this.withdrawCoins = tagCompound.func_74767_n("WithdrawCoins");
        }
        catch (Throwable ex2) {
            this.withdrawCoins = false;
        }
        try {
            this.coinWithdrawalAmount = tagCompound.func_74762_e("CoinWithdrawalAmount");
        }
        catch (Throwable ex2) {
            this.coinWithdrawalAmount = 0;
        }
        try {
            this.cardOwner = tagCompound.func_74779_i("CardOwner");
        }
        catch (Throwable ex2) {
            this.cardOwner = "";
        }
        try {
            this.accountBalance = tagCompound.func_74762_e("accountBalance");
        }
        catch (Throwable ex2) {
            this.accountBalance = 0;
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74778_a("BlockOwner", this.blockOwner);
        tagCompound.func_74757_a("InUse", this.inUse);
        tagCompound.func_74757_a("DepositCoins", this.depositCoins);
        tagCompound.func_74757_a("WithdrawCoins", this.withdrawCoins);
        tagCompound.func_74768_a("CoinWithdrawalAmount", this.coinWithdrawalAmount);
        tagCompound.func_74778_a("CardOwner", this.cardOwner);
        tagCompound.func_74768_a("accountBalance", this.accountBalance);
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    private int getCoinType(Item item) {
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return i;
        }
        return -1;
    }

    public void onButtonPressed(int functionId) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.accountError = false;
        if (functionId == 1) {
            this.accountNumber = UniversalAccounts.getInstance().getOrCreatePlayerAccount(this.playerUID);
            this.inventory[1] = new ItemStack(CommonProxy.itemUCCard, 1);
            this.inventory[1].func_77982_d(new NBTTagCompound());
            this.inventory[1].func_77978_p().func_74778_a("Name", this.playerName);
            this.inventory[1].func_77978_p().func_74778_a("Owner", this.playerUID);
            this.inventory[1].func_77978_p().func_74778_a("Account", this.accountNumber);
            this.accountBalance = UniversalAccounts.getInstance().getAccountBalance(this.accountNumber);
            this.cardOwner = this.playerUID;
        }
        if (functionId == 2 && UniversalAccounts.getInstance().getPlayerAccount(this.playerUID) != "") {
            UniversalAccounts.getInstance().transferPlayerAccount(this.playerUID);
            this.inventory[1] = new ItemStack(CommonProxy.itemUCCard, 1);
            this.inventory[1].func_77982_d(new NBTTagCompound());
            this.inventory[1].func_77978_p().func_74778_a("Name", this.playerName);
            this.inventory[1].func_77978_p().func_74778_a("Owner", this.playerUID);
            this.inventory[1].func_77978_p().func_74778_a("Account", UniversalAccounts.getInstance().getPlayerAccount(this.playerUID));
            this.accountBalance = UniversalAccounts.getInstance().getAccountBalance(this.accountNumber);
            this.cardOwner = this.playerUID;
        }
        if (functionId == 3) {
            this.depositCoins = true;
            this.withdrawCoins = false;
            if (this.accountNumber.contentEquals("none") && this.inventory[1] != null) {
                this.accountNumber = this.inventory[1].func_77978_p().func_74779_i("Account");
            }
        } else {
            this.depositCoins = false;
        }
        if (functionId == 4) {
            this.withdrawCoins = true;
            this.depositCoins = false;
            this.fillCoinSlot();
        } else {
            this.withdrawCoins = false;
        }
        if (functionId == 5) {
            String storedAccount = UniversalAccounts.getInstance().getPlayerAccount(this.playerUID);
            if (storedAccount != "") {
                this.accountNumber = storedAccount;
                this.cardOwner = this.playerUID;
                this.accountBalance = UniversalAccounts.getInstance().getAccountBalance(this.accountNumber);
                if (UniversalAccounts.getInstance().getCustomAccount(this.playerUID) != "") {
                    this.customAccountName = UniversalAccounts.getInstance().getCustomAccount(this.playerUID);
                    this.customAccountNumber = UniversalAccounts.getInstance().getPlayerAccount(this.customAccountName);
                }
            } else {
                this.accountNumber = "none";
            }
        }
        if (functionId == 6) {
            this.inventory[1] = null;
        }
        if (functionId == 7) {
            if (UniversalAccounts.getInstance().getPlayerAccount(this.customAccountName) != "" && !UniversalAccounts.getInstance().getCustomAccount(this.playerUID).contentEquals(this.customAccountName)) {
                this.accountError = true;
                this.customAccountName = "none";
                return;
            }
            if (UniversalAccounts.getInstance().getCustomAccount(this.playerUID) == "") {
                UniversalAccounts.getInstance().addCustomAccount(this.customAccountName, this.accountNumber);
            }
            this.customAccountName = UniversalAccounts.getInstance().getCustomAccount(this.playerUID);
            this.customAccountNumber = UniversalAccounts.getInstance().getPlayerAccount(this.customAccountName);
            this.inventory[1] = new ItemStack(CommonProxy.itemUCCard, 1);
            this.inventory[1].func_77982_d(new NBTTagCompound());
            this.inventory[1].func_77978_p().func_74778_a("Name", this.customAccountName);
            this.inventory[1].func_77978_p().func_74778_a("Owner", this.playerUID);
            this.inventory[1].func_77978_p().func_74778_a("Account", this.customAccountNumber);
        }
        if (functionId == 8) {
            this.inventory[1] = new ItemStack(CommonProxy.itemUCCard, 1);
            this.inventory[1].func_77982_d(new NBTTagCompound());
            this.inventory[1].func_77978_p().func_74778_a("Name", this.customAccountName);
            this.inventory[1].func_77978_p().func_74778_a("Owner", this.playerUID);
            this.inventory[1].func_77978_p().func_74778_a("Account", this.customAccountNumber);
            this.accountBalance = UniversalAccounts.getInstance().getAccountBalance(this.customAccountNumber);
        }
        if (functionId == 9) {
            if (UniversalAccounts.getInstance().getCustomAccount(this.playerUID) == "" || UniversalAccounts.getInstance().getPlayerAccount(this.customAccountName) != "") {
                this.accountError = true;
            } else {
                this.accountError = false;
                UniversalAccounts.getInstance().transferCustomAccount(this.accountNumber, this.accountNumber);
                this.inventory[1] = new ItemStack(CommonProxy.itemUCCard, 1);
                this.inventory[1].func_77982_d(new NBTTagCompound());
                this.inventory[1].func_77978_p().func_74778_a("Name", this.customAccountName);
                this.inventory[1].func_77978_p().func_74778_a("Owner", this.playerUID);
                this.inventory[1].func_77978_p().func_74778_a("Account", this.customAccountNumber);
                this.accountBalance = UniversalAccounts.getInstance().getAccountBalance(this.customAccountNumber);
            }
        }
    }

    public void fillCoinSlot() {
        if (this.inventory[0] == null && this.coinWithdrawalAmount > 0) {
            int logVal = Math.min((int)(Math.log(this.coinWithdrawalAmount) / Math.log(9.0)), 4);
            int stackSize = Math.min((int)((double)this.coinWithdrawalAmount / Math.pow(9.0, logVal)), 64);
            if (!this.field_145850_b.field_72995_K) {
                if (UniversalAccounts.getInstance().debitAccount(this.accountNumber, (int)((double)stackSize * Math.pow(9.0, logVal)))) {
                    this.inventory[0] = new ItemStack(coins[logVal], stackSize);
                    this.coinWithdrawalAmount = (int)((double)this.coinWithdrawalAmount - (double)stackSize * Math.pow(9.0, logVal));
                    this.accountBalance = UniversalAccounts.getInstance().getAccountBalance(this.accountNumber);
                    this.updateTE();
                } else {
                    this.coinWithdrawalAmount = 0;
                    this.withdrawCoins = false;
                    return;
                }
            }
        }
        if (this.coinWithdrawalAmount <= 0) {
            this.withdrawCoins = false;
            this.coinWithdrawalAmount = 0;
        }
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        return null;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    static {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        coins = itemArray;
    }
}

