/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import universalcoins.UniversalCoins;
import universalcoins.net.UCButtonMessage;
import universalcoins.net.UCPackagerServerMessage;
import universalcoins.proxy.CommonProxy;
import universalcoins.util.UniversalAccounts;

public class TilePackager
extends TileEntity
implements IInventory {
    private ItemStack[] inventory = new ItemStack[12];
    public static final int[] itemPackageSlot = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    public static final int itemCardSlot = 8;
    public static final int itemCoinSlot = 9;
    public static final int itemOutputSlot = 10;
    public static final int itemPackageInputSlot = 11;
    private static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};
    private static final Item[] coins;
    public int coinSum = 0;
    public boolean cardAvailable = false;
    public String customName = "";
    public String playerName = "";
    public String packageTarget = "";
    public boolean inUse = false;
    public int packageSize = 0;
    public int[] packageCost = new int[]{UniversalCoins.smallPackagePrice, UniversalCoins.medPackagePrice, UniversalCoins.largePackagePrice};

    public void onButtonPressed(int buttonId, boolean shiftPressed) {
        EntityItem entityItem;
        if (buttonId == 0) {
            if (shiftPressed) {
                this.sendPackage(this.packageTarget);
                return;
            }
            if (this.coinSum < this.packageCost[this.packageSize] && !this.cardAvailable) {
                return;
            }
            if (this.inventory[10] == null) {
                NBTTagList itemList = new NBTTagList();
                NBTTagCompound tagCompound = new NBTTagCompound();
                for (int i = 0; i < itemPackageSlot.length; ++i) {
                    ItemStack invStack = this.inventory[i];
                    if (invStack == null) continue;
                    if (invStack.func_77973_b() == CommonProxy.itemPackage) continue;
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74774_a("Slot", (byte)i);
                    invStack.func_77955_b(tag);
                    itemList.func_74742_a((NBTBase)tag);
                    this.inventory[i] = null;
                }
                if (itemList.func_74745_c() > 0) {
                    this.inventory[10] = new ItemStack(CommonProxy.itemPackage);
                    tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
                    this.inventory[10].func_77982_d(tagCompound);
                    if (this.cardAvailable) {
                        String account = this.inventory[8].func_77978_p().func_74779_i("accountNumber");
                        UniversalAccounts.getInstance().debitAccount(account, this.packageCost[this.packageSize]);
                    } else {
                        this.coinSum -= this.packageCost[this.packageSize];
                    }
                }
            }
        }
        if (buttonId == 1) {
            this.fillOutputSlot();
        }
        if (buttonId == 2) {
            this.packageSize = 0;
            for (int i = 0; i < 4; ++i) {
                if (this.inventory[i] == null) continue;
                if (this.field_145850_b.func_72924_a((String)this.playerName).field_71071_by.func_70447_i() != -1) {
                    this.field_145850_b.func_72924_a((String)this.playerName).field_71071_by.func_70441_a(this.inventory[i]);
                } else {
                    entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), this.inventory[i]);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                }
                this.inventory[i] = null;
            }
        }
        if (buttonId == 3) {
            this.packageSize = 1;
            for (int i = 0; i < 2; ++i) {
                if (this.inventory[i] == null) continue;
                if (this.field_145850_b.func_72924_a((String)this.playerName).field_71071_by.func_70447_i() != -1) {
                    this.field_145850_b.func_72924_a((String)this.playerName).field_71071_by.func_70441_a(this.inventory[i]);
                } else {
                    entityItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), this.inventory[i]);
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                }
                this.inventory[i] = null;
            }
        }
        if (buttonId == 4) {
            this.packageSize = 2;
        }
    }

    public void inUseCleanup() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.inUse = false;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : CommonProxy.blockPackager.func_149732_F();
    }

    public void setName(String name) {
        this.customName = name;
    }

    public boolean isNameLocalized() {
        return false;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    private int getCoinType(Item item) {
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return i;
        }
        return -1;
    }

    public void checkCard() {
        this.cardAvailable = false;
        if (this.inventory[8] != null && this.inventory[8].func_77942_o() && !this.field_145850_b.field_72995_K) {
            String account = this.inventory[8].func_77978_p().func_74779_i("Account");
            int accountBalance = UniversalAccounts.getInstance().getAccountBalance(account);
            if (accountBalance > this.packageCost[this.packageSize]) {
                this.cardAvailable = true;
            }
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public void sendPacket(int button, boolean shiftPressed) {
        UniversalCoins.snw.sendToServer((IMessage)new UCButtonMessage(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), button, shiftPressed));
    }

    public void sendServerUpdateMessage(String packageTarget, boolean shiftPressed) {
        UniversalCoins.snw.sendToServer((IMessage)new UCPackagerServerMessage(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), packageTarget, shiftPressed));
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateTE() {
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74768_a("coinSum", this.coinSum);
        tagCompound.func_74757_a("cardAvailable", this.cardAvailable);
        tagCompound.func_74778_a("customName", this.customName);
        tagCompound.func_74757_a("inUse", this.inUse);
        tagCompound.func_74768_a("packageSize", this.packageSize);
        tagCompound.func_74778_a("packageTarget", this.packageTarget);
        tagCompound.func_74768_a("smallPrice", this.packageCost[0]);
        tagCompound.func_74768_a("medPrice", this.packageCost[1]);
        tagCompound.func_74768_a("largePrice", this.packageCost[2]);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        try {
            this.coinSum = tagCompound.func_74762_e("coinSum");
        }
        catch (Throwable ex2) {
            this.coinSum = 0;
        }
        try {
            this.cardAvailable = tagCompound.func_74767_n("cardAvailable");
        }
        catch (Throwable ex2) {
            this.cardAvailable = false;
        }
        try {
            this.customName = tagCompound.func_74779_i("customName");
        }
        catch (Throwable ex2) {
            this.customName = "";
        }
        try {
            this.inUse = tagCompound.func_74767_n("inUse");
        }
        catch (Throwable ex2) {
            this.inUse = false;
        }
        try {
            this.packageSize = tagCompound.func_74762_e("packageSize");
        }
        catch (Throwable ex2) {
            this.packageSize = 0;
        }
        try {
            this.packageTarget = tagCompound.func_74779_i("packageTarget");
        }
        catch (Throwable ex2) {
            this.packageTarget = "";
        }
        try {
            this.packageCost[0] = tagCompound.func_74762_e("smallPrice");
        }
        catch (Throwable ex2) {
            this.packageCost[0] = UniversalCoins.smallPackagePrice;
        }
        try {
            this.packageCost[1] = tagCompound.func_74762_e("medPrice");
        }
        catch (Throwable ex2) {
            this.packageCost[1] = UniversalCoins.medPackagePrice;
        }
        try {
            this.packageCost[2] = tagCompound.func_74762_e("largePrice");
        }
        catch (Throwable ex2) {
            this.packageCost[2] = UniversalCoins.largePackagePrice;
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i >= this.inventory.length) {
            return null;
        }
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int size) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= size) {
                this.inventory[slot] = null;
            } else {
                stack = stack.func_77979_a(size);
                if (stack.field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
            if (slot == 8) {
                this.checkCard();
            }
        }
        return stack;
    }

    public void fillOutputSlot() {
        this.inventory[10] = null;
        if (this.coinSum > 0) {
            int logVal = Math.min((int)(Math.log(this.coinSum) / Math.log(9.0)), 4);
            int stackSize = Math.min((int)((double)this.coinSum / Math.pow(9.0, logVal)), 64);
            this.inventory[10] = new ItemStack(coins[logVal], stackSize);
            int itemValue = multiplier[logVal];
            int debitAmount = 0;
            debitAmount = Math.min(stackSize, (Integer.MAX_VALUE - this.coinSum) / itemValue);
            if (!this.field_145850_b.field_72995_K) {
                this.coinSum -= debitAmount * itemValue;
            }
        }
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null) {
            int coinType;
            if (slot == 9 && (coinType = this.getCoinType(stack.func_77973_b())) != -1) {
                int itemValue = multiplier[coinType];
                int depositAmount = Math.min(stack.field_77994_a, (Integer.MAX_VALUE - this.coinSum) / itemValue);
                this.coinSum += depositAmount * itemValue;
                this.inventory[slot].field_77994_a -= depositAmount;
                if (this.inventory[slot].field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
            if (slot == 8) {
                this.checkCard();
            }
        }
    }

    public void sendPackage(String packageTarget) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        EntityPlayer player = this.field_145850_b.func_72924_a(packageTarget);
        if (player != null) {
            if (player.field_71071_by.func_70447_i() != -1) {
                player.field_71071_by.func_70441_a(this.inventory[11]);
            } else {
                Random rand = new Random();
                float rx = rand.nextFloat() * 0.8f + 0.1f;
                float ry = rand.nextFloat() * 0.8f + 0.1f;
                float rz = rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityItem = new EntityItem(this.field_145850_b, player.field_70165_t + (double)rx, player.field_70163_u + (double)ry, player.field_70161_v + (double)rz, this.inventory[11]);
                this.field_145850_b.func_72838_d((Entity)entityItem);
            }
            player.func_145747_a((IChatComponent)new ChatComponentText("\u00a7c" + this.playerName + StatCollector.func_74838_a((String)"packager.message.sent")));
            this.inventory[11] = null;
        }
    }

    public void playerLookup(String player, boolean tabPressed) {
        if (tabPressed) {
            ArrayList<String> players = new ArrayList<String>();
            for (EntityPlayer p : this.field_145850_b.field_73010_i) {
                players.add(p.func_145748_c_().func_150260_c());
            }
            String[] test = new String[]{player};
            List match = CommandBase.func_175762_a((String[])test, players);
            if (match.size() > 0) {
                this.packageTarget = match.get(0).toString();
            }
        } else {
            this.packageTarget = this.field_145850_b.func_72924_a(player) != null ? player : "";
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    static {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        coins = itemArray;
    }
}

