/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import universalcoins.proxy.CommonProxy;
import universalcoins.util.UniversalAccounts;

public class TileSafe
extends TileEntity
implements IInventory,
ISidedInventory {
    private ItemStack[] inventory = new ItemStack[2];
    public static final int itemInputSlot = 0;
    public static final int itemOutputSlot = 1;
    private static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};
    private static final Item[] coins;
    public String blockOwner = "nobody";
    public String accountNumber = "0";
    public int accountBalance = 0;

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        int coinType;
        return index == 0 && (coinType = this.getCoinType(itemStackIn.func_77973_b())) != -1;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int size) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= size) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(size);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        this.coinsTaken(stack);
        return stack;
    }

    public void coinsTaken(ItemStack stack) {
        int coinType = this.getCoinType(stack.func_77973_b());
        if (coinType != -1) {
            int itemValue = multiplier[coinType];
            int debitAmount = 0;
            debitAmount = Math.min(stack.field_77994_a, (Integer.MAX_VALUE - this.accountBalance) / itemValue);
            if (!this.field_145850_b.field_72995_K) {
                UniversalAccounts.getInstance().debitAccount(this.accountNumber, debitAmount * itemValue);
                this.updateAccountBalance();
            }
            this.fillOutputSlot();
        }
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        return this.func_70301_a(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        int coinType;
        this.inventory[slot] = stack;
        if (stack != null && (coinType = this.getCoinType(stack.func_77973_b())) != -1) {
            int itemValue = multiplier[coinType];
            int depositAmount = 0;
            depositAmount = Math.min(stack.field_77994_a, (Integer.MAX_VALUE - this.accountBalance) / itemValue);
            if (!this.field_145850_b.field_72995_K) {
                UniversalAccounts.getInstance().creditAccount(this.accountNumber, depositAmount * itemValue);
                this.updateAccountBalance();
            }
            this.inventory[slot].field_77994_a -= depositAmount;
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            this.fillOutputSlot();
        }
    }

    public void fillOutputSlot() {
        if (this.accountBalance > 0) {
            int logVal = Math.min((int)(Math.log(this.accountBalance) / Math.log(9.0)), 4);
            int stackSize = Math.min((int)((double)this.accountBalance / Math.pow(9.0, logVal)), 64);
            this.inventory[1] = new ItemStack(coins[logVal], stackSize);
        }
    }

    public void updateAccountBalance() {
        this.accountBalance = UniversalAccounts.getInstance().getAccountBalance(this.accountNumber);
    }

    public String func_70005_c_() {
        return StatCollector.func_74838_a((String)"tile.blockSafe.name");
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    private int getCoinType(Item item) {
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74778_a("Owner", this.blockOwner);
        tagCompound.func_74778_a("AccountNumber", this.accountNumber);
        tagCompound.func_74768_a("Balance", this.accountBalance);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        try {
            this.blockOwner = tagCompound.func_74779_i("Owner");
        }
        catch (Throwable ex2) {
            this.blockOwner = "nobody";
        }
        try {
            this.accountNumber = tagCompound.func_74779_i("AccountNumber");
        }
        catch (Throwable ex2) {
            this.accountNumber = "0";
        }
        try {
            this.accountBalance = tagCompound.func_74762_e("Balance");
        }
        catch (Throwable ex2) {
            this.accountBalance = 0;
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        if (this.accountBalance == 0) {
            this.inventory[1] = null;
        }
    }

    public void updateTE() {
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void setSafeAccount(String playerName) {
        this.accountNumber = UniversalAccounts.getInstance().getOrCreatePlayerAccount(this.getPlayerUID(playerName));
    }

    private String getPlayerUID(String playerName) {
        EntityPlayer player = this.field_145850_b.func_72924_a(playerName);
        return player.func_110124_au().toString();
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    static {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        coins = itemArray;
    }
}

