/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import universalcoins.UniversalCoins;
import universalcoins.blocks.BlockSignal;
import universalcoins.net.UCButtonMessage;
import universalcoins.proxy.CommonProxy;

public class TileSignal
extends TileEntity
implements IInventory,
ITickable {
    private ItemStack[] inventory = new ItemStack[1];
    public static final int itemOutputSlot = 0;
    public static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};
    public static final Item[] coins;
    public String blockOwner = "";
    public int coinSum = 0;
    public int fee = 1;
    public int duration = 1;
    public int counter = 0;
    public int secondsLeft = 0;
    public int lastSecondsLeft = 0;
    public String customName = "";
    public boolean canProvidePower = false;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.counter > 0) {
                --this.counter;
                FMLLog.info((String)("counter: " + this.counter), (Object[])new Object[0]);
                this.secondsLeft = this.counter / 20;
                if (this.secondsLeft != this.lastSecondsLeft) {
                    this.lastSecondsLeft = this.secondsLeft;
                    this.updateTE();
                }
            } else {
                this.canProvidePower = false;
                this.updateTE();
                this.updateNeighbors();
            }
        }
    }

    public void onButtonPressed(int buttonId, boolean shift) {
        if (buttonId == 0) {
            this.fillOutputSlot();
        }
        if (buttonId == 1) {
            if (shift) {
                if (this.duration - 10 > 0) {
                    this.duration -= 10;
                }
            } else if (this.duration - 1 > 0) {
                --this.duration;
            }
        }
        if (buttonId == 2) {
            if (shift) {
                if (this.duration + 10 < Integer.MAX_VALUE) {
                    this.duration += 10;
                }
            } else if (this.duration + 1 < Integer.MAX_VALUE) {
                ++this.duration;
            }
        }
        if (buttonId == 3) {
            if (shift) {
                if (this.fee - 10 > 0) {
                    this.fee -= 10;
                }
            } else if (this.fee - 1 > 0) {
                --this.fee;
            }
        }
        if (buttonId == 4) {
            if (shift) {
                if (this.fee + 10 < Integer.MAX_VALUE) {
                    this.fee += 10;
                }
            } else if (this.fee + 1 < Integer.MAX_VALUE) {
                ++this.fee;
            }
        }
        this.updateTE();
    }

    public void activateSignal() {
        this.canProvidePower = true;
        this.counter += this.duration * 20;
        this.coinSum += this.fee;
        this.updateNeighbors();
    }

    private void updateNeighbors() {
        this.field_145854_h = this.func_145838_q();
        if (this.field_145854_h instanceof BlockSignal) {
            ((BlockSignal)this.field_145854_h).updatePower(this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    private int getCoinType(Item item) {
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return i;
        }
        return -1;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : CommonProxy.blockSignal.func_149732_F();
    }

    public void setName(String name) {
        this.customName = name;
    }

    public boolean isInventoryNameLocalized() {
        return false;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void sendPacket(int button, boolean shiftPressed) {
        UniversalCoins.snw.sendToServer((IMessage)new UCButtonMessage(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), button, shiftPressed));
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateTE() {
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74778_a("blockOwner", this.blockOwner);
        tagCompound.func_74768_a("coinSum", this.coinSum);
        tagCompound.func_74768_a("fee", this.fee);
        tagCompound.func_74768_a("duration", this.duration);
        tagCompound.func_74768_a("secondsLeft", this.secondsLeft);
        tagCompound.func_74778_a("customName", this.customName);
        tagCompound.func_74757_a("canProvidePower", this.canProvidePower);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        try {
            this.blockOwner = tagCompound.func_74779_i("blockOwner");
        }
        catch (Throwable ex2) {
            this.blockOwner = "";
        }
        try {
            this.coinSum = tagCompound.func_74762_e("coinSum");
        }
        catch (Throwable ex2) {
            this.coinSum = 0;
        }
        try {
            this.fee = tagCompound.func_74762_e("fee");
        }
        catch (Throwable ex2) {
            this.fee = 1;
        }
        try {
            this.duration = tagCompound.func_74762_e("duration");
        }
        catch (Throwable ex2) {
            this.duration = 1;
        }
        try {
            this.secondsLeft = tagCompound.func_74762_e("secondsLeft");
        }
        catch (Throwable ex2) {
            this.secondsLeft = 0;
        }
        try {
            this.customName = tagCompound.func_74779_i("customName");
        }
        catch (Throwable ex2) {
            this.customName = "";
        }
        try {
            this.canProvidePower = tagCompound.func_74767_n("canProvidePower");
        }
        catch (Throwable ex2) {
            this.canProvidePower = false;
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        if (i >= this.inventory.length) {
            return null;
        }
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int size) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= size) {
                this.inventory[slot] = null;
            } else {
                stack = stack.func_77979_a(size);
                if (stack.field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
        }
        return stack;
    }

    public void fillOutputSlot() {
        this.inventory[0] = null;
        if (this.coinSum > 0) {
            int logVal = Math.min((int)(Math.log(this.coinSum) / Math.log(9.0)), 4);
            int stackSize = Math.min((int)((double)this.coinSum / Math.pow(9.0, logVal)), 64);
            this.inventory[0] = new ItemStack(coins[logVal], stackSize);
            int itemValue = multiplier[logVal];
            int debitAmount = 0;
            debitAmount = Math.min(stackSize, (Integer.MAX_VALUE - this.coinSum) / itemValue);
            if (!this.field_145850_b.field_72995_K) {
                this.coinSum -= debitAmount * itemValue;
            }
        }
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int slot, ItemStack stack) {
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    static {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        coins = itemArray;
    }
}

