/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import universalcoins.UniversalCoins;
import universalcoins.net.UCButtonMessage;
import universalcoins.proxy.CommonProxy;
import universalcoins.util.UCItemPricer;
import universalcoins.util.UniversalAccounts;

public class TileTradeStation
extends TileEntity
implements IInventory,
ISidedInventory {
    private ItemStack[] inventory = new ItemStack[4];
    public static final int itemInputSlot = 0;
    public static final int itemOutputSlot = 1;
    public static final int itemCardSlot = 2;
    public static final int itemCoinSlot = 3;
    private static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};
    private static final Item[] coins;
    public int coinSum = 0;
    public int itemPrice = 0;
    public boolean buyButtonActive = false;
    public boolean sellButtonActive = false;
    public boolean coinButtonActive = false;
    public boolean isSStackButtonActive = false;
    public boolean isLStackButtonActive = false;
    public boolean isSBagButtonActive = false;
    public boolean isLBagButtonActive = false;
    public boolean autoModeButtonActive = UniversalCoins.autoModeEnabled;
    private static final int[] slots_top;
    private static final int[] slots_bottom;
    private static final int[] slots_sides;
    public int autoMode = 0;
    public int coinMode = 0;
    public String customName;
    public boolean inUse = false;
    public String playerName = "";

    public void update() {
        if (!this.field_145850_b.field_72995_K) {
            this.runAutoMode();
            this.runCoinMode();
        }
    }

    public void inUseCleanup() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.inUse = false;
    }

    private void activateBuySellButtons() {
        if (this.inventory[0] == null) {
            this.itemPrice = 0;
            this.buyButtonActive = false;
            this.sellButtonActive = false;
        } else {
            this.itemPrice = UCItemPricer.getInstance().getItemPrice(this.inventory[0]);
            if (this.itemPrice <= -1 || this.itemPrice == 0) {
                this.itemPrice = 0;
                this.buyButtonActive = false;
                this.sellButtonActive = false;
            } else {
                this.sellButtonActive = true;
                if ((long)this.coinSum + (long)this.itemPrice > Integer.MAX_VALUE) {
                    this.sellButtonActive = false;
                }
                if (this.inventory[0].func_77948_v()) {
                    this.sellButtonActive = false;
                }
                this.buyButtonActive = UniversalCoins.tradeStationBuyEnabled != false && (this.inventory[1] == null || this.inventory[1].func_77973_b() == this.inventory[0].func_77973_b() && this.inventory[1].field_77994_a < this.inventory[0].func_77976_d()) && (this.coinSum >= this.itemPrice || this.inventory[2] != null && !this.field_145850_b.field_72995_K && this.getAccountBalance() > this.itemPrice);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void activateRetrieveButtons() {
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            this.coinButtonActive = false;
                            this.isSStackButtonActive = false;
                            this.isLStackButtonActive = false;
                            this.isSBagButtonActive = false;
                            this.isLBagButtonActive = false;
                            if (this.coinSum <= 0) break block10;
                            if (this.inventory[1] == null) ** GOTO lbl-1000
                            if (this.inventory[1].func_77973_b() == CommonProxy.itemCoin && this.inventory[1].field_77994_a != 64) lbl-1000:
                            // 2 sources

                            {
                                v0 = true;
                            } else {
                                v0 = this.coinButtonActive = false;
                            }
                        }
                        if (this.coinSum < 9) break block11;
                        if (this.inventory[1] == null) ** GOTO lbl-1000
                        if (this.inventory[1].func_77973_b() == CommonProxy.itemSmallCoinStack && this.inventory[1].field_77994_a != 64) lbl-1000:
                        // 2 sources

                        {
                            v1 = true;
                        } else {
                            v1 = this.isSStackButtonActive = false;
                        }
                    }
                    if (this.coinSum < 81) break block12;
                    if (this.inventory[1] == null) ** GOTO lbl-1000
                    if (this.inventory[1].func_77973_b() == CommonProxy.itemLargeCoinStack && this.inventory[1].field_77994_a != 64) lbl-1000:
                    // 2 sources

                    {
                        v2 = true;
                    } else {
                        v2 = this.isLStackButtonActive = false;
                    }
                }
                if (this.coinSum < 729) break block13;
                if (this.inventory[1] == null) ** GOTO lbl-1000
                if (this.inventory[1].func_77973_b() == CommonProxy.itemSmallCoinBag && this.inventory[1].field_77994_a != 64) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = this.isSBagButtonActive = false;
                }
            }
            if (this.coinSum < 6561) break block14;
            if (this.inventory[1] == null) ** GOTO lbl-1000
            if (this.inventory[1].func_77973_b() == CommonProxy.itemLargeCoinBag && this.inventory[1].field_77994_a != 64) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = false;
            }
            this.isLBagButtonActive = v4;
        }
    }

    public void onSellPressed() {
        this.onSellPressed(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onSellPressed(int amount) {
        if (this.inventory[0] == null) {
            this.sellButtonActive = false;
            return;
        }
        if (amount > this.inventory[0].field_77994_a) {
            return;
        }
        this.itemPrice = UCItemPricer.getInstance().getItemPrice(this.inventory[0]);
        if (this.itemPrice == -1) {
            this.sellButtonActive = false;
            return;
        }
        if (this.inventory[0].func_77951_h()) {
            this.itemPrice = this.itemPrice * (this.inventory[0].func_77958_k() - this.inventory[0].func_77952_i()) / this.inventory[0].func_77958_k();
        }
        this.inventory[0].field_77994_a -= amount;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] != null) {
            if (this.inventory[2].func_77973_b() == CommonProxy.itemEnderCard && (double)this.getAccountBalance() + (double)(this.itemPrice * amount) * UniversalCoins.itemSellRatio < 2.147483647E9) {
                this.creditAccount((int)((double)(this.itemPrice * amount) * UniversalCoins.itemSellRatio));
                return;
            }
        }
        this.coinSum = (int)((double)this.coinSum + (double)(this.itemPrice * amount) * UniversalCoins.itemSellRatio);
    }

    public void onSellMaxPressed() {
        int amount = 0;
        if (this.inventory[0] == null && this.inventory[0] == null) {
            this.sellButtonActive = false;
            return;
        }
        if (this.inventory[0].func_77948_v()) {
            this.sellButtonActive = false;
            return;
        }
        this.itemPrice = UCItemPricer.getInstance().getItemPrice(this.inventory[0]);
        if (this.itemPrice == -1 || this.itemPrice == 0) {
            this.sellButtonActive = false;
            return;
        }
        amount = Math.min(this.inventory[0].field_77994_a, (Integer.MAX_VALUE - this.coinSum) / this.itemPrice);
        if (amount != 0) {
            this.onSellPressed(amount);
        }
    }

    public void onBuyPressed() {
        this.onBuyPressed(1);
    }

    public void onBuyPressed(int amount) {
        boolean useCard = false;
        if (this.inventory[0] == null || !UniversalCoins.tradeStationBuyEnabled.booleanValue()) {
            this.buyButtonActive = false;
            return;
        }
        this.itemPrice = UCItemPricer.getInstance().getItemPrice(this.inventory[0]);
        if (this.inventory[2] != null && this.getAccountBalance() > this.itemPrice * amount) {
            useCard = true;
        }
        if (this.itemPrice == -1 || this.coinSum < this.itemPrice * amount && !useCard) {
            this.buyButtonActive = false;
            return;
        }
        if (this.inventory[1] == null && this.inventory[0].func_77976_d() >= amount) {
            if (useCard && this.inventory[2] != null) {
                this.debitAccount(this.itemPrice * amount);
            } else {
                this.coinSum -= this.itemPrice * amount;
            }
            this.inventory[1] = new ItemStack(this.inventory[0].func_77973_b(), amount, this.inventory[0].func_77952_i());
        } else if (this.inventory[1].func_77973_b() == this.inventory[0].func_77973_b() && this.inventory[1].func_77952_i() == this.inventory[0].func_77952_i() && this.inventory[1].field_77994_a + amount <= this.inventory[0].func_77976_d()) {
            if (useCard && this.inventory[2] != null) {
                this.debitAccount(this.itemPrice * amount);
            } else {
                this.coinSum -= this.itemPrice * amount;
            }
            this.inventory[1].field_77994_a += amount;
        } else {
            this.buyButtonActive = false;
        }
    }

    public void onBuyMaxPressed() {
        boolean useCard = false;
        int amount = 0;
        this.itemPrice = UCItemPricer.getInstance().getItemPrice(this.inventory[0]);
        if (this.inventory[2] != null && this.getAccountBalance() > this.itemPrice) {
            useCard = true;
        }
        if (this.itemPrice == -1 || this.coinSum < this.itemPrice && !useCard) {
            this.buyButtonActive = false;
            return;
        }
        if (this.inventory[1] == null) {
            amount = this.inventory[0].func_77976_d() * this.itemPrice <= (useCard ? this.getAccountBalance() : this.coinSum) ? this.inventory[0].func_77976_d() : (useCard ? this.getAccountBalance() : this.coinSum) / this.itemPrice;
        } else if (this.inventory[1].func_77973_b() == this.inventory[0].func_77973_b() && this.inventory[1].func_77952_i() == this.inventory[0].func_77952_i() && this.inventory[1].field_77994_a < this.inventory[0].func_77976_d()) {
            amount = (this.inventory[1].func_77976_d() - this.inventory[1].field_77994_a) * this.itemPrice <= (useCard ? this.getAccountBalance() : this.coinSum) ? this.inventory[1].func_77976_d() - this.inventory[1].field_77994_a : (useCard ? this.getAccountBalance() : this.coinSum) / this.itemPrice;
        } else {
            this.buyButtonActive = false;
        }
        this.onBuyPressed(amount);
    }

    public void onAutoModeButtonPressed() {
        if (this.autoMode == 2) {
            this.autoMode = 0;
        } else {
            ++this.autoMode;
            if (this.autoMode == 1 && !UniversalCoins.tradeStationBuyEnabled.booleanValue()) {
                ++this.autoMode;
            }
        }
    }

    public void onCoinModeButtonPressed() {
        this.coinMode = this.coinMode == 0 ? 5 : --this.coinMode;
    }

    public void runAutoMode() {
        if (this.autoMode == 0) {
            return;
        }
        if (this.autoMode == 1) {
            this.onBuyMaxPressed();
        } else if (this.autoMode == 2) {
            this.onSellMaxPressed();
        }
    }

    public void runCoinMode() {
        if (this.coinMode == 0) {
            return;
        }
        this.onRetrieveButtonsPressed(this.coinMode + 1, true);
    }

    public void onRetrieveButtonsPressed(int buttonClickedID, boolean shiftPressed) {
        int absoluteButton = buttonClickedID - 2;
        int multiplier = 1;
        for (int i = 0; i < absoluteButton; ++i) {
            multiplier *= 9;
        }
        Item itemOnButton = coins[absoluteButton];
        if (this.coinSum < multiplier || this.inventory[1] != null && this.inventory[1].func_77973_b() != itemOnButton || this.inventory[1] != null && this.inventory[1].field_77994_a == 64) {
            return;
        }
        if (shiftPressed) {
            if (this.inventory[1] == null) {
                int amount = this.coinSum / multiplier;
                if (amount >= 64) {
                    this.coinSum -= multiplier * 64;
                    this.inventory[1] = new ItemStack(itemOnButton);
                    this.inventory[1].field_77994_a = 64;
                } else {
                    this.coinSum -= multiplier * amount;
                    this.inventory[1] = new ItemStack(itemOnButton);
                    this.inventory[1].field_77994_a = amount;
                }
            } else {
                int amount = Math.min(this.coinSum / multiplier, this.inventory[1].func_77976_d() - this.inventory[1].field_77994_a);
                this.inventory[1].field_77994_a += amount;
                this.coinSum -= multiplier * amount;
            }
        } else {
            this.coinSum -= multiplier;
            if (this.inventory[1] == null) {
                this.inventory[1] = new ItemStack(itemOnButton);
            } else {
                ++this.inventory[1].field_77994_a;
            }
        }
    }

    public void onButtonPressed(int buttonId, boolean shiftPressed) {
        if (buttonId == 0) {
            if (shiftPressed) {
                this.onBuyMaxPressed();
            } else {
                this.onBuyPressed();
            }
        } else if (buttonId == 1) {
            if (shiftPressed) {
                this.onSellMaxPressed();
            } else {
                this.onSellPressed();
            }
        } else if (buttonId == 8) {
            this.onAutoModeButtonPressed();
        } else if (buttonId == 7) {
            this.onCoinModeButtonPressed();
        } else if (buttonId <= 6) {
            this.onRetrieveButtonsPressed(buttonId, shiftPressed);
        }
        this.activateRetrieveButtons();
        this.activateBuySellButtons();
        this.updateTE();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        try {
            this.coinSum = tagCompound.func_74762_e("CoinsLeft");
        }
        catch (Throwable ex2) {
            this.coinSum = 0;
        }
        try {
            this.autoMode = tagCompound.func_74762_e("AutoMode");
        }
        catch (Throwable ex2) {
            this.autoMode = 0;
        }
        try {
            this.coinMode = tagCompound.func_74762_e("CoinMode");
        }
        catch (Throwable ex2) {
            this.coinMode = 0;
        }
        try {
            this.itemPrice = tagCompound.func_74762_e("ItemPrice");
        }
        catch (Throwable ex2) {
            this.itemPrice = 0;
        }
        try {
            this.customName = tagCompound.func_74779_i("CustomName");
        }
        catch (Throwable ex2) {
            this.customName = null;
        }
        try {
            this.inUse = tagCompound.func_74767_n("InUse");
        }
        catch (Throwable ex2) {
            this.inUse = false;
        }
        try {
            this.buyButtonActive = tagCompound.func_74767_n("buyButtonActive");
        }
        catch (Throwable ex2) {
            this.buyButtonActive = false;
        }
        try {
            this.sellButtonActive = tagCompound.func_74767_n("sellButtonActive");
        }
        catch (Throwable ex2) {
            this.sellButtonActive = false;
        }
        this.activateRetrieveButtons();
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_82580_o("CoinsLeft");
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74768_a("CoinsLeft", this.coinSum);
        tagCompound.func_74768_a("AutoMode", this.autoMode);
        tagCompound.func_74768_a("CoinMode", this.coinMode);
        tagCompound.func_74768_a("ItemPrice", this.itemPrice);
        tagCompound.func_74778_a("CustomName", this.func_70005_c_());
        tagCompound.func_74757_a("InUse", this.inUse);
        tagCompound.func_74757_a("buyButtonActive", this.buyButtonActive);
        tagCompound.func_74757_a("sellButtonActive", this.sellButtonActive);
    }

    public void updateTE() {
        this.field_145850_b.func_175689_h(this.field_174879_c);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void sendPacket(int button, boolean shiftPressed) {
        UniversalCoins.snw.sendToServer((IMessage)new UCButtonMessage(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), button, shiftPressed));
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : CommonProxy.blockTradeStation.func_149732_F();
    }

    public void setName(String name) {
        this.customName = name;
    }

    public boolean isNameLocalized() {
        return false;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70301_a(int i) {
        if (i >= this.inventory.length) {
            return null;
        }
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int size) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= size) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(size);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        this.activateBuySellButtons();
        this.activateRetrieveButtons();
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int i) {
        this.inUse = false;
        return this.func_70301_a(i);
    }

    /*
     * Unable to fully structure code
     */
    public void func_70299_a(int slot, ItemStack stack) {
        block3: {
            block4: {
                this.inventory[slot] = stack;
                if (stack == null) break block3;
                if (slot != 3 && slot != 0 || (coinType = this.getCoinType(stack.func_77973_b())) == -1) break block4;
                itemValue = TileTradeStation.multiplier[coinType];
                depositAmount = Math.min(stack.field_77994_a, (0x7FFFFFFF - this.coinSum) / itemValue);
                if (this.inventory[2] == null || !this.inventory[2].func_77942_o()) ** GOTO lbl-1000
                if (this.inventory[2].func_77973_b() == CommonProxy.itemEnderCard && this.getAccountBalance() + this.itemPrice * depositAmount < 0x7FFFFFFF) {
                    this.creditAccount(depositAmount * itemValue);
                } else lbl-1000:
                // 2 sources

                {
                    this.coinSum += depositAmount * itemValue;
                }
                this.inventory[slot].field_77994_a -= depositAmount;
                if (this.inventory[slot].field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
            this.activateRetrieveButtons();
            this.activateBuySellButtons();
            this.update();
        }
    }

    private int getCoinType(Item item) {
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        Item stackItem = itemstack.func_77973_b();
        if (slot == 3) {
            if (stackItem == CommonProxy.itemCoin) return true;
            if (stackItem == CommonProxy.itemSmallCoinStack) return true;
            if (stackItem == CommonProxy.itemLargeCoinStack) return true;
            if (stackItem == CommonProxy.itemSmallCoinBag) return true;
            if (stackItem != CommonProxy.itemLargeCoinBag) return false;
            return true;
        }
        if (slot == 0) return true;
        if (slot != 3) return false;
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slots_bottom : (side == EnumFacing.UP ? slots_top : slots_sides);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        block2: {
            block3: {
                if (index != 3) break block2;
                if (itemStackIn.func_77973_b() == CommonProxy.itemCoin) break block3;
                if (itemStackIn.func_77973_b() == CommonProxy.itemSmallCoinStack) break block3;
                if (itemStackIn.func_77973_b() == CommonProxy.itemLargeCoinStack) break block3;
                if (itemStackIn.func_77973_b() == CommonProxy.itemSmallCoinBag) break block3;
                if (itemStackIn.func_77973_b() != CommonProxy.itemLargeCoinBag) break block2;
            }
            return true;
        }
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public int getAccountBalance() {
        if (this.inventory[2] != null) {
            String accountNumber = this.inventory[2].func_77978_p().func_74779_i("Account");
            return UniversalAccounts.getInstance().getAccountBalance(accountNumber);
        }
        return -1;
    }

    public void debitAccount(int amount) {
        if (this.inventory[2] != null) {
            String accountNumber = this.inventory[2].func_77978_p().func_74779_i("Account");
            UniversalAccounts.getInstance().debitAccount(accountNumber, amount);
        }
    }

    public void creditAccount(int amount) {
        if (this.inventory[2] != null) {
            String accountNumber = this.inventory[2].func_77978_p().func_74779_i("Account");
            UniversalAccounts.getInstance().creditAccount(accountNumber, amount);
        }
    }

    public IChatComponent func_145748_c_() {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    static {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        coins = itemArray;
        slots_top = new int[]{0, 1, 2, 3};
        slots_bottom = new int[]{0, 1, 2, 3};
        slots_sides = new int[]{0, 1, 2, 3};
    }
}

