/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class UCItemPricer {
    private static final UCItemPricer instance = new UCItemPricer();
    private static Map<String, Integer> ucPriceMap = new HashMap<String, Integer>(0);
    private static Map<String, String> ucModnameMap = new HashMap<String, String>(0);
    private static String configPath = FMLInjectionData.data()[6] + "/config/universalcoins/";
    private Random random = new Random();

    public static UCItemPricer getInstance() {
        return instance;
    }

    private UCItemPricer() {
    }

    public void loadConfigs() {
        if (!new File(configPath).exists()) {
            this.buildPricelistHashMap();
            try {
                this.loadDefaults();
            }
            catch (IOException e) {
                FMLLog.warning((String)"Universal Coins: Failed to load default configs", (Object[])new Object[0]);
                e.printStackTrace();
            }
            this.autoPriceCraftedItems();
            this.autoPriceSmeltedItems();
            this.writePriceLists();
        } else {
            try {
                this.loadPricelists();
            }
            catch (IOException e) {
                FMLLog.warning((String)"Universal Coins: Failed to load config files", (Object[])new Object[0]);
                e.printStackTrace();
            }
        }
    }

    private void loadDefaults() throws IOException {
        String[] configList = new String[]{"pricelists/minecraft.cfg", "pricelists/BuildCraft.cfg", "pricelists/universalcoins.cfg", "pricelists/ThermalExpansion.cfg", "pricelists/SolarFlux.cfg", "pricelists/eplus.cfg", "pricelists/betterstorage.cfg", "pricelists/Backpack.cfg", "pricelists/ThermalFoundation.cfg", "pricelists/cfm.cfg", "pricelists/BiblioCraft.cfg", "pricelists/FLabsBF.cfg", "pricelists/oredictionary.cfg"};
        for (int i = 0; i < configList.length; ++i) {
            InputStream priceResource = UCItemPricer.class.getResourceAsStream(configList[i]);
            if (priceResource == null) {
                return;
            }
            String priceString = this.convertStreamToString(priceResource);
            this.processDefaultConfigs(priceString);
        }
    }

    private String convertStreamToString(InputStream is) {
        Scanner scanner = new Scanner(is);
        Scanner s = scanner.useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        scanner.close();
        return result;
    }

    private void processDefaultConfigs(String priceString) {
        StringTokenizer tokenizer = new StringTokenizer(priceString, "\n\r", false);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            String[] tempData = token.split("=");
            if (ucPriceMap.get(tempData[0]) == null || tempData.length != 2) continue;
            ucPriceMap.put(tempData[0], Integer.valueOf(tempData[1]));
        }
    }

    private void buildPricelistHashMap() {
        Object[] itemSet;
        ArrayList<ItemStack> itemsDiscovered = new ArrayList<ItemStack>();
        for (Object itemObject : itemSet = Item.field_150901_e.func_148742_b().toArray()) {
            String item = itemObject.toString();
            String[] tempModName = item.split("\\W", 3);
            String modName = tempModName[0];
            if (item != null) {
                Item test = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(item));
                for (int i = 0; i < 16; ++i) {
                    ItemStack value = new ItemStack(test, 1, i);
                    try {
                        String name = value.func_77977_a();
                        if (name == null || itemsDiscovered.contains(name)) continue;
                        itemsDiscovered.add(value);
                        continue;
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                }
            }
            for (String ore : OreDictionary.getOreNames()) {
                ucModnameMap.put(ore, "oredictionary");
                if (ucPriceMap.containsKey(ore)) continue;
                List test = OreDictionary.getOres((String)ore);
                int itemValue = -1;
                for (int j = 0; j < test.size(); ++j) {
                    int subItemValue = UCItemPricer.getInstance().getItemPrice((ItemStack)test.get(j));
                    if (subItemValue <= 0) continue;
                    itemValue = subItemValue;
                }
                ucPriceMap.put(ore, itemValue);
            }
            for (ItemStack itemstack : itemsDiscovered) {
                ucModnameMap.put(itemstack.func_77977_a(), modName);
                if (ucPriceMap.containsKey(itemstack.func_77977_a())) continue;
                ucPriceMap.put(itemstack.func_77977_a(), -1);
            }
            itemsDiscovered.clear();
        }
    }

    private void loadPricelists() throws IOException {
        File folder = new File(configPath);
        File[] configList = folder.listFiles();
        for (int i = 0; i < configList.length; ++i) {
            if (!configList[i].isFile()) continue;
            BufferedReader br = new BufferedReader(new FileReader(configList[i]));
            String tempString = "";
            String[] modName = configList[i].getName().split("\\.");
            while ((tempString = br.readLine()) != null) {
                if (tempString.startsWith("//") || tempString.startsWith("#")) continue;
                String[] tempData = tempString.split("=");
                if (tempData.length < 2) {
                    FMLLog.warning((String)("Universal Coins: Error detected in pricelist: " + configList[i].getName() + " " + tempString + " is invalid input"), (Object[])new Object[0]);
                    continue;
                }
                int itemPrice = -1;
                try {
                    itemPrice = Integer.valueOf(tempData[1]);
                }
                catch (NumberFormatException e) {
                    FMLLog.warning((String)("Universal Coins: Error detected in pricelist: " + configList[i].getName() + " " + tempString + " is invalid input"), (Object[])new Object[0]);
                }
                ucPriceMap.put(tempData[0], itemPrice);
                ucModnameMap.put(tempData[0], modName[0]);
            }
            br.close();
        }
    }

    private void writePriceLists() {
        Set<Map.Entry<String, Integer>> set = ucPriceMap.entrySet();
        for (Map.Entry<String, Integer> me : set) {
            String keyname = me.getKey();
            String modname = ucModnameMap.get(keyname) + ".cfg";
            Path pathToFile = Paths.get(configPath + modname, new String[0]);
            try {
                Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                FMLLog.warning((String)"Universal Coins: Failed to create config file folders", (Object[])new Object[0]);
            }
            File modconfigfile = new File(configPath + modname);
            if (!modconfigfile.exists()) {
                try {
                    modconfigfile.createNewFile();
                }
                catch (IOException e) {
                    FMLLog.warning((String)"Universal Coins: Failed to create config file", (Object[])new Object[0]);
                }
            }
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(modconfigfile, true)));
                out.println(me.getKey() + "=" + me.getValue());
                out.close();
            }
            catch (IOException e) {
                FMLLog.warning((String)"Universal Coins: Failed to append to config file", (Object[])new Object[0]);
            }
        }
    }

    public int getItemPrice(ItemStack itemStack) {
        int[] id;
        if (itemStack == null) {
            return -1;
        }
        int ItemPrice = -1;
        String itemName = null;
        try {
            itemName = itemStack.func_77977_a();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (ucPriceMap.get(itemName) != null) {
            ItemPrice = ucPriceMap.get(itemName);
        }
        if (ItemPrice == -1 && (id = OreDictionary.getOreIDs((ItemStack)itemStack)).length > 0 && ucPriceMap.get(itemName = OreDictionary.getOreName((int)id[0])) != null) {
            ItemPrice = ucPriceMap.get(itemName);
        }
        return ItemPrice;
    }

    public int getItemPrice(String string) {
        if (string.isEmpty()) {
            return -1;
        }
        Integer ItemPrice = -1;
        if (ucPriceMap.get(string) != null) {
            ItemPrice = ucPriceMap.get(string);
        }
        return ItemPrice;
    }

    public boolean setItemPrice(ItemStack itemStack, int price) {
        int itemID;
        Item baseItem;
        if (itemStack == null) {
            return false;
        }
        if (itemStack.func_77981_g() && (baseItem = Item.func_150899_d((int)(itemID = Item.func_150891_b((Item)itemStack.func_77973_b())))).func_77658_a().matches(itemStack.func_77977_a())) {
            return false;
        }
        if (itemStack.func_77951_h() && !itemStack.func_77984_f()) {
            return false;
        }
        String itemName = itemStack.func_77977_a();
        String itemRegistryKey = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b())).toString();
        String[] tempModName = itemRegistryKey.split("\\W", 3);
        String modName = tempModName[0];
        ucModnameMap.put(itemName, modName);
        ucPriceMap.put(itemName, price);
        return true;
    }

    public boolean setItemPrice(String string, int price) {
        if (string.isEmpty()) {
            return false;
        }
        if (ucPriceMap.containsKey(string)) {
            ucPriceMap.put(string, price);
            return true;
        }
        return false;
    }

    public void updatePriceLists() {
        File[] files;
        File folder = new File(configPath);
        if (folder.exists() && null != (files = folder.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        this.buildPricelistHashMap();
        this.autoPriceCraftedItems();
        this.writePriceLists();
    }

    public void savePriceLists() {
        File[] files;
        File folder = new File(configPath);
        if (folder.exists() && null != (files = folder.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                files[i].delete();
            }
        }
        this.writePriceLists();
    }

    public void resetDefaults() {
        try {
            this.loadDefaults();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ItemStack getRandomPricedStack() {
        ArrayList<String> keys = new ArrayList<String>(ucPriceMap.keySet());
        ItemStack stack = null;
        while (stack == null) {
            Item item;
            String test = (String)keys.get(this.random.nextInt(keys.size()));
            int price = 0;
            if (ucPriceMap.get(test) != null) {
                price = ucPriceMap.get(test);
            }
            if (price <= 0) continue;
            if (test.startsWith("tile.") || test.startsWith("item.")) {
                test = test.substring(5);
            }
            if ((item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(test))) == null) continue;
            stack = new ItemStack(item);
        }
        return stack;
    }

    private void autoPriceCraftedItems() {
        ArrayList allrecipes = new ArrayList(CraftingManager.func_77594_a().func_77592_b());
        boolean priceUpdate = false;
        while (priceUpdate) {
            priceUpdate = false;
            for (IRecipe irecipe : allrecipes) {
                int itemCost = 0;
                boolean validRecipe = true;
                ItemStack output = irecipe.func_77571_b();
                if (output == null || UCItemPricer.getInstance().getItemPrice(output) != -1) continue;
                List<ItemStack> recipeItems = UCItemPricer.getRecipeInputs(irecipe);
                for (int i = 0; i < recipeItems.size(); ++i) {
                    ItemStack stack = recipeItems.get(i);
                    if (UCItemPricer.getInstance().getItemPrice(stack) != -1) {
                        itemCost += UCItemPricer.getInstance().getItemPrice(stack);
                        continue;
                    }
                    validRecipe = false;
                }
                if (!validRecipe || itemCost <= 0) continue;
                priceUpdate = true;
                if (output.field_77994_a > 1) {
                    itemCost /= output.field_77994_a;
                }
                try {
                    UCItemPricer.getInstance().setItemPrice(output, itemCost);
                }
                catch (Exception e) {
                    FMLLog.warning((String)"Universal Coins Autopricer: Failed to set item price.", (Object[])new Object[0]);
                }
            }
        }
    }

    public static List<ItemStack> getRecipeInputs(IRecipe recipe) {
        ArrayList<ItemStack> recipeInputs;
        block13: {
            block15: {
                block14: {
                    block12: {
                        recipeInputs = new ArrayList<ItemStack>();
                        if (!(recipe instanceof ShapedRecipes)) break block12;
                        ShapedRecipes shapedRecipe = (ShapedRecipes)recipe;
                        for (int i = 0; i < shapedRecipe.field_77574_d.length; ++i) {
                            if (!(shapedRecipe.field_77574_d[i] instanceof ItemStack)) continue;
                            ItemStack itemStack = shapedRecipe.field_77574_d[i].func_77946_l();
                            if (itemStack.field_77994_a > 1) {
                                itemStack.field_77994_a = 1;
                            }
                            recipeInputs.add(itemStack);
                        }
                        break block13;
                    }
                    if (!(recipe instanceof ShapelessRecipes)) break block14;
                    ShapelessRecipes shapelessRecipe = (ShapelessRecipes)recipe;
                    for (Object object : shapelessRecipe.field_77579_b) {
                        if (!(object instanceof ItemStack)) continue;
                        ItemStack itemStack = ((ItemStack)object).func_77946_l();
                        if (itemStack.field_77994_a > 1) {
                            itemStack.field_77994_a = 1;
                        }
                        recipeInputs.add(itemStack);
                    }
                    break block13;
                }
                if (!(recipe instanceof ShapedOreRecipe)) break block15;
                ShapedOreRecipe shapedOreRecipe = (ShapedOreRecipe)recipe;
                for (int i = 0; i < shapedOreRecipe.getInput().length; ++i) {
                    if (shapedOreRecipe.getInput()[i] instanceof ArrayList) {
                        ArrayList test = (ArrayList)shapedOreRecipe.getInput()[i];
                        if (test.size() <= 0) continue;
                        boolean arrayListHasPricedItem = false;
                        for (int j = 0; j < test.size(); ++j) {
                            if (UCItemPricer.getInstance().getItemPrice((ItemStack)test.get(j)) <= 0) continue;
                            recipeInputs.add((ItemStack)test.get(j));
                            arrayListHasPricedItem = true;
                            break;
                        }
                        if (arrayListHasPricedItem) continue;
                        recipeInputs.add((ItemStack)test.get(0));
                        continue;
                    }
                    if (!(shapedOreRecipe.getInput()[i] instanceof ItemStack)) continue;
                    ItemStack itemStack = ((ItemStack)shapedOreRecipe.getInput()[i]).func_77946_l();
                    if (itemStack.field_77994_a > 1) {
                        itemStack.field_77994_a = 1;
                    }
                    recipeInputs.add(itemStack);
                }
                break block13;
            }
            if (!(recipe instanceof ShapelessOreRecipe)) break block13;
            ShapelessOreRecipe shapelessOreRecipe = (ShapelessOreRecipe)recipe;
            for (Object object : shapelessOreRecipe.getInput()) {
                if (object instanceof ArrayList) {
                    ArrayList test = (ArrayList)object;
                    boolean arrayListHasPricedItem = false;
                    for (int j = 0; j < test.size(); ++j) {
                        if (UCItemPricer.getInstance().getItemPrice((ItemStack)test.get(j)) <= 0) continue;
                        recipeInputs.add((ItemStack)test.get(j));
                        arrayListHasPricedItem = true;
                        break;
                    }
                    if (arrayListHasPricedItem || test.size() <= 0) continue;
                    recipeInputs.add((ItemStack)test.get(0));
                    continue;
                }
                if (!(object instanceof ItemStack)) continue;
                ItemStack itemStack = ((ItemStack)object).func_77946_l();
                if (itemStack.field_77994_a > 1) {
                    itemStack.field_77994_a = 1;
                }
                recipeInputs.add(itemStack);
            }
        }
        return recipeInputs;
    }

    private void autoPriceSmeltedItems() {
        Map recipes = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Map.Entry recipe : recipes.entrySet()) {
            ItemStack input = (ItemStack)recipe.getKey();
            ItemStack output = (ItemStack)recipe.getValue();
            if (ucPriceMap.get(input.func_77977_a()) == null) continue;
            int inputValue = ucPriceMap.get(input.func_77977_a());
            int outputValue = ucPriceMap.get(output.func_77977_a());
            if (inputValue == -1 || outputValue != -1) continue;
            ucPriceMap.put(output.func_77977_a(), inputValue + 2);
        }
    }

    public static Map<String, Integer> getUcPriceMap() {
        return ucPriceMap;
    }
}

