/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.util;

import java.text.DecimalFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import universalcoins.Achievements;
import universalcoins.proxy.CommonProxy;
import universalcoins.util.UniversalAccounts;

public class UCPlayerPickupEventHandler {
    private World world;
    private String accountNumber;
    private static final int[] multiplier = new int[]{1, 9, 81, 729, 6561};

    @SubscribeEvent
    public void onItemPickup(EntityItemPickupEvent event) {
        block10: {
            block9: {
                if (event.item.func_92059_d().func_77973_b() == CommonProxy.itemCoin) break block9;
                if (event.item.func_92059_d().func_77973_b() == CommonProxy.itemSmallCoinStack) break block9;
                if (event.item.func_92059_d().func_77973_b() == CommonProxy.itemLargeCoinStack) break block9;
                if (event.item.func_92059_d().func_77973_b() == CommonProxy.itemSmallCoinBag) break block9;
                if (event.item.func_92059_d().func_77973_b() != CommonProxy.itemLargeCoinBag) break block10;
            }
            event.entityPlayer.func_71064_a((StatBase)Achievements.achCoin, 1);
            this.world = event.entityPlayer.field_70170_p;
            EntityPlayer player = event.entityPlayer;
            ItemStack[] inventory = player.field_71071_by.field_70462_a;
            DecimalFormat formatter = new DecimalFormat("#,###,###,###");
            for (int i = 0; i < inventory.length; ++i) {
                if (inventory[i] == null) continue;
                if (inventory[i].func_77973_b() != CommonProxy.itemEnderCard) continue;
                if (!inventory[i].func_77942_o()) {
                    return;
                }
                this.accountNumber = inventory[i].func_77978_p().func_74779_i("Account");
                int accountBalance = this.getAccountBalance(this.accountNumber);
                if (accountBalance == -1) {
                    return;
                }
                if (event.item.func_92059_d().field_77994_a == 0) {
                    return;
                }
                int coinType = this.getCoinType(event.item.func_92059_d().func_77973_b());
                if (coinType == -1) {
                    return;
                }
                int coinValue = multiplier[coinType];
                int depositAmount = Math.min(event.item.func_92059_d().field_77994_a, (Integer.MAX_VALUE - accountBalance) / coinValue);
                if (depositAmount > 0) {
                    this.creditAccount(this.accountNumber, depositAmount * coinValue);
                    player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.itemEnderCard.message.deposit") + " " + formatter.format(depositAmount * coinValue) + " " + StatCollector.func_74838_a((String)"item.itemCoin.name")));
                    event.item.func_92059_d().field_77994_a -= depositAmount;
                }
                if (event.item.func_92059_d().field_77994_a != 0) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    private int getCoinType(Item item) {
        Item[] itemArray = new Item[5];
        itemArray[0] = CommonProxy.itemCoin;
        itemArray[1] = CommonProxy.itemSmallCoinStack;
        itemArray[2] = CommonProxy.itemLargeCoinStack;
        itemArray[3] = CommonProxy.itemSmallCoinBag;
        itemArray[4] = CommonProxy.itemLargeCoinBag;
        Item[] coins = itemArray;
        for (int i = 0; i < 5; ++i) {
            if (item != coins[i]) continue;
            return i;
        }
        return -1;
    }

    private int getAccountBalance(String accountNumber) {
        return UniversalAccounts.getInstance().getAccountBalance(accountNumber);
    }

    private void creditAccount(String accountNumber, int amount) {
        UniversalAccounts.getInstance().creditAccount(accountNumber, amount);
    }
}

