/*
 * Decompiled with CFR 0.152.
 */
package universalcoins.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import universalcoins.util.UCWorldData;

public class UniversalAccounts {
    private static final UniversalAccounts instance = new UniversalAccounts();

    public static UniversalAccounts getInstance() {
        return instance;
    }

    private UniversalAccounts() {
    }

    public int getAccountBalance(String accountNumber) {
        if (this.hasKey(accountNumber)) {
            return this.getWorldInt(accountNumber);
        }
        return -1;
    }

    public boolean debitAccount(String accountNumber, int amount) {
        int balance;
        if (this.hasKey(accountNumber) && amount <= (balance = this.getWorldInt(accountNumber))) {
            this.setWorldData(accountNumber, balance -= amount);
            return true;
        }
        return false;
    }

    public boolean creditAccount(String accountNumber, int amount) {
        int balance;
        if (this.hasKey(accountNumber) && (double)(balance = this.getWorldInt(accountNumber)) + (double)amount <= 2.147483647E9) {
            this.setWorldData(accountNumber, balance += amount);
            return true;
        }
        return false;
    }

    public String getPlayerAccount(String playerUID) {
        return this.getWorldString(playerUID);
    }

    public String getOrCreatePlayerAccount(String playerUID) {
        String accountNumber = this.getWorldString(playerUID);
        if (accountNumber == "") {
            while (!this.hasKey(playerUID)) {
                accountNumber = String.valueOf(this.generateAccountNumber());
                if (this.getWorldString(accountNumber) != "") continue;
                this.setWorldData(playerUID, accountNumber);
                this.setWorldData(accountNumber, 0);
            }
        }
        return accountNumber;
    }

    public boolean addPlayerAccount(String playerUID) {
        if (this.getWorldString(playerUID) == "") {
            String accountNumber = "";
            while (this.getWorldString(accountNumber) == "") {
                accountNumber = String.valueOf(this.generateAccountNumber());
                if (this.getWorldString(accountNumber) != "") continue;
                this.setWorldData(playerUID, accountNumber);
                this.setWorldData(accountNumber, 0);
                return true;
            }
        }
        return false;
    }

    public String getCustomAccount(String playerUID) {
        return this.getWorldString("\u00ef\u00bf\u00bd" + playerUID);
    }

    public boolean addCustomAccount(String customName, String playerUID) {
        if (this.getWorldString("\u00ef\u00bf\u00bd" + playerUID) == "" && this.getWorldString(customName) == "") {
            String customAccountNumber = "";
            while (this.getWorldString(customAccountNumber) == "") {
                customAccountNumber = String.valueOf(this.generateAccountNumber());
                if (this.getWorldString(customAccountNumber) != "") continue;
                this.setWorldData("\u00ef\u00bf\u00bd" + playerUID, customName);
                this.setWorldData(customName, customAccountNumber);
                this.setWorldData(customAccountNumber, 0);
                return true;
            }
        }
        return false;
    }

    public void transferCustomAccount(String playerUID, String customAccountName) {
        String oldName = this.getWorldString("\u00ef\u00bf\u00bd" + playerUID);
        String oldAccount = this.getWorldString(oldName);
        int oldBalance = this.getAccountBalance(oldAccount);
        this.delWorldData("\u00ef\u00bf\u00bd" + playerUID);
        this.delWorldData(oldName);
        this.delWorldData(oldAccount);
        if (this.getWorldString("\u00ef\u00bf\u00bd" + playerUID) == "") {
            String customAccountNumber = "none";
            while (this.getWorldString(customAccountNumber) == "") {
                customAccountNumber = String.valueOf(this.generateAccountNumber());
                if (this.getWorldString(customAccountNumber) == "") {
                    this.setWorldData("\u00ef\u00bf\u00bd" + playerUID, customAccountName);
                    this.setWorldData(customAccountName, customAccountNumber);
                    this.setWorldData(customAccountNumber, oldBalance);
                }
                if (this.getWorldString(oldAccount) == "") continue;
                this.delWorldData(oldAccount);
                this.delWorldData(oldName);
            }
        }
    }

    public void transferPlayerAccount(String playerUID) {
        String oldAccount = this.getWorldString(playerUID);
        int oldBalance = this.getAccountBalance(oldAccount);
        this.delWorldData(playerUID);
        if (this.getWorldString(playerUID) == "") {
            String accountNumber = "none";
            while (this.getWorldString(accountNumber) == "") {
                accountNumber = String.valueOf(this.generateAccountNumber());
                if (this.getWorldString(accountNumber) != "") continue;
                this.setWorldData(playerUID, accountNumber);
                this.setWorldData(accountNumber, oldBalance);
            }
        }
        this.delWorldData(oldAccount);
    }

    private int generateAccountNumber() {
        return (int)(Math.floor(Math.random() * 9.9999999E7) + 1.1111111E7);
    }

    private World getWorld() {
        return MinecraftServer.func_71276_C().field_71305_c[0];
    }

    private boolean hasKey(String tag) {
        UCWorldData wData = UCWorldData.get(this.getWorld());
        NBTTagCompound wdTag = wData.getData();
        return wdTag.func_74764_b(tag);
    }

    private void setWorldData(String tag, String data) {
        UCWorldData wData = UCWorldData.get(this.getWorld());
        NBTTagCompound wdTag = wData.getData();
        wdTag.func_74778_a(tag, data);
        wData.func_76185_a();
    }

    private void setWorldData(String tag, int data) {
        UCWorldData wData = UCWorldData.get(this.getWorld());
        NBTTagCompound wdTag = wData.getData();
        wdTag.func_74768_a(tag, data);
        wData.func_76185_a();
    }

    private int getWorldInt(String tag) {
        UCWorldData wData = UCWorldData.get(this.getWorld());
        NBTTagCompound wdTag = wData.getData();
        return wdTag.func_74762_e(tag);
    }

    private String getWorldString(String tag) {
        UCWorldData wData = UCWorldData.get(this.getWorld());
        NBTTagCompound wdTag = wData.getData();
        return wdTag.func_74779_i(tag);
    }

    private void delWorldData(String tag) {
        UCWorldData wData = UCWorldData.get(this.getWorld());
        NBTTagCompound wdTag = wData.getData();
        wdTag.func_82580_o(tag);
        wData.func_76185_a();
    }
}

