/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nightkosh.gravestone.ModGraveStone;
import nightkosh.gravestone.api.grave.EnumGraveType;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.Tabs;
import nightkosh.gravestone.core.logger.GSLogger;
import nightkosh.gravestone.helper.GraveGenerationHelper;
import nightkosh.gravestone.helper.GraveStoneHelper;
import nightkosh.gravestone.inventory.GraveInventory;
import nightkosh.gravestone.tileentity.TileEntityGraveStone;

public class BlockGraveStone
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockGraveStone() {
        super(Material.field_151576_e);
        this.field_149758_A = true;
        this.func_149672_a(Block.field_149769_e);
        this.func_149711_c(0.5f);
        this.func_149752_b(5.0f);
        this.func_149647_a(Tabs.gravesTab);
        this.func_149675_a(Config.removeEmptyGraves);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemStack) {
        NBTTagCompound nbt;
        GraveStoneHelper.replaceGround(world, pos.func_177977_b());
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        world.func_180501_a(pos, state, 2);
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)world.func_175625_s(pos);
        if (tileEntity != null && (nbt = itemStack.func_77978_p()) != null) {
            tileEntity.setGraveType(itemStack.func_77952_i());
            if (nbt.func_74764_b("isLocalized") && nbt.func_74767_n("isLocalized")) {
                tileEntity.getDeathTextComponent().setLocalized();
                if (nbt.func_74764_b("name") && nbt.func_74764_b("KillerName")) {
                    tileEntity.getDeathTextComponent().setName(nbt.func_74779_i("name"));
                    tileEntity.getDeathTextComponent().setKillerName(nbt.func_74779_i("KillerName"));
                }
            }
            tileEntity.getDeathTextComponent().setDeathText(nbt.func_74779_i("DeathText"));
            tileEntity.setAge(nbt.func_74762_e("Age"));
            tileEntity.setEnchanted(nbt.func_74767_n("Enchanted"));
            tileEntity.setMossy(nbt.func_74767_n("Mossy"));
            tileEntity.setPurified(nbt.func_74767_n("Purified"));
            if (nbt.func_74764_b("Sword")) {
                tileEntity.setSword(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Sword")));
            }
        }
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return GraveStoneHelper.canPlaceBlockAt(world, pos.func_177977_b());
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        return null;
    }

    public void func_180654_a(IBlockAccess access, BlockPos pos) {
        EnumFacing facing = (EnumFacing)access.func_180495_p(pos).func_177229_b((IProperty)FACING);
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)access.func_175625_s(pos);
        EnumGraveType graveType = tileEntity != null ? tileEntity.getGraveType().getGraveType() : EnumGraveType.VERTICAL_PLATE;
        block0 : switch (graveType) {
            case VERTICAL_PLATE: {
                switch (facing) {
                    case SOUTH: {
                        this.func_149676_a(0.125f, 0.0f, 0.0625f, 0.875f, 0.9375f, 0.1875f);
                        break;
                    }
                    case NORTH: {
                        this.func_149676_a(0.125f, 0.0f, 0.8125f, 0.875f, 0.9375f, 0.9375f);
                        break;
                    }
                    case EAST: {
                        this.func_149676_a(0.0625f, 0.0f, 0.125f, 0.1875f, 0.9375f, 0.875f);
                        break;
                    }
                    case WEST: {
                        this.func_149676_a(0.8125f, 0.0f, 0.125f, 0.9375f, 0.9375f, 0.875f);
                    }
                }
                break;
            }
            case CROSS: {
                switch (facing) {
                    case SOUTH: {
                        this.func_149676_a(0.125f, 0.0f, 0.0625f, 0.875f, 1.0f, 0.1875f);
                        break;
                    }
                    case NORTH: {
                        this.func_149676_a(0.125f, 0.0f, 0.8125f, 0.875f, 1.0f, 0.9375f);
                        break;
                    }
                    case EAST: {
                        this.func_149676_a(0.0625f, 0.0f, 0.125f, 0.1875f, 1.0f, 0.875f);
                        break;
                    }
                    case WEST: {
                        this.func_149676_a(0.8125f, 0.0f, 0.125f, 0.9375f, 1.0f, 0.875f);
                    }
                }
                break;
            }
            case CELTIC_CROSS: {
                switch (facing) {
                    case SOUTH: 
                    case NORTH: {
                        this.func_149676_a(0.125f, 0.0f, 0.35f, 0.875f, 1.3f, 0.65f);
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        this.func_149676_a(0.35f, 0.0f, 0.125f, 0.65f, 1.3f, 0.875f);
                    }
                }
                break;
            }
            case OBELISK: 
            case CREEPER_STATUE: 
            case VILLAGER_STATUE: {
                this.func_149676_a(0.35f, 0.0f, 0.35f, 0.65f, 0.92f, 0.65f);
                break;
            }
            case HORIZONTAL_PLATE: {
                switch (facing) {
                    case SOUTH: {
                        this.func_149676_a(0.09375f, 0.0f, 0.0625f, 0.90625f, 0.0625f, 0.9375f);
                        break;
                    }
                    case NORTH: {
                        this.func_149676_a(0.09375f, 0.0f, 0.0625f, 0.90625f, 0.0625f, 0.9375f);
                        break;
                    }
                    case EAST: {
                        this.func_149676_a(0.0625f, 0.0f, 0.09375f, 0.9375f, 0.0625f, 0.90625f);
                        break;
                    }
                    case WEST: {
                        this.func_149676_a(0.0625f, 0.0f, 0.09375f, 0.9375f, 0.0625f, 0.90625f);
                    }
                }
                break;
            }
            case DOG_STATUE: {
                switch (facing) {
                    case SOUTH: {
                        this.func_149676_a(0.35f, 0.0f, 0.3f, 0.6f, 0.5f, 0.9f);
                        break;
                    }
                    case NORTH: {
                        this.func_149676_a(0.35f, 0.0f, 0.7f, 0.6f, 0.5f, 0.1f);
                        break;
                    }
                    case EAST: {
                        this.func_149676_a(0.3f, 0.0f, 0.35f, 0.9f, 0.5f, 0.6f);
                        break;
                    }
                    case WEST: {
                        this.func_149676_a(0.7f, 0.0f, 0.35f, 0.1f, 0.5f, 0.6f);
                    }
                }
                break;
            }
            case CAT_STATUE: {
                switch (facing) {
                    case SOUTH: {
                        this.func_149676_a(0.43f, 0.0f, 0.3f, 0.57f, 0.5f, 0.75f);
                        break;
                    }
                    case NORTH: {
                        this.func_149676_a(0.43f, 0.0f, 0.7f, 0.57f, 0.5f, 0.25f);
                        break;
                    }
                    case EAST: {
                        this.func_149676_a(0.3f, 0.0f, 0.43f, 0.75f, 0.5f, 0.57f);
                        break;
                    }
                    case WEST: {
                        this.func_149676_a(0.7f, 0.0f, 0.43f, 0.25f, 0.5f, 0.57f);
                    }
                }
                break;
            }
            case STARVED_CORPSE: 
            case WITHERED_CORPSE: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.3f, 1.0f);
                break;
            }
            case SWORD: {
                switch (facing) {
                    case SOUTH: 
                    case NORTH: {
                        this.func_149676_a(0.375f, 0.0f, 0.4375f, 0.625f, 0.9f, 0.5625f);
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        this.func_149676_a(0.4375f, 0.0f, 0.375f, 0.5625f, 0.9f, 0.625f);
                    }
                }
                break;
            }
            case HORSE_STATUE: {
                switch (facing) {
                    case SOUTH: 
                    case NORTH: {
                        this.func_149676_a(0.375f, 0.0f, 0.275f, 0.625f, 0.85f, 0.725f);
                        break block0;
                    }
                    case EAST: 
                    case WEST: {
                        this.func_149676_a(0.275f, 0.0f, 0.375f, 0.725f, 0.85f, 0.625f);
                    }
                }
            }
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        player.func_71020_j(0.025f);
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)world.func_175625_s(pos);
        if (tileEntity != null && tileEntity.canBeLooted(player.func_110124_au().toString())) {
            GraveStoneHelper.spawnMob(world, pos);
            if (tileEntity.hasFlower()) {
                tileEntity.dropFlower();
            }
            if (EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
                GraveStoneHelper.dropBlock(world, pos, state);
            } else {
                GraveStoneHelper.dropBlockWithoutInfo(world, pos, state);
            }
        }
    }

    public List<ItemStack> getDrops(IBlockAccess access, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(GraveStoneHelper.getBlockItemStack(access, pos, state));
        return ret;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        GraveStoneHelper.spawnMob(world, pos);
    }

    public float func_149638_a(Entity entity) {
        return 1.8E7f;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityGraveStone te = (TileEntityGraveStone)world.func_175625_s(pos);
        if (te != null) {
            String deathText;
            if (player.field_71071_by.func_70448_g() != null) {
                ItemStack item = player.field_71071_by.func_70448_g();
                if (item.func_77973_b().getToolClasses(item).contains("shovel")) {
                    if (!world.field_72995_K) {
                        if (te.canBeLooted(player.func_110124_au().toString())) {
                            player.openGui((Object)ModGraveStone.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                            GSLogger.logInfoGrave(player.func_70005_c_() + " open grave inventory at " + pos.func_177958_n() + "/" + pos.func_177956_o() + "/" + pos.func_177952_p());
                            GraveStoneHelper.replaceGround(world, pos.func_177977_b());
                        } else {
                            player.func_146105_b(new ChatComponentTranslation("grave.cant_be_looted", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                        }
                    }
                    return false;
                }
                if (te.isMossy()) {
                    if (item.func_77973_b() instanceof ItemShears) {
                        if (!world.field_72995_K) {
                            GraveInventory.dropItem(new ItemStack(Blocks.field_150395_bd, 1), world, pos);
                        }
                        te.setMossy(false);
                        return false;
                    }
                } else if (!te.isSwordGrave() && Block.func_149634_a((Item)item.func_77973_b()) instanceof BlockVine) {
                    te.setMossy(true);
                    --player.field_71071_by.func_70448_g().field_77994_a;
                    return true;
                }
                if (te.hasFlower()) {
                    if (item.func_77973_b() instanceof ItemShears) {
                        if (!world.field_72995_K) {
                            te.dropFlower();
                        }
                        te.setFlower(null);
                        return false;
                    }
                } else if (GraveStoneHelper.FLOWERS.contains(Block.func_149634_a((Item)item.func_77973_b())) && GraveStoneHelper.canFlowerBePlaced(world, pos, item, te)) {
                    te.setFlower(new ItemStack(item.func_77973_b(), 1, item.func_77952_i()));
                    --player.field_71071_by.func_70448_g().field_77994_a;
                    return true;
                }
            }
            if (world.field_72995_K && (deathText = te.getDeathTextComponent().getDeathText()).length() != 0) {
                if (te.getDeathTextComponent().isLocalized()) {
                    String name = ModGraveStone.proxy.getLocalizedEntityName(te.getDeathTextComponent().getName());
                    String killerName = ModGraveStone.proxy.getLocalizedEntityName(te.getDeathTextComponent().getKillerName());
                    if (killerName.length() == 0) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name}));
                    } else {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[]{name, killerName}));
                    }
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(deathText, new Object[0]));
                }
                if (te.getAge() > 0) {
                    StringBuilder ageStr = new StringBuilder();
                    ageStr.append(ModGraveStone.proxy.getLocalizedString("item.grave.age")).append(" ").append(te.getAge()).append(" ").append(ModGraveStone.proxy.getLocalizedString("item.grave.days"));
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation(ageStr.toString(), new Object[0]));
                }
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int var2) {
        return new TileEntityGraveStone(world);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        GraveStoneHelper.replaceGround(world, pos.func_177977_b());
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)world.func_175625_s(pos);
        if (tileEntity != null) {
            tileEntity.getInventory().dropAllItems();
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block block) {
        TileEntityGraveStone te;
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.DOWN, true) && (te = (TileEntityGraveStone)world.func_175625_s(pos)) != null && te.canBeLooted("")) {
            GraveStoneHelper.dropBlockWithoutInfo(world, pos, state);
            world.func_175698_g(pos);
        }
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntityGraveStone te = (TileEntityGraveStone)world.func_175625_s(pos);
        if (te != null && !te.canBeLooted(player.func_110124_au().toString())) {
            player.func_146105_b(new ChatComponentTranslation("grave.cant_be_looted", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            return false;
        }
        return super.removedByPlayer(world, pos, player, willHarvest);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item gravestone, CreativeTabs tabs, List list) {
        for (int i = 0; i < EnumGraves.values().length - 1; ++i) {
            ItemStack stack = new ItemStack(gravestone, 1, i);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("Purified", false);
            stack.func_77982_d(nbt);
            list.add(stack);
        }
        for (Item sword : GraveGenerationHelper.swordsList) {
            list.add(GraveStoneHelper.getSwordAsGrave(gravestone, new ItemStack(sword, 1)));
        }
        for (Item sword : GraveGenerationHelper.swordsList) {
            try {
                ItemStack swordStack = new ItemStack(sword, 1);
                EnchantmentHelper.func_77504_a((Random)new Random(), (ItemStack)swordStack, (int)5);
                ItemStack graveStoneStack = GraveStoneHelper.getSwordAsGrave(gravestone, swordStack);
                list.add(graveStoneStack);
            }
            catch (IllegalArgumentException exception) {
                GSLogger.logError("Can't create enchanted sword gravestone");
                exception.printStackTrace();
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos) {
        ItemStack itemStack = this.func_180643_i(this.func_176223_P());
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)world.func_175625_s(pos);
        if (tileEntity != null && itemStack != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            itemStack.func_77964_b(tileEntity.getGraveTypeNum());
            nbt.func_74757_a("Mossy", tileEntity.isMossy());
            itemStack.func_77982_d(nbt);
            if (tileEntity.isSwordGrave()) {
                GraveStoneHelper.addSwordInfo(nbt, tileEntity.getSword());
            }
        }
        return itemStack;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        TileEntityGraveStone tileEntity;
        if (Config.removeEmptyGraves && !world.field_72995_K && (tileEntity = (TileEntityGraveStone)world.func_175625_s(pos)) != null && !tileEntity.isSwordGrave() && tileEntity.isEmpty()) {
            if (Config.showGravesRemovingMessages) {
                GSLogger.logInfoGrave("Remove empty grave at " + pos.func_177958_n() + "/" + pos.func_177956_o() + "/" + pos.func_177952_p());
            }
            world.func_175713_t(pos);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1);
    }
}

