/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.core.commands;

import java.util.ArrayList;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import nightkosh.gravestone.core.commands.ISubCommand;
import nightkosh.gravestone.core.logger.GSLogger;
import nightkosh.gravestone.tileentity.TileEntityGraveStone;

public class SubCommandCustomGraveItems
implements ISubCommand {
    public static final String COMMAND_NAME = "fill_grave";
    public static final String COMMAND_USAGE = "/GS fill_grave <grave x coordinate> <grave y coordinate> <grave z coordinate>  <chest x coordinate> <chest y coordinate> <chest z coordinate>";

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getCommandUsage() {
        return COMMAND_USAGE;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        block8: {
            GSLogger.logInfo("Custom grave items command received");
            if (args.length >= 7) {
                try {
                    int graveXCoord = Integer.parseInt(args[1]);
                    int graveYCoord = Integer.parseInt(args[2]);
                    int graveZCoord = Integer.parseInt(args[3]);
                    int chestXCoord = Integer.parseInt(args[4]);
                    int chestYCoord = Integer.parseInt(args[5]);
                    int chestZCoord = Integer.parseInt(args[6]);
                    TileEntity graveTE = sender.func_130014_f_().func_175625_s(new BlockPos(graveXCoord, graveYCoord, graveZCoord));
                    TileEntity chestTE = sender.func_130014_f_().func_175625_s(new BlockPos(chestXCoord, chestYCoord, chestZCoord));
                    if (graveTE != null && chestTE != null) {
                        if (graveTE instanceof TileEntityGraveStone && chestTE instanceof TileEntityChest) {
                            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                            for (int slot = 0; slot < ((TileEntityChest)chestTE).func_70302_i_(); ++slot) {
                                ItemStack item = ((TileEntityChest)chestTE).func_70301_a(slot);
                                if (item == null) continue;
                                items.add(item.func_77946_l());
                            }
                            ((TileEntityGraveStone)graveTE).getInventory().setAdditionalItems(items.toArray(new ItemStack[items.size()]));
                        } else {
                            sender.func_145747_a(new ChatComponentTranslation("commands.fill_grave.wrong_block", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                        }
                        break block8;
                    }
                    sender.func_145747_a(new ChatComponentTranslation("commands.fill_grave.empty", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a(new ChatComponentTranslation("commands.coordinate_error", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                }
            } else {
                sender.func_145747_a(new ChatComponentTranslation("commands.not_enough_parameters", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            }
        }
    }
}

