/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.core.event;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nightkosh.gravestone.api.death_handler.ICatDeathHandler;
import nightkosh.gravestone.api.death_handler.ICustomEntityDeathHandler;
import nightkosh.gravestone.api.death_handler.IDogDeathHandler;
import nightkosh.gravestone.api.death_handler.IHorseDeathHandler;
import nightkosh.gravestone.api.death_handler.IPlayerDeathHandler;
import nightkosh.gravestone.api.death_handler.IVillagerDeathHandler;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.MobHandler;
import nightkosh.gravestone.core.logger.GravesLogger;
import nightkosh.gravestone.helper.GraveGenerationHelper;
import nightkosh.gravestone.helper.api.APIGraveGeneration;

public class EventsHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityLivingDeath(LivingDeathEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            if (!Config.generateGravesInLava && event.source.field_76373_n.equals("lava")) {
                return;
            }
            if (Config.generatePlayerGraves && event.entityLiving instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.entity;
                for (IPlayerDeathHandler playerDeathHandler : APIGraveGeneration.PLAYER_DEATH_HANDLERS) {
                    if (!playerDeathHandler.cancelGraveGeneration(player, event.source)) continue;
                    return;
                }
                GraveGenerationHelper.createPlayerGrave(player, event, MobHandler.getAndRemoveSpawnTime(event.entity));
                return;
            }
            if (Config.generateVillagerGraves && event.entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)event.entity;
                for (IVillagerDeathHandler villagerDeathHandler : APIGraveGeneration.VILLAGER_DEATH_HANDLERS) {
                    if (!villagerDeathHandler.cancelGraveGeneration(villager, event.source)) continue;
                    return;
                }
                GraveGenerationHelper.createVillagerGrave(villager, event);
                return;
            }
            if (Config.generatePetGraves) {
                if (event.entity instanceof EntityTameable) {
                    if (event.entity instanceof EntityWolf) {
                        EntityWolf dog = (EntityWolf)event.entity;
                        for (IDogDeathHandler dogDeathHandler : APIGraveGeneration.DOG_DEATH_HANDLERS) {
                            if (!dogDeathHandler.cancelGraveGeneration(dog, event.source)) continue;
                            return;
                        }
                        GraveGenerationHelper.createDogGrave(dog, event);
                        return;
                    }
                    if (event.entity instanceof EntityOcelot) {
                        EntityOcelot cat = (EntityOcelot)event.entity;
                        for (ICatDeathHandler catDeathHandler : APIGraveGeneration.CAT_DEATH_HANDLERS) {
                            if (!catDeathHandler.cancelGraveGeneration(cat, event.source)) continue;
                            return;
                        }
                        GraveGenerationHelper.createCatGrave(cat, event);
                        return;
                    }
                } else if (event.entity instanceof EntityHorse) {
                    EntityHorse horse = (EntityHorse)event.entity;
                    for (IHorseDeathHandler horseDeathHandler : APIGraveGeneration.HORSE_DEATH_HANDLERS) {
                        if (!horseDeathHandler.cancelGraveGeneration(horse, event.source)) continue;
                        return;
                    }
                    GraveGenerationHelper.createHorseGrave(horse, event);
                    return;
                }
            }
            for (ICustomEntityDeathHandler customEntityDeathHandler : APIGraveGeneration.CUSTOM_ENTITY_DEATH_HANDLERS) {
                if (!event.entity.getClass().equals(customEntityDeathHandler.getEntityClass()) || !customEntityDeathHandler.canGenerateGrave(event.entity, event.source)) continue;
                GraveGenerationHelper.createCustomGrave(event.entity, event, customEntityDeathHandler);
                return;
            }
        }
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && ((entity = event.entity) instanceof EntityVillager || entity instanceof EntityWolf || entity instanceof EntityOcelot || entity instanceof EntityHorse)) {
            MobHandler.setMobSpawnTime(event.entity);
        }
    }

    @SubscribeEvent
    public void worldLoading(WorldEvent.Load event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            MobHandler.loadMobsSpawnTime(event.world);
            GravesLogger.setWorldDirectory(event.world.func_72860_G().func_75765_b());
        }
    }
}

