/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.core.event;

import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.TimeHelper;
import org.lwjgl.opengl.GL11;

public class RenderEventHandler {
    public static float fogDensityPerTick = 0.0f;
    private static float fogDensity = 0.0f;
    public static final float MAX_DENSITY = 0.08f;
    public static final float DENSITY_PER_GRAVE = 0.001f;
    public static final float DENSITY_PER_TICK = 5.0E-6f;
    private static int amountOfFogSources = 0;

    public static void addFog() {
        ++amountOfFogSources;
        RenderEventHandler.updateFogDensity();
    }

    public static void resetAmountOfFogSources(World world) {
        amountOfFogSources = 0;
        if (fogDensityPerTick != 0.0f && !TimeHelper.isFogTime(world)) {
            fogDensityPerTick = 0.0f;
        }
    }

    private static void updateFogDensity() {
        fogDensityPerTick = 0.001f * (float)amountOfFogSources;
        if (fogDensityPerTick > 0.08f) {
            fogDensityPerTick = 0.08f;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fogEvent(EntityViewRenderEvent.RenderFogEvent event) {
        if (Config.isFogEnabled) {
            if (fogDensity < fogDensityPerTick) {
                fogDensity += 5.0E-6f;
            } else if (fogDensity > fogDensityPerTick) {
                fogDensity -= 5.0E-6f;
            }
            if (fogDensity < 5.0E-6f) {
                fogDensity = 0.0f;
            }
            if (fogDensity > 0.0f) {
                GL11.glFogi((int)2917, (int)2048);
                GL11.glFogf((int)2914, (float)fogDensity);
            }
        }
    }
}

