/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import nightkosh.gravestone.api.IGraveStoneHelper;
import nightkosh.gravestone.api.death_handler.ICustomEntityDeathHandler;
import nightkosh.gravestone.api.grave.EnumGraveMaterial;
import nightkosh.gravestone.api.grave.EnumGraveType;
import nightkosh.gravestone.api.grave_items.ICatItems;
import nightkosh.gravestone.api.grave_items.IDogItems;
import nightkosh.gravestone.api.grave_items.IHorseItems;
import nightkosh.gravestone.api.grave_items.IPlayerItems;
import nightkosh.gravestone.api.grave_items.IVillagerItems;
import nightkosh.gravestone.block.BlockGraveStone;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.GSBlock;
import nightkosh.gravestone.core.MobHandler;
import nightkosh.gravestone.core.compatibility.CompatibilityBattlegear;
import nightkosh.gravestone.core.compatibility.CompatibilityTwilightForest;
import nightkosh.gravestone.core.logger.GSLogger;
import nightkosh.gravestone.helper.GraveStoneHelper;
import nightkosh.gravestone.helper.api.APIGraveGeneration;
import nightkosh.gravestone.inventory.GraveInventory;
import nightkosh.gravestone.tileentity.DeathMessageInfo;
import nightkosh.gravestone.tileentity.TileEntityGraveStone;

public class GraveGenerationHelper
implements IGraveStoneHelper {
    public static final IGraveStoneHelper INSTANCE = new GraveGenerationHelper();
    protected static final Random rand = new Random();
    public static ArrayList<Item> swordsList = new ArrayList<Item>(Arrays.asList(Items.field_151041_m, Items.field_151052_q, Items.field_151040_l, Items.field_151010_B, Items.field_151048_u));
    private static final EnumGraveType[] GENERATED_PLAYER_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.VERTICAL_PLATE, EnumGraveType.CROSS, EnumGraveType.OBELISK, EnumGraveType.CELTIC_CROSS, EnumGraveType.HORIZONTAL_PLATE};
    private static final EnumGraveType[] STARVED_PLAYER_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.STARVED_CORPSE};
    private static final EnumGraveType[] WITHERED_PLAYER_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.WITHERED_CORPSE};
    private static final EnumGraveType[] GENERATED_VILLAGERS_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.VILLAGER_STATUE};
    private static final EnumGraveType[] GENERATED_DOGS_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.DOG_STATUE};
    private static final EnumGraveType[] GENERATED_CAT_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.CAT_STATUE};
    private static final EnumGraveType[] GENERATED_HORSE_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.HORSE_STATUE};
    private static final EnumGraveType[] GENERATED_CREEPER_STATUES_GRAVES_TYPES = new EnumGraveType[]{EnumGraveType.CREEPER_STATUE};

    @Override
    public void addSwordToSwordsList(Item sword) {
        if (sword != null) {
            swordsList.add(sword);
        }
    }

    public static void createPlayerGrave(EntityPlayer player, LivingDeathEvent event, long spawnTime) {
        if (player.field_70170_p != null && !player.field_70170_p.func_82736_K().func_82766_b("keepInventory") && Config.graveItemsCount > 0 && !GraveGenerationHelper.isInRestrictedArea(player.func_180425_c())) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>(40);
            items.addAll(Arrays.asList(player.field_71071_by.field_70462_a));
            items.addAll(Arrays.asList(player.field_71071_by.field_70460_b));
            CompatibilityTwilightForest.addSlotTags(items);
            CompatibilityBattlegear.addItems(items, player);
            if (!CompatibilityTwilightForest.handleCharmsOfKeeping(items, player)) {
                player.field_71071_by.func_174888_l();
            }
            for (IPlayerItems additionalItems : APIGraveGeneration.PLAYER_ITEMS) {
                items.addAll(additionalItems.addItems(player, event.source));
            }
            CompatibilityTwilightForest.removeSlotTags(items);
            for (IPlayerItems additionalItems : APIGraveGeneration.PLAYER_ITEMS) {
                additionalItems.getItems(player, event.source, items);
            }
            GraveGenerationHelper.createGrave((Entity)player, event, items, EnumGraveTypeByEntity.PLAYER_GRAVES, false, spawnTime);
        } else {
            GraveGenerationHelper.createGrave((Entity)player, event, null, EnumGraveTypeByEntity.PLAYER_GRAVES, false, spawnTime);
        }
    }

    public static void createVillagerGrave(EntityVillager villager, LivingDeathEvent event) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(5);
        for (IVillagerItems additionalItems : APIGraveGeneration.VILLAGER_ITEMS) {
            items.addAll(additionalItems.addItems(villager, event.source));
        }
        long spawnTime = MobHandler.getAndRemoveSpawnTime(event.entity);
        GraveGenerationHelper.createGrave((Entity)villager, event, items, EnumGraveTypeByEntity.VILLAGERS_GRAVES, true, spawnTime);
    }

    public static void createDogGrave(EntityWolf dog, LivingDeathEvent event) {
        if (dog.func_70909_n()) {
            long spawnTime = MobHandler.getAndRemoveSpawnTime(event.entity);
            GraveGenerationHelper.createGrave((Entity)dog, event, GraveGenerationHelper.getDogsItems(dog, event), EnumGraveTypeByEntity.DOGS_GRAVES, false, spawnTime);
        }
    }

    public static void createCatGrave(EntityOcelot cat, LivingDeathEvent event) {
        if (cat.func_70909_n()) {
            long spawnTime = MobHandler.getAndRemoveSpawnTime(event.entity);
            GraveGenerationHelper.createGrave((Entity)cat, event, GraveGenerationHelper.getCatsItems(cat, event), EnumGraveTypeByEntity.CATS_GRAVES, false, spawnTime);
        }
    }

    private static List<ItemStack> getDogsItems(EntityWolf dog, LivingDeathEvent event) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(5);
        for (IDogItems additionalItems : APIGraveGeneration.DOG_ITEMS) {
            items.addAll(additionalItems.addItems(dog, event.source));
        }
        return items;
    }

    private static List<ItemStack> getCatsItems(EntityOcelot cat, LivingDeathEvent event) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(5);
        for (ICatItems additionalItems : APIGraveGeneration.CAT_ITEMS) {
            items.addAll(additionalItems.addItems(cat, event.source));
        }
        return items;
    }

    public static void createHorseGrave(EntityHorse horse, LivingDeathEvent event) {
        if (horse.func_110248_bS()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.addAll(GraveGenerationHelper.getHorseItems(horse));
            for (IHorseItems additionalItems : APIGraveGeneration.HORSE_ITEMS) {
                items.addAll(additionalItems.addItems(horse, event.source));
            }
            long spawnTime = MobHandler.getAndRemoveSpawnTime(event.entity);
            GraveGenerationHelper.createGrave((Entity)horse, event, items, EnumGraveTypeByEntity.HORSE_GRAVES, false, spawnTime);
        }
    }

    private static List<ItemStack> getHorseItems(EntityHorse horse) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        NBTTagCompound nbt = new NBTTagCompound();
        horse.func_70014_b(nbt);
        NBTTagList nbtItemsList = nbt.func_150295_c("Items", 10);
        if (Config.storeHorseSaddleAndArmor) {
            if (horse.func_110257_ck()) {
                items.add(new ItemStack(Items.field_151141_av));
                nbt.func_82580_o("SaddleItem");
                horse.field_110296_bG.func_70299_a(0, null);
            }
            if (nbt.func_150297_b("ArmorItem", 10)) {
                items.add(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("ArmorItem")));
                nbt.func_82580_o("ArmorItem");
                horse.field_110296_bG.func_70299_a(1, null);
            }
        }
        if (horse.func_110261_ca()) {
            for (int i = 0; i < nbtItemsList.func_74745_c(); ++i) {
                items.add(ItemStack.func_77949_a((NBTTagCompound)nbtItemsList.func_150305_b(i)));
            }
            items.add(new ItemStack((Block)Blocks.field_150486_ae));
        }
        nbtItemsList = new NBTTagList();
        for (int slot = 2; slot < 17; ++slot) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74774_a("Slot", (byte)slot);
            new ItemStack(Blocks.field_150350_a).func_77955_b(nbtTagCompound);
            nbtItemsList.func_74742_a((NBTBase)nbtTagCompound);
        }
        nbt.func_82580_o("Items");
        nbt.func_74782_a("Items", (NBTBase)nbtItemsList);
        horse.func_70037_a(nbt);
        horse.func_110207_m(false);
        return items;
    }

    public static void createGrave(Entity entity, LivingDeathEvent event, List<ItemStack> items, EnumGraveTypeByEntity graveTypeByEntity, boolean isVillager, long spawnTime) {
        if (GraveGenerationHelper.isInRestrictedArea(entity.func_180425_c())) {
            GSLogger.logInfo("Can't generate " + entity.func_70005_c_() + "'s grave in restricted area. " + entity.func_180425_c().toString());
            if (items != null) {
                items.stream().filter(item -> item != null).forEach(item -> GraveInventory.dropItem(item, entity.field_70170_p, entity.func_180425_c()));
            }
        } else {
            int age = (int)(entity.field_70170_p.func_72820_D() - spawnTime) / 24000;
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v - 1.0);
            GraveInfoOnDeath graveInfo = GraveGenerationHelper.getGraveOnDeath(entity.field_70170_p, pos, entity, graveTypeByEntity, items, age, event.source);
            DeathMessageInfo messageInfo = GraveGenerationHelper.getDeathMessage((EntityLivingBase)entity, event.source.field_76373_n, isVillager);
            GraveGenerationHelper.createOnDeath(entity, entity.field_70170_p, pos, messageInfo, items, age, graveInfo, event.source);
        }
    }

    public static void createCustomGrave(Entity entity, LivingDeathEvent event, ICustomEntityDeathHandler customEntityDeathHandler) {
        if (GraveGenerationHelper.isInRestrictedArea(entity.func_180425_c())) {
            GSLogger.logInfo("Can't generate " + entity.func_70005_c_() + "'s grave in restricted area. " + entity.func_180425_c().toString());
            if (customEntityDeathHandler.getItems() != null) {
                customEntityDeathHandler.getItems().stream().filter(item -> item != null).forEach(item -> GraveInventory.dropItem(item, entity.field_70170_p, entity.func_180425_c()));
            }
        } else {
            int age = customEntityDeathHandler.getAge();
            GraveInfoOnDeath graveInfo = new GraveInfoOnDeath();
            graveInfo.setGrave(EnumGraves.getByTypeAndMaterial(customEntityDeathHandler.getGraveType(entity, event.source), customEntityDeathHandler.getGraveMaterial(entity, event.source)));
            graveInfo.setSword(customEntityDeathHandler.getSword());
            graveInfo.setEnchanted(customEntityDeathHandler.isEnchanted(entity, event.source));
            graveInfo.setMossy(customEntityDeathHandler.isMossy(entity, event.source));
            BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v - 1.0);
            DeathMessageInfo messageInfo = GraveGenerationHelper.getDeathMessage((EntityLivingBase)entity, event.source.field_76373_n, false);
            GraveGenerationHelper.createOnDeath(entity, entity.field_70170_p, pos, messageInfo, customEntityDeathHandler.getItems(), age, graveInfo, event.source);
        }
    }

    private static GraveInfoOnDeath getGraveOnDeath(World world, BlockPos pos, Entity entity, EnumGraveTypeByEntity graveTypeByEntity, List<ItemStack> items, int age, DamageSource damageSource) {
        GraveInfoOnDeath graveInfo = new GraveInfoOnDeath();
        if (GraveGenerationHelper.chooseGraveTypeByAgeOrLevel(entity, graveTypeByEntity, age)) {
            EnumGraveMaterial material = GraveGenerationHelper.getGraveMaterialByAgeOrLevel(entity, age, graveTypeByEntity);
            EnumGraveType[] type = GraveGenerationHelper.isExplosionDamage(damageSource) ? GENERATED_CREEPER_STATUES_GRAVES_TYPES : GraveGenerationHelper.getDefaultGraveTypes(graveTypeByEntity);
            graveInfo.grave = GraveGenerationHelper.getGraveType(type, material);
        } else {
            graveInfo.grave = GraveGenerationHelper.getGraveByDeath(damageSource, graveTypeByEntity, entity, age);
            if (graveInfo.grave == null) {
                ItemStack sword;
                if (graveTypeByEntity == EnumGraveTypeByEntity.PLAYER_GRAVES && Config.generateSwordGraves && world.field_73012_v.nextInt(4) == 0 && graveTypeByEntity.equals((Object)EnumGraveTypeByEntity.PLAYER_GRAVES) && (sword = GraveGenerationHelper.getSwordFromInventory(items)) != null) {
                    graveInfo.sword = sword;
                    graveInfo.grave = EnumGraves.SWORD;
                }
                if (graveInfo.grave == null) {
                    graveInfo.grave = GraveGenerationHelper.getGraveTypeByBiomes(world, pos, graveTypeByEntity, damageSource);
                }
            }
        }
        graveInfo.setMossy(GraveGenerationHelper.isMossyGrave(world, pos, graveInfo.grave));
        graveInfo.setEnchanted(INSTANCE.isMagicDamage(damageSource));
        return graveInfo;
    }

    private static void createOnDeath(Entity entity, World world, BlockPos pos, DeathMessageInfo deathInfo, List<ItemStack> items, int age, GraveInfoOnDeath graveInfo, DamageSource damageSource) {
        EnumFacing direction = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3));
        BlockPos newPos = GraveGenerationHelper.findPlaceForGrave(world, pos);
        if (newPos != null) {
            world.func_180501_a(newPos, GSBlock.graveStone.func_176223_P().func_177226_a((IProperty)BlockGraveStone.FACING, (Comparable)direction), 2);
            TileEntityGraveStone tileEntity = (TileEntityGraveStone)world.func_175625_s(newPos);
            if (tileEntity != null) {
                if (graveInfo.getSword() != null) {
                    tileEntity.setSword(graveInfo.getSword());
                }
                tileEntity.getDeathTextComponent().setLocalized();
                tileEntity.getDeathTextComponent().setName(deathInfo.getName());
                tileEntity.getDeathTextComponent().setDeathText(deathInfo.getDeathMessage());
                tileEntity.getDeathTextComponent().setKillerName(deathInfo.getKillerName());
                tileEntity.getInventory().setItems(items);
                tileEntity.setGraveType(graveInfo.getGrave().ordinal());
                tileEntity.setAge(age);
                tileEntity.setEnchanted(graveInfo.isEnchanted());
                tileEntity.setMossy(graveInfo.isMossy());
                if (entity instanceof EntityPlayer) {
                    tileEntity.setOwner(entity.func_110124_au().toString());
                } else if (entity instanceof EntityTameable && ((EntityTameable)entity).func_70909_n()) {
                    tileEntity.setOwner(((EntityTameable)entity).func_70902_q().func_110124_au().toString());
                }
            }
            GSLogger.logInfoGrave("Create " + deathInfo.getName() + "'s grave at " + newPos.func_177958_n() + "x" + newPos.func_177956_o() + "x" + newPos.func_177952_p());
        } else {
            ItemStack itemStack = GSBlock.graveStone.func_180643_i(GSBlock.graveStone.func_176223_P());
            itemStack.func_77964_b(graveInfo.getGrave().ordinal());
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("isLocalized", true);
            nbt.func_74778_a("name", deathInfo.getName());
            nbt.func_74778_a("DeathText", deathInfo.getDeathMessage());
            nbt.func_74778_a("KillerName", deathInfo.getKillerNameForTE());
            nbt.func_74757_a("Enchanted", graveInfo.isEnchanted());
            nbt.func_74757_a("Mossy", graveInfo.isMossy());
            nbt.func_74768_a("Age", age);
            if (graveInfo.getGrave() == EnumGraves.SWORD) {
                GraveStoneHelper.addSwordInfo(nbt, graveInfo.getSword());
            }
            itemStack.func_77982_d(nbt);
            GraveInventory.dropItem(itemStack, world, pos);
            if (items != null) {
                for (ItemStack item : items) {
                    if (item == null) continue;
                    GraveInventory.dropItem(item, world, pos);
                }
            }
            GSLogger.logInfoGrave("Can not create " + deathInfo.getName() + "'s grave at " + pos.func_177958_n() + "x" + pos.func_177956_o() + "x" + pos.func_177952_p());
        }
    }

    private static DeathMessageInfo getDeathMessage(EntityLivingBase entity, String damageType, boolean isVillager) {
        EntityLivingBase killer = entity.func_94060_bK();
        String shortString = "death.attack." + damageType;
        String fullString = shortString + ".player";
        String entityName = entity.func_70005_c_();
        if (entityName == null) {
            entityName = "entity." + EntityList.func_75621_b((Entity)entity) + ".name";
        }
        if (killer != null) {
            String killerName;
            if (killer instanceof EntityPlayer) {
                killerName = killer.func_145748_c_().func_150254_d();
                if (isVillager) {
                    GSLogger.logInfoGrave("Villager was killed by " + killerName);
                }
            } else {
                killerName = EntityList.func_75621_b((Entity)killer);
                killerName = killerName == null ? "entity.generic.name" : "entity." + killerName + ".name";
            }
            if (StatCollector.func_94522_b((String)fullString)) {
                return new DeathMessageInfo(entityName, fullString, killerName);
            }
            return new DeathMessageInfo(entityName, shortString, killerName);
        }
        return new DeathMessageInfo(entityName, shortString, null);
    }

    private static boolean isInRestrictedArea(BlockPos pos) {
        return Config.restrictGraveGenerationInArea.stream().anyMatch(area -> area.isInArea(pos));
    }

    @Override
    public boolean isMagicDamage(DamageSource damageSource) {
        return DamageSource.field_76376_m.equals(damageSource) || damageSource.field_76373_n.toLowerCase().contains("magic");
    }

    @Override
    public boolean isMossyGrave(World world, BlockPos pos, EnumGraveMaterial graveMaterial, EnumGraveType graveType) {
        return GraveGenerationHelper.isMossyGrave(world, pos, EnumGraves.getByTypeAndMaterial(graveType, graveMaterial));
    }

    public static boolean isMossyGrave(World world, BlockPos pos, EnumGraves grave) {
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)world.func_180494_b(pos))));
        return grave.getMaterial() != EnumGraveMaterial.OTHER && (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP));
    }

    public static boolean chooseGraveTypeByAgeOrLevel(Entity entity, EnumGraveTypeByEntity graveTypeByEntity, int age) {
        if (graveTypeByEntity == EnumGraveTypeByEntity.PLAYER_GRAVES) {
            return ((EntityPlayer)entity).field_71068_ca >= 15;
        }
        return age >= 30;
    }

    public static EnumGraveMaterial getGraveMaterialByAgeOrLevel(Entity entity, int age, EnumGraveTypeByEntity graveTypeByEntity) {
        if (graveTypeByEntity == EnumGraveTypeByEntity.PLAYER_GRAVES) {
            return INSTANCE.getGraveMaterialByLevel(((EntityPlayer)entity).field_71068_ca);
        }
        return INSTANCE.getGraveMaterialByAge(age);
    }

    @Override
    public EnumGraveMaterial getGraveMaterialByLevel(int level) {
        if (level >= 65) {
            return EnumGraveMaterial.EMERALD;
        }
        if (level >= 55) {
            return EnumGraveMaterial.DIAMOND;
        }
        if (level >= 45) {
            return EnumGraveMaterial.REDSTONE;
        }
        if (level >= 35) {
            return EnumGraveMaterial.GOLD;
        }
        if (level >= 25) {
            return EnumGraveMaterial.LAPIS;
        }
        return EnumGraveMaterial.IRON;
    }

    @Override
    public EnumGraveMaterial getGraveMaterialByAge(int age) {
        if (age > 180) {
            return EnumGraveMaterial.EMERALD;
        }
        if (age > 150) {
            return EnumGraveMaterial.DIAMOND;
        }
        if (age > 120) {
            return EnumGraveMaterial.REDSTONE;
        }
        if (age > 90) {
            return EnumGraveMaterial.GOLD;
        }
        if (age > 60) {
            return EnumGraveMaterial.LAPIS;
        }
        return EnumGraveMaterial.IRON;
    }

    protected static EnumGraveType[] getDefaultGraveTypes(EnumGraveTypeByEntity graveTypeByEntity) {
        switch (graveTypeByEntity) {
            case VILLAGERS_GRAVES: {
                return GENERATED_VILLAGERS_GRAVES_TYPES;
            }
            case DOGS_GRAVES: {
                return GENERATED_DOGS_GRAVES_TYPES;
            }
            case CATS_GRAVES: {
                return GENERATED_CAT_GRAVES_TYPES;
            }
            case HORSE_GRAVES: {
                return GENERATED_HORSE_GRAVES_TYPES;
            }
        }
        return GENERATED_PLAYER_GRAVES_TYPES;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EnumGraves getGraveByDeath(DamageSource damageSource, EnumGraveTypeByEntity graveTypeByEntity, Entity entity, int age) {
        EnumGraveMaterial material;
        EnumGraveType[] graveTypes = null;
        if (GraveGenerationHelper.isFireDamage(damageSource, damageSource.field_76373_n) || GraveGenerationHelper.isLavaDamage(damageSource, damageSource.field_76373_n)) {
            material = EnumGraveMaterial.OBSIDIAN;
        } else {
            if (graveTypeByEntity != EnumGraveTypeByEntity.PLAYER_GRAVES) return null;
            if (DamageSource.field_76366_f.equals(damageSource)) {
                graveTypes = STARVED_PLAYER_GRAVES_TYPES;
                material = EnumGraveMaterial.OTHER;
            } else {
                if (!DamageSource.field_82727_n.equals(damageSource)) return null;
                graveTypes = WITHERED_PLAYER_GRAVES_TYPES;
                material = EnumGraveMaterial.OTHER;
            }
        }
        if (graveTypes != null) return GraveGenerationHelper.getGraveType(graveTypes, material);
        graveTypes = GraveGenerationHelper.getDefaultGraveTypes(graveTypeByEntity);
        return GraveGenerationHelper.getGraveType(graveTypes, material);
    }

    private static boolean isFireDamage(DamageSource damageSource, String damageType) {
        return DamageSource.field_76372_a.equals(damageSource) || DamageSource.field_76370_b.equals(damageSource) || damageType.toLowerCase().contains("nFire");
    }

    private static boolean isLavaDamage(DamageSource damageSource, String damageType) {
        return DamageSource.field_76371_c.equals(damageSource) || damageType.toLowerCase().contains("lava");
    }

    private static boolean isExplosionDamage(DamageSource damageSource) {
        return GraveGenerationHelper.isBlastDamage(damageSource.field_76373_n) || GraveGenerationHelper.isFireballDamage(damageSource.field_76373_n);
    }

    private static boolean isBlastDamage(String damageType) {
        return damageType.toLowerCase().contains("explosion");
    }

    private static boolean isFireballDamage(String damageType) {
        return damageType.toLowerCase().contains("fireball");
    }

    public static EnumGraves getGraveTypeByBiomes(World world, BlockPos pos, EnumGraveTypeByEntity graveTypeByEntity, DamageSource damageSource) {
        ArrayList<BiomeDictionary.Type> biomeTypesList = new ArrayList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)world.func_180494_b(pos))));
        ArrayList<EnumGraveMaterial> materials = new ArrayList<EnumGraveMaterial>();
        if (biomeTypesList.contains(BiomeDictionary.Type.SANDY) || biomeTypesList.contains(BiomeDictionary.Type.BEACH)) {
            materials.add(EnumGraveMaterial.SANDSTONE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.JUNGLE) || biomeTypesList.contains(BiomeDictionary.Type.SWAMP)) {
            materials.add(EnumGraveMaterial.STONE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MOUNTAIN)) {
            materials.add(EnumGraveMaterial.GRANITE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.HILLS)) {
            materials.add(EnumGraveMaterial.ANDESITE);
            materials.add(EnumGraveMaterial.DIORITE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.PLAINS) || biomeTypesList.contains(BiomeDictionary.Type.MUSHROOM)) {
            materials.add(EnumGraveMaterial.STONE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.FOREST)) {
            materials.add(EnumGraveMaterial.WOOD);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.SNOWY)) {
            materials.add(EnumGraveMaterial.ICE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.NETHER)) {
            materials.add(EnumGraveMaterial.QUARTZ);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.MESA)) {
            materials.add(EnumGraveMaterial.RED_SANDSTONE);
        }
        if (biomeTypesList.contains(BiomeDictionary.Type.WATER)) {
            materials.add(EnumGraveMaterial.PRIZMARINE);
        }
        if (materials.isEmpty()) {
            materials.add(EnumGraveMaterial.STONE);
        }
        EnumGraveType[] type = damageSource != null && GraveGenerationHelper.isExplosionDamage(damageSource) ? GENERATED_CREEPER_STATUES_GRAVES_TYPES : GraveGenerationHelper.getDefaultGraveTypes(graveTypeByEntity);
        EnumGraveMaterial[] materialsArray = new EnumGraveMaterial[materials.size()];
        materialsArray = materials.toArray(materialsArray);
        return GraveGenerationHelper.getGraveType(type, materialsArray);
    }

    private static BlockPos findPlaceForGrave(World world, BlockPos pos) {
        int z;
        int y;
        int newY;
        int x = pos.func_177958_n();
        if (GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(x, newY = GraveGenerationHelper.getGround(world, x, y = pos.func_177956_o(), z = pos.func_177952_p()), z))) {
            return new BlockPos(x, newY, z);
        }
        int dx = 1;
        int dz = 1;
        while (Math.abs(dx) < 9 && Math.abs(dz) < 9) {
            int newZ;
            int newX;
            if (dx < 0) {
                for (newX = x - 1; newX >= x + dx; --newX) {
                    newY = GraveGenerationHelper.getGround(world, newX, y, z);
                    if (!GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(newX, newY, z))) continue;
                    return new BlockPos(newX, newY, z);
                }
            } else {
                for (newX = x + 1; newX <= x + dx; ++newX) {
                    newY = GraveGenerationHelper.getGround(world, newX, y, z);
                    if (!GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(newX, newY, z))) continue;
                    return new BlockPos(newX, newY, z);
                }
            }
            x += dx;
            if (dz < 0) {
                for (newZ = z - 1; newZ >= z + dz; --newZ) {
                    newY = GraveGenerationHelper.getGround(world, x, y, newZ);
                    if (!GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(x, newY, newZ))) continue;
                    return new BlockPos(x, newY, newZ);
                }
            } else {
                for (newZ = z + 1; newZ <= z + dz; ++newZ) {
                    newY = GraveGenerationHelper.getGround(world, x, y, newZ);
                    if (!GraveGenerationHelper.canGenerateGraveAtCoordinates(world, new BlockPos(x, newY, newZ))) continue;
                    return new BlockPos(x, newY, newZ);
                }
            }
            z += dz;
            dx = dx < 0 ? Math.abs(dx) + 1 : (dx + 1) * -1;
            if (dz < 0) {
                dz = Math.abs(dz) + 1;
                continue;
            }
            dz = (dz + 1) * -1;
        }
        return null;
    }

    private static int getGround(World world, int x, int y, int z) {
        while ((world.func_175623_d(new BlockPos(x, y - 1, z)) || world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c().func_149688_o().func_76224_d() || world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c().func_149688_o().func_76222_j()) && y > 1) {
            --y;
        }
        return y;
    }

    private static boolean canGenerateGraveAtCoordinates(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c().func_149688_o().func_76220_a() && (world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_149688_o().func_76224_d() || world.func_180495_p(pos).func_177230_c().func_149688_o().func_76222_j());
    }

    protected static EnumGraves getGraveType(EnumGraveType[] graveTypes, EnumGraveMaterial ... materials) {
        EnumGraveType graveType = graveTypes[rand.nextInt(graveTypes.length)];
        EnumGraveMaterial material = materials[rand.nextInt(materials.length)];
        return EnumGraves.getByTypeAndMaterial(graveType, material);
    }

    private static ItemStack getSwordFromInventory(List<ItemStack> items) {
        if (items != null) {
            for (ItemStack stack : items) {
                if (stack == null || !swordsList.contains(stack.func_77973_b())) continue;
                ItemStack sword = stack.func_77946_l();
                items.remove(stack);
                return sword;
            }
        }
        return null;
    }

    private static class GraveInfoOnDeath {
        private EnumGraves grave;
        private ItemStack sword;
        private boolean enchanted;
        private boolean mossy;

        private GraveInfoOnDeath() {
        }

        public EnumGraves getGrave() {
            return this.grave;
        }

        public ItemStack getSword() {
            return this.sword;
        }

        public boolean isEnchanted() {
            return this.enchanted;
        }

        public boolean isMossy() {
            return this.mossy;
        }

        public void setGrave(EnumGraves grave) {
            this.grave = grave;
        }

        public void setSword(ItemStack sword) {
            this.sword = sword;
        }

        public void setEnchanted(boolean enchanted) {
            this.enchanted = enchanted;
        }

        public void setMossy(boolean mossy) {
            this.mossy = mossy;
        }
    }

    public static enum EnumGraveTypeByEntity {
        ALL_GRAVES,
        PLAYER_GRAVES,
        VILLAGERS_GRAVES,
        HUMAN_GRAVES,
        PETS_GRAVES,
        DOGS_GRAVES,
        CATS_GRAVES,
        HORSE_GRAVES;

    }
}

