/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import nightkosh.gravestone.helper.GraveGenerationHelper;

public class GraveInventoryHelper {
    private static final int[] POTION_LIST = new int[0];
    private static final int EGG_PIG = 90;
    private static final int EGG_SHEEP = 91;
    private static final int EGG_COW = 92;
    private static final int EGG_CHICKEN = 93;
    private static final int EGG_SQUID = 94;
    private static final int EGG_WOLF = 95;
    private static final int EGG_MUSHROOM_COW = 96;
    private static final int EGG_CAT = 98;
    private static final int EGG_HORSE = 100;
    private static final int EGG_VILLAGER = 120;

    public static GraveContentType getRandomGraveContentType(Random random) {
        int graveType = random.nextInt(80);
        if (graveType > 5) {
            return GraveContentType.WARRIOR;
        }
        if (graveType < 4) {
            return GraveContentType.ADVENTURER;
        }
        if (graveType < 7) {
            return GraveContentType.WORKER;
        }
        if (graveType < 10) {
            return GraveContentType.WIZARD;
        }
        if (graveType < 12) {
            return GraveContentType.MINER;
        }
        if (graveType == 13) {
            return GraveContentType.WARRIOR;
        }
        return null;
    }

    public static GraveCorpseContentType getRandomCorpseContentType(Random random) {
        return GraveCorpseContentType.BONES_AND_FLESH;
    }

    public static void addCorpse(Random random, List<ItemStack> itemList) {
    }

    public static void addBonesAndFlesh(Random random, List<ItemStack> itemList) {
        if (random.nextInt(2) == 0) {
            itemList.add(new ItemStack(Items.field_151144_bL, 1, 0));
        } else {
            itemList.add(new ItemStack(Items.field_151144_bL, 1, 2));
        }
    }

    public static void addSkull(Random random, List<ItemStack> itemList) {
        itemList.add(new ItemStack(Items.field_151103_aS, 1 + random.nextInt(5), 0));
        itemList.add(new ItemStack(Items.field_151078_bh, 1 + random.nextInt(5), 0));
    }

    public static void fillWarriorGrave(Random random, List<ItemStack> itemList, WarriorContentMaterials materials) {
        materials = WarriorContentMaterials.DIAMOND;
        switch (materials) {
            case LEATHER: {
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151027_R, 1, GraveInventoryHelper.getRandomDamage(random, 30)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151026_S, 1, GraveInventoryHelper.getRandomDamage(random, 30)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151024_Q, 1, GraveInventoryHelper.getRandomDamage(random, 30)));
                }
                if (random.nextInt(2) != 0) break;
                itemList.add(new ItemStack((Item)Items.field_151021_T, 1, GraveInventoryHelper.getRandomDamage(random, 30)));
                break;
            }
            case IRON: {
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151030_Z, 1, GraveInventoryHelper.getRandomDamage(random)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151165_aa, 1, GraveInventoryHelper.getRandomDamage(random)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151028_Y, 1, GraveInventoryHelper.getRandomDamage(random)));
                }
                if (random.nextInt(2) != 0) break;
                itemList.add(new ItemStack((Item)Items.field_151167_ab, 1, GraveInventoryHelper.getRandomDamage(random)));
                break;
            }
            case CHAINMAIL: {
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151023_V, 1, GraveInventoryHelper.getRandomDamage(random)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151022_W, 1, GraveInventoryHelper.getRandomDamage(random)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151020_U, 1, GraveInventoryHelper.getRandomDamage(random)));
                }
                if (random.nextInt(2) != 0) break;
                itemList.add(new ItemStack((Item)Items.field_151029_X, 1, GraveInventoryHelper.getRandomDamage(random)));
                break;
            }
            case GOLDEN: {
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151171_ah, 1, GraveInventoryHelper.getRandomDamage(random, 50)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151149_ai, 1, GraveInventoryHelper.getRandomDamage(random, 50)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151169_ag, 1, GraveInventoryHelper.getRandomDamage(random, 30)));
                }
                if (random.nextInt(2) != 0) break;
                itemList.add(new ItemStack((Item)Items.field_151151_aj, 1, GraveInventoryHelper.getRandomDamage(random, 40)));
                break;
            }
            case DIAMOND: {
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151163_ad, 1, GraveInventoryHelper.getRandomDamage(random)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151173_ae, 1, GraveInventoryHelper.getRandomDamage(random)));
                }
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack((Item)Items.field_151161_ac, 1, GraveInventoryHelper.getRandomDamage(random)));
                }
                if (random.nextInt(2) != 0) break;
                itemList.add(new ItemStack((Item)Items.field_151175_af, 1, GraveInventoryHelper.getRandomDamage(random)));
            }
        }
        if (random.nextInt(3) == 0) {
            itemList.add(new ItemStack((Item)Items.field_151031_f, 1, GraveInventoryHelper.getRandomDamage(random)));
            itemList.add(new ItemStack(Items.field_151032_g, 10 + random.nextInt(54), 0));
        }
    }

    public static void fillMinerGrave(Random random, List<ItemStack> itemList, ContentMaterials materials) {
        materials = ContentMaterials.DIAMOND;
        switch (materials) {
            case IRON: {
                itemList.add(new ItemStack(Items.field_151035_b, 1, GraveInventoryHelper.getRandomDamage(random)));
                break;
            }
            case GOLDEN: {
                itemList.add(new ItemStack(Items.field_151005_D, 1, GraveInventoryHelper.getRandomDamage(random, 15)));
                break;
            }
            case DIAMOND: {
                itemList.add(new ItemStack(Items.field_151046_w, 1, GraveInventoryHelper.getRandomDamage(random)));
            }
        }
        switch (random.nextInt(10)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151045_i, 1 + random.nextInt(3), 0));
                break;
            }
            case 1: {
                itemList.add(new ItemStack(Items.field_151166_bC, 1 + random.nextInt(3), 0));
            }
        }
        switch (random.nextInt(5)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151043_k, 3 + random.nextInt(5), 0));
                break;
            }
            case 1: 
            case 2: {
                itemList.add(new ItemStack(Items.field_151042_j, 3 + random.nextInt(5), 0));
            }
        }
        switch (random.nextInt(5)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151137_ax, 3 + random.nextInt(8), 0));
                break;
            }
            case 1: {
                itemList.add(new ItemStack(Items.field_151100_aR, 3 + random.nextInt(8), 4));
            }
        }
    }

    public static void fillWizardGrave(Random random, List<ItemStack> itemList) {
        switch (random.nextInt(10)) {
            case 0: {
                EnchantmentData data = new EnchantmentData(Enchantment.field_77331_b[random.nextInt(Enchantment.field_77331_b.length)], 1 + random.nextInt(5));
                ItemStack items = Items.field_151134_bR.func_92111_a(data);
                itemList.add(items);
                break;
            }
            case 1: {
                itemList.add(new ItemStack((Item)Items.field_151068_bn, 1 + random.nextInt(5), POTION_LIST[random.nextInt(POTION_LIST.length)]));
                break;
            }
            case 2: 
            case 3: {
                itemList.add(new ItemStack(Items.field_151122_aG, 3 + random.nextInt(8), 0));
            }
        }
        switch (random.nextInt(15)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151079_bi, 1, 0));
                break;
            }
            case 1: {
                itemList.add(new ItemStack(Items.field_151065_br, 1, 0));
                break;
            }
            case 2: {
                itemList.add(new ItemStack(Items.field_151114_aO, 3 + random.nextInt(8), 0));
            }
        }
        switch (random.nextInt(6)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151064_bs, 1, 0));
                break;
            }
            case 1: {
                itemList.add(new ItemStack(Items.field_151016_H, 1, 0));
            }
        }
        switch (random.nextInt(10)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151073_bk, 1, 0));
                break;
            }
            case 1: {
                itemList.add(new ItemStack(Items.field_151075_bm, 1, 0));
            }
        }
        switch (random.nextInt(5)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151070_bp, 1, 0));
                break;
            }
            case 1: {
                itemList.add(new ItemStack(Items.field_151071_bq, 1, 0));
            }
        }
        switch (random.nextInt(8)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151150_bK, 1, 0));
                break;
            }
            case 1: {
                itemList.add(new ItemStack(Items.field_151060_bw, 1, 0));
            }
        }
    }

    public static void fillWorkerGrave(Random random, List<ItemStack> itemList, ContentMaterials materials) {
        materials = ContentMaterials.DIAMOND;
        switch (materials) {
            case IRON: {
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack(Items.field_151036_c, 1, GraveInventoryHelper.getRandomDamage(random)));
                    break;
                }
                itemList.add(new ItemStack(Items.field_151037_a, 1, GraveInventoryHelper.getRandomDamage(random)));
                break;
            }
            case GOLDEN: {
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack(Items.field_151006_E, 1, GraveInventoryHelper.getRandomDamage(random, 15)));
                    break;
                }
                itemList.add(new ItemStack(Items.field_151011_C, 1, GraveInventoryHelper.getRandomDamage(random, 15)));
                break;
            }
            case DIAMOND: {
                if (random.nextInt(2) == 0) {
                    itemList.add(new ItemStack(Items.field_151056_x, 1, GraveInventoryHelper.getRandomDamage(random)));
                    break;
                }
                itemList.add(new ItemStack(Items.field_151047_v, 1, GraveInventoryHelper.getRandomDamage(random)));
            }
        }
        if (random.nextInt(8) == 0) {
            itemList.add(new ItemStack(Items.field_151141_av, 1, 0));
        }
    }

    public static void fillAdventureGrave(Random random, List<ItemStack> itemList) {
        switch (random.nextInt(8)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151111_aL, 1, 0));
                break;
            }
            case 1: {
                itemList.add(new ItemStack(Items.field_151113_aN, 1, 0));
                break;
            }
            case 2: {
                itemList.add(new ItemStack((Item)Items.field_151148_bJ, 1, 0));
            }
        }
        switch (random.nextInt(10)) {
            case 0: {
                itemList.add(new ItemStack(Items.field_151159_an, 1 + random.nextInt(5), 0));
                break;
            }
            case 1: {
                itemList.add(GraveInventoryHelper.getRandomRecord(random));
                break;
            }
            case 2: {
                itemList.add(new ItemStack(Items.field_151099_bA, 1, 0));
            }
        }
        if (random.nextInt(4) == 0) {
            itemList.add(new ItemStack(Items.field_151055_y, 3 + random.nextInt(9), 0));
        }
        if (random.nextInt(5) == 0) {
            itemList.add(new ItemStack(Items.field_151106_aX, 3 + random.nextInt(5), 0));
        }
        if (random.nextInt(15) == 0) {
            itemList.add(GraveInventoryHelper.getRandomEgg(random));
        }
    }

    public static void fillPetGrave(Random random, List<ItemStack> itemList) {
        if (random.nextInt(10) == 0) {
            itemList.add(new ItemStack(Items.field_151058_ca, 1, 0));
        }
        if (random.nextInt(10) == 0) {
            itemList.add(new ItemStack(Items.field_151057_cb, 1, 0));
        }
    }

    public static int getRandomDamage(Random random) {
        return 20 + random.nextInt(100);
    }

    public static int getRandomDamage(Random random, int maxDamage) {
        return random.nextInt(maxDamage);
    }

    private static ItemStack getRandomRecord(Random random) {
        switch (random.nextInt(13)) {
            case 1: {
                return new ItemStack(Items.field_151093_ce, 1, 0);
            }
            case 2: {
                return new ItemStack(Items.field_151094_cf, 1, 0);
            }
            case 3: {
                return new ItemStack(Items.field_151091_cg, 1, 0);
            }
            case 4: {
                return new ItemStack(Items.field_151092_ch, 1, 0);
            }
            case 5: {
                return new ItemStack(Items.field_151089_ci, 1, 0);
            }
            case 6: {
                return new ItemStack(Items.field_151090_cj, 1, 0);
            }
            case 7: {
                return new ItemStack(Items.field_151087_ck, 1, 0);
            }
            case 8: {
                return new ItemStack(Items.field_151088_cl, 1, 0);
            }
            case 9: {
                return new ItemStack(Items.field_151085_cm, 1, 0);
            }
            case 10: {
                return new ItemStack(Items.field_151086_cn, 1, 0);
            }
            case 11: {
                return new ItemStack(Items.field_151084_co, 1, 0);
            }
            case 12: {
                return new ItemStack(Items.field_151096_cd, 1, 0);
            }
        }
        return new ItemStack(Items.field_151093_ce, 1, 0);
    }

    private static ItemStack getRandomEgg(Random random) {
        switch (random.nextInt(11)) {
            case 1: {
                return new ItemStack(Items.field_151063_bx, 1, 90);
            }
            case 2: {
                return new ItemStack(Items.field_151063_bx, 1, 91);
            }
            case 3: {
                return new ItemStack(Items.field_151063_bx, 1, 92);
            }
            case 4: {
                return new ItemStack(Items.field_151063_bx, 1, 93);
            }
            case 5: {
                return new ItemStack(Items.field_151063_bx, 1, 94);
            }
            case 6: {
                return new ItemStack(Items.field_151063_bx, 1, 95);
            }
            case 7: {
                return new ItemStack(Items.field_151063_bx, 1, 96);
            }
            case 8: {
                return new ItemStack(Items.field_151063_bx, 1, 98);
            }
            case 9: {
                return new ItemStack(Items.field_151063_bx, 1, 100);
            }
            case 10: {
                return new ItemStack(Items.field_151063_bx, 1, 120);
            }
        }
        return new ItemStack(Items.field_151063_bx, 1, 120);
    }

    public static List<ItemStack> getRandomGraveContent(Random random, GraveGenerationHelper.EnumGraveTypeByEntity graveTypeByEntity, GraveContentType contentType, GraveCorpseContentType corpseType, IContentMaterials contentMaterials) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (corpseType == GraveCorpseContentType.RANDOM) {
            corpseType = GraveInventoryHelper.getRandomCorpseContentType(random);
        }
        switch (corpseType) {
            case CORPSE: {
                GraveInventoryHelper.addCorpse(random, itemList);
                break;
            }
            case BONES_AND_FLESH: {
                GraveInventoryHelper.addBonesAndFlesh(random, itemList);
                break;
            }
            case SKULL_BONES_AND_FLESH: {
                GraveInventoryHelper.addSkull(random, itemList);
                GraveInventoryHelper.addBonesAndFlesh(random, itemList);
            }
        }
        if (graveTypeByEntity == GraveGenerationHelper.EnumGraveTypeByEntity.DOGS_GRAVES || graveTypeByEntity == GraveGenerationHelper.EnumGraveTypeByEntity.CATS_GRAVES || graveTypeByEntity == GraveGenerationHelper.EnumGraveTypeByEntity.HORSE_GRAVES) {
            GraveInventoryHelper.fillPetGrave(random, itemList);
        } else {
            if (contentType == GraveContentType.RANDOM) {
                contentType = GraveInventoryHelper.getRandomGraveContentType(random);
            }
            switch (contentType) {
                case WORKER: {
                    GraveInventoryHelper.fillWorkerGrave(random, itemList, (ContentMaterials)contentMaterials);
                    break;
                }
                case MINER: {
                    GraveInventoryHelper.fillMinerGrave(random, itemList, (ContentMaterials)contentMaterials);
                    break;
                }
                case WIZARD: {
                    GraveInventoryHelper.fillWizardGrave(random, itemList);
                    break;
                }
                case WARRIOR: {
                    GraveInventoryHelper.fillWarriorGrave(random, itemList, (WarriorContentMaterials)contentMaterials);
                    break;
                }
                case ADVENTURER: {
                    GraveInventoryHelper.fillAdventureGrave(random, itemList);
                    break;
                }
                case TREASURY: {
                    break;
                }
            }
        }
        return itemList;
    }

    public static enum WarriorContentMaterials implements IContentMaterials
    {
        LEATHER,
        IRON,
        CHAINMAIL,
        GOLDEN,
        DIAMOND;

    }

    public static enum ContentMaterials implements IContentMaterials
    {
        EMPTY,
        IRON,
        GOLDEN,
        DIAMOND;

    }

    public static interface IContentMaterials {
    }

    public static enum GraveContentType {
        RANDOM,
        WORKER,
        MINER,
        WIZARD,
        WARRIOR,
        ADVENTURER,
        TREASURY,
        JUNK;

    }

    public static enum GraveCorpseContentType {
        EMPTY,
        CORPSE,
        BONES_AND_FLESH,
        SKULL_BONES_AND_FLESH,
        RANDOM;

    }
}

