/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.helper;

import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import nightkosh.gravestone.api.grave.EnumGraveType;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.GSBlock;
import nightkosh.gravestone.inventory.GraveInventory;
import nightkosh.gravestone.tileentity.TileEntityGraveStone;

public class GraveStoneHelper {
    public static final List<BlockFlower> FLOWERS = Arrays.asList(Blocks.field_150327_N, Blocks.field_150328_O);

    public static void replaceGround(World world, BlockPos pos) {
        Block botBlock = world.func_180495_p(pos).func_177230_c();
        if (botBlock.equals(Blocks.field_150349_c) || botBlock.equals(Blocks.field_150391_bh)) {
            world.func_175656_a(pos, Blocks.field_150346_d.func_176194_O().func_177621_b());
        }
    }

    public static void spawnMob(World world, BlockPos pos) {
    }

    public static boolean canPlaceBlockAt(World world, BlockPos pos) {
        return GraveStoneHelper.canPlaceBlockAt(world, world.func_180495_p(pos).func_177230_c(), pos);
    }

    public static boolean canPlaceBlockAt(World world, Block block, BlockPos pos) {
        if (Config.canPlaceGravesEveryWhere) {
            return true;
        }
        String tool = block.getHarvestTool(world.func_180495_p(pos));
        return tool != null && tool.equals("shovel");
    }

    public static void addSwordInfo(NBTTagCompound nbt, ItemStack sword) {
        NBTTagCompound swordNBT = new NBTTagCompound();
        sword.func_77955_b(swordNBT);
        nbt.func_74782_a("Sword", (NBTBase)swordNBT);
    }

    public static ItemStack getSwordAsGrave(Item grave, ItemStack sword) {
        ItemStack graveStoneStack = new ItemStack(grave, 1, EnumGraves.SWORD.ordinal());
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("Purified", false);
        GraveStoneHelper.addSwordInfo(nbt, sword);
        graveStoneStack.func_77982_d(nbt);
        return graveStoneStack;
    }

    public static boolean canFlowerBePlaced(World world, BlockPos pos, ItemStack itemStack, TileEntityGraveStone te) {
        if (GraveStoneHelper.canFlowerBePlacedOnGrave(te)) {
            Item item = itemStack.func_77973_b();
            if (Block.func_149634_a((Item)item) instanceof BlockFlower) {
                return true;
            }
            if (item instanceof IPlantable) {
                return Block.func_149634_a((Item)item).canSustainPlant((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)item);
            }
        }
        return false;
    }

    public static boolean canFlowerBePlacedOnGrave(TileEntityGraveStone te) {
        return !te.isSwordGrave() && (te.getGraveType().getGraveType() == EnumGraveType.VERTICAL_PLATE || te.getGraveType().getGraveType() == EnumGraveType.CROSS || te.getGraveType().getGraveType() == EnumGraveType.CELTIC_CROSS);
    }

    public static void dropBlock(World world, BlockPos pos, IBlockState state) {
        ItemStack itemStack = GraveStoneHelper.getBlockItemStack((IBlockAccess)world, pos, state);
        if (itemStack != null) {
            GraveInventory.dropItem(itemStack, world, pos);
        }
    }

    public static void dropBlockWithoutInfo(World world, BlockPos pos, IBlockState state) {
        ItemStack itemStack = GSBlock.graveStone.func_180643_i(GSBlock.graveStone.func_176223_P());
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)world.func_175625_s(pos);
        if (tileEntity != null) {
            if (tileEntity.isSwordGrave()) {
                tileEntity.dropSword();
            } else if (itemStack != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                itemStack.func_77964_b(tileEntity.getGraveTypeNum());
                nbt.func_74757_a("Mossy", tileEntity.isMossy());
                nbt.func_74757_a("Purified", true);
                itemStack.func_77982_d(nbt);
                GraveInventory.dropItem(itemStack, world, pos);
            }
        }
    }

    public static ItemStack getBlockItemStack(IBlockAccess access, BlockPos pos, IBlockState state) {
        ItemStack itemStack = GSBlock.graveStone.func_180643_i(GSBlock.graveStone.func_176223_P());
        TileEntityGraveStone tileEntity = (TileEntityGraveStone)access.func_175625_s(pos);
        if (tileEntity != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            itemStack.func_77964_b(tileEntity.getGraveTypeNum());
            if (tileEntity.getDeathTextComponent().isLocalized()) {
                nbt.func_74757_a("isLocalized", true);
                nbt.func_74778_a("name", tileEntity.getDeathTextComponent().getName());
                nbt.func_74778_a("KillerName", tileEntity.getDeathTextComponent().getKillerName());
            }
            nbt.func_74778_a("DeathText", tileEntity.getDeathTextComponent().getDeathText());
            nbt.func_74768_a("Age", tileEntity.getAge());
            if (tileEntity.isSwordGrave()) {
                GraveStoneHelper.addSwordInfo(nbt, tileEntity.getSword());
            }
            nbt.func_74757_a("Enchanted", tileEntity.isEnchanted());
            nbt.func_74757_a("Mossy", tileEntity.isMossy());
            nbt.func_74757_a("Purified", true);
            itemStack.func_77982_d(nbt);
        }
        return itemStack;
    }

    public static class RestrictedArea {
        private final BlockPos firstPoint;
        private final BlockPos lastPoint;

        public RestrictedArea(int startX, int startY, int startZ, int endX, int endY, int endZ) {
            this.firstPoint = new BlockPos(startX, startY, startZ);
            this.lastPoint = new BlockPos(endX, endY, endZ);
        }

        public boolean isInArea(BlockPos pos) {
            return pos.func_177958_n() >= this.firstPoint.func_177958_n() && pos.func_177958_n() <= this.lastPoint.func_177958_n() && pos.func_177956_o() >= this.firstPoint.func_177956_o() && pos.func_177956_o() <= this.lastPoint.func_177956_o() && pos.func_177952_p() >= this.firstPoint.func_177952_p() && pos.func_177952_p() <= this.lastPoint.func_177952_p();
        }

        public static RestrictedArea getFromString(String area) {
            String[] coordinates = area.split(",");
            if (coordinates.length == 6) {
                try {
                    return new RestrictedArea(Integer.parseInt(coordinates[0]), Integer.parseInt(coordinates[1]), Integer.parseInt(coordinates[2]), Integer.parseInt(coordinates[3]), Integer.parseInt(coordinates[4]), Integer.parseInt(coordinates[5]));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
    }
}

