/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.tileentity;

import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import nightkosh.gravestone.tileentity.ISpawnerEntity;

public abstract class Spawner {
    protected ISpawnerEntity spawnerEntity;
    protected int delay;
    protected Entity spawnedMob;

    public Spawner(ISpawnerEntity tileEntity, int delay) {
        this.spawnerEntity = tileEntity;
        this.delay = delay;
    }

    public void update() {
        if (!this.spawnerEntity.getWorld().func_175659_aa().equals((Object)EnumDifficulty.PEACEFUL) && !this.spawnerEntity.getWorld().field_72995_K) {
            this.serverUpdateLogic();
        }
    }

    public void updateDelay() {
        this.delay = this.getMinDelay() + this.spawnerEntity.getWorld().field_73012_v.nextInt(this.getMaxDelay() - this.getMinDelay());
    }

    protected void setMinDelay() {
        this.delay = this.getMinDelay();
    }

    protected int getNearbyMobsCount() {
        return this.spawnerEntity.getWorld().func_72872_a(this.spawnedMob.getClass(), AxisAlignedBB.func_178781_a((double)this.spawnerEntity.getPos().func_177958_n(), (double)this.spawnerEntity.getPos().func_177956_o(), (double)this.spawnerEntity.getPos().func_177952_p(), (double)(this.spawnerEntity.getPos().func_177958_n() + 1), (double)(this.spawnerEntity.getPos().func_177956_o() + 1), (double)(this.spawnerEntity.getPos().func_177952_p() + 1)).func_72314_b(1.0, 4.0, (double)(this.getSpawnRange() * 2))).size();
    }

    protected boolean anyPlayerInRange() {
        return this.spawnerEntity.getWorld().func_72977_a((double)this.spawnerEntity.getPos().func_177958_n() + 0.5, (double)this.spawnerEntity.getPos().func_177956_o() + 0.5, (double)this.spawnerEntity.getPos().func_177952_p() + 0.5, (double)this.getPlayerRange()) != null;
    }

    protected abstract boolean canSpawnMobs(World var1);

    protected abstract int getPlayerRange();

    protected abstract int getSpawnRange();

    protected abstract int getMinDelay();

    protected abstract int getMaxDelay();

    protected abstract Entity getMob();

    protected abstract void clientUpdateLogic();

    protected abstract void serverUpdateLogic();
}

