/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import nightkosh.gravestone.block.enums.EnumGraves;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.helper.GroupOfGravesSpawnerHelper;
import nightkosh.gravestone.helper.IFog;
import nightkosh.gravestone.helper.ISpawner;
import nightkosh.gravestone.inventory.GraveInventory;
import nightkosh.gravestone.tileentity.ISpawnerEntity;
import nightkosh.gravestone.tileentity.TileEntityGrave;
import org.apache.commons.lang3.StringUtils;

public class TileEntityGraveStone
extends TileEntityGrave
implements ITickable,
ISpawnerEntity {
    protected ItemStack sword = null;
    protected ItemStack flower = null;
    protected String playerId = "";
    protected boolean isPurified = false;
    protected int spawnerHelperId;
    protected GroupOfGravesSpawnerHelper spawnerHelper;
    protected ISpawner spawner = new ISpawner(){};
    public static IFog fogHandler = new IFog(){};

    public TileEntityGraveStone() {
        this.spawner = this.spawner.getSpawner(this);
        this.inventory = new GraveInventory(this);
    }

    public TileEntityGraveStone(World world) {
        this.field_145850_b = world;
        this.spawner = this.spawner.getSpawner(this);
        this.inventory = new GraveInventory(this);
    }

    public void func_73660_a() {
        if (this.spawnerHelperId != 0 && this.spawnerHelper == null) {
            this.spawnerHelper = (GroupOfGravesSpawnerHelper)this.func_145831_w().func_73045_a(this.spawnerHelperId);
        }
        this.spawner.update();
        fogHandler.addFog(this.field_145850_b, this.field_174879_c);
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1 && this.field_145850_b.field_72995_K) {
            this.spawner.setMinDelay();
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.age = nbtTag.func_74762_e("Age");
        this.inventory.readItems(nbtTag);
        this.deathText.readText(nbtTag);
        this.readSwordInfo(nbtTag);
        this.readFlowerInfo(nbtTag);
        this.playerId = nbtTag.func_74779_i("PlayerId");
        this.isPurified = nbtTag.func_74767_n("Purified");
        if (nbtTag.func_74764_b("SpawnerHelperId")) {
            this.spawnerHelperId = nbtTag.func_74762_e("SpawnerHelperId");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        nbtTag.func_74768_a("Age", this.age);
        this.inventory.saveItems(nbtTag);
        this.deathText.saveText(nbtTag);
        this.writeSwordInfo(nbtTag);
        this.writeFlowerInfo(nbtTag);
        nbtTag.func_74778_a("PlayerId", this.playerId);
        nbtTag.func_74757_a("Purified", this.isPurified);
        if (this.haveSpawnerHelper()) {
            nbtTag.func_74768_a("SpawnerHelperId", this.spawnerHelper.func_145782_y());
        }
    }

    private void readSwordInfo(NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("Sword")) {
            this.sword = ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l("Sword"));
        }
    }

    private void writeSwordInfo(NBTTagCompound nbtTag) {
        if (this.sword != null) {
            NBTTagCompound swordNBT = new NBTTagCompound();
            this.sword.func_77955_b(swordNBT);
            nbtTag.func_74782_a("Sword", (NBTBase)swordNBT);
        }
    }

    private void readFlowerInfo(NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("Flower")) {
            this.flower = ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l("Flower"));
        }
    }

    private void writeFlowerInfo(NBTTagCompound nbtTag) {
        if (this.flower != null) {
            NBTTagCompound flowerNBT = new NBTTagCompound();
            this.flower.func_77955_b(flowerNBT);
            nbtTag.func_74782_a("Flower", (NBTBase)flowerNBT);
        }
    }

    public ItemStack getSword() {
        return this.sword;
    }

    public void setSword(ItemStack sword) {
        this.sword = sword;
    }

    public void dropSword() {
        if (this.sword != null) {
            GraveInventory.dropItem(this.sword, this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean isSwordGrave() {
        return this.sword != null;
    }

    public ItemStack getFlower() {
        return this.flower;
    }

    public void setFlower(ItemStack flower) {
        this.flower = flower;
    }

    public void dropFlower() {
        if (this.flower != null) {
            GraveInventory.dropItem(this.flower, this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean hasFlower() {
        return this.flower != null;
    }

    public EnumGraves getGraveType() {
        return EnumGraves.getById(this.graveType);
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public void setOwner(String playerId) {
        this.playerId = playerId;
    }

    public boolean canBeLooted(String playerId) {
        return !Config.onlyOwnerCanLootGrave || StringUtils.isBlank((CharSequence)this.playerId) || playerId.equals(this.playerId) || this.inventory.getGraveContent().isEmpty();
    }

    @Override
    public boolean haveSpawnerHelper() {
        return this.spawnerHelperId != 0;
    }

    @Override
    public GroupOfGravesSpawnerHelper getSpawnerHelper() {
        return this.spawnerHelper;
    }

    public void setSpawnerHelper(GroupOfGravesSpawnerHelper spawnerHelper) {
        this.spawnerHelper = spawnerHelper;
    }

    public boolean isPurified() {
        return this.isPurified;
    }

    public void setPurified(boolean isPurified) {
        this.isPurified = isPurified;
    }

    public static class Sword
    extends TileEntityGraveStone {
    }

    public static class WitheredCorpse
    extends TileEntityGraveStone {
    }

    public static class StarvedCorpse
    extends TileEntityGraveStone {
    }

    public static class CreeperStatue
    extends TileEntityGraveStone {
    }

    public static class HorseStatue
    extends TileEntityGraveStone {
    }

    public static class CatStatue
    extends TileEntityGraveStone {
    }

    public static class DogStatue
    extends TileEntityGraveStone {
    }

    public static class VillagerStatue
    extends TileEntityGraveStone {
    }

    public static class HorizontalPlate
    extends TileEntityGraveStone {
    }

    public static class CelticCross
    extends TileEntityGraveStone {
    }

    public static class Obelisk
    extends TileEntityGraveStone {
    }

    public static class Cross
    extends TileEntityGraveStone {
    }

    public static class VerticalPlate
    extends TileEntityGraveStone {
    }
}

