/*
 * Decompiled with CFR 0.152.
 */
package nightkosh.gravestone;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import nightkosh.gravestone.api.GraveStoneAPI;
import nightkosh.gravestone.api.IGraveGeneration;
import nightkosh.gravestone.api.IGraveStoneHelper;
import nightkosh.gravestone.config.Config;
import nightkosh.gravestone.core.GSBlock;
import nightkosh.gravestone.core.GSTileEntity;
import nightkosh.gravestone.core.GuiHandler;
import nightkosh.gravestone.core.Tabs;
import nightkosh.gravestone.core.commands.Commands;
import nightkosh.gravestone.core.compatibility.Compatibility;
import nightkosh.gravestone.core.event.EventHandlerNetwork;
import nightkosh.gravestone.core.event.EventsHandler;
import nightkosh.gravestone.core.proxy.CommonProxy;
import nightkosh.gravestone.helper.GraveGenerationHelper;
import nightkosh.gravestone.helper.api.APIGraveGeneration;

@Mod(modid="GraveStone", name="GraveStone", version="1.0.0", updateJSON="https://raw.githubusercontent.com/NightKosh/GraveStone-mod/master/update.json", acceptedMinecraftVersions="[1.8.9]")
public class ModGraveStone {
    @Mod.Instance(value="GraveStone")
    public static ModGraveStone instance;
    @SidedProxy(clientSide="nightkosh.gravestone.core.proxy.ClientProxy", serverSide="nightkosh.gravestone.core.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static final IGraveStoneHelper gravestoneHelper;
    public static final IGraveGeneration apiGraveGeneration;

    public ModGraveStone() {
        instance = this;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.getInstance(event.getModConfigurationDirectory().getAbsolutePath() + "/GraveStoneMod/", "GraveStone.cfg");
        GraveStoneAPI.graveStone = gravestoneHelper;
        GraveStoneAPI.graveGenerationAtDeath = apiGraveGeneration;
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new EventsHandler());
        FMLCommonHandler.instance().bus().register((Object)new EventHandlerNetwork());
        proxy.registerHandlers();
        Tabs.registration();
        GSBlock.registration();
        GSTileEntity.registration();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Compatibility.getInstance();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        Commands.getInstance(event);
    }

    static {
        gravestoneHelper = GraveGenerationHelper.INSTANCE;
        apiGraveGeneration = APIGraveGeneration.INSTANCE;
    }
}

